/*
 * Decompiled with CFR 0.152.
 */
package owl.collections;

import java.util.List;
import java.util.stream.Stream;
import owl.util.annotation.CEntryPoint;

public abstract class LabelledTree<L1, L2> {
    private LabelledTree() {
    }

    public abstract Stream<L2> leavesStream();

    public static final class Node<L1, L2>
    extends LabelledTree<L1, L2> {
        private final L1 label;
        private final List<LabelledTree<L1, L2>> children;

        public Node(L1 label, List<LabelledTree<L1, L2>> children) {
            this.label = label;
            this.children = List.copyOf(children);
        }

        @CEntryPoint
        public L1 getLabel() {
            return this.label;
        }

        @CEntryPoint
        public List<LabelledTree<L1, L2>> getChildren() {
            return this.children;
        }

        @Override
        public Stream<L2> leavesStream() {
            return this.children.stream().flatMap(LabelledTree::leavesStream);
        }
    }

    public static final class Leaf<L1, L2>
    extends LabelledTree<L1, L2> {
        private final L2 label;

        public Leaf(L2 label) {
            this.label = label;
        }

        @CEntryPoint
        public L2 getLabel() {
            return this.label;
        }

        @Override
        public Stream<L2> leavesStream() {
            return Stream.of(this.label);
        }
    }
}

