/*
 * Decompiled with CFR 0.152.
 */
package owl.collections;

import com.google.common.base.Preconditions;
import it.unimi.dsi.fastutil.longs.LongArrayList;
import it.unimi.dsi.fastutil.longs.LongCollection;
import it.unimi.dsi.fastutil.longs.LongList;
import it.unimi.dsi.fastutil.longs.LongListIterator;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.util.Arrays;
import java.util.BitSet;
import java.util.List;
import java.util.stream.Collectors;

public final class UpwardClosedSet {
    private static final long[] EMPTY_ARRAY = new long[0];
    private static final long[][] EMPTY_BUCKETS = new long[0][];
    private static final UpwardClosedSet EMPTY = new UpwardClosedSet();
    private static final UpwardClosedSet UNIVERSE = new UpwardClosedSet(0L);
    private final long[][] buckets;

    private UpwardClosedSet() {
        this.buckets = EMPTY_BUCKETS;
        this.checkInvariants();
    }

    private UpwardClosedSet(long element) {
        int i = Long.bitCount(element);
        this.buckets = new long[i + 1][];
        Arrays.fill((Object[])this.buckets, EMPTY_ARRAY);
        this.buckets[i] = new long[]{element};
        this.checkInvariants();
    }

    private UpwardClosedSet(LongList[] buckets) {
        int size;
        for (size = buckets.length; 0 < size && buckets[size - 1] == null; --size) {
        }
        this.buckets = new long[size][];
        Arrays.setAll(this.buckets, i -> {
            LongList bucket = buckets[i];
            return bucket == null ? EMPTY_ARRAY : bucket.toLongArray();
        });
        this.checkInvariants();
    }

    public static UpwardClosedSet of() {
        return EMPTY;
    }

    public static UpwardClosedSet of(BitSet bitSet) {
        Preconditions.checkArgument((bitSet.length() <= 64 ? 1 : 0) != 0);
        if (bitSet.isEmpty()) {
            return UNIVERSE;
        }
        return new UpwardClosedSet(bitSet.toLongArray()[0]);
    }

    public boolean contains(BitSet bitSet) {
        Preconditions.checkArgument((bitSet.length() <= 64 ? 1 : 0) != 0);
        long element = bitSet.isEmpty() ? 0L : bitSet.toLongArray()[0];
        long[][] lArray = this.buckets;
        int n = lArray.length;
        for (int i = 0; i < n; ++i) {
            long[] bucket;
            for (long set : bucket = lArray[i]) {
                if ((element | set) != element) continue;
                return true;
            }
        }
        return false;
    }

    public UpwardClosedSet intersection(UpwardClosedSet otherSet) {
        LongList[] newBuckets = new LongList[this.buckets.length * otherSet.buckets.length];
        LongOpenHashSet seenElements = new LongOpenHashSet();
        for (long[] bucket1 : this.buckets) {
            for (long[] bucket2 : otherSet.buckets) {
                for (long element1 : bucket1) {
                    for (long element2 : bucket2) {
                        long intersection = element1 | element2;
                        if (!seenElements.add(intersection)) continue;
                        UpwardClosedSet.insert(newBuckets, intersection);
                    }
                }
            }
        }
        return new UpwardClosedSet(newBuckets);
    }

    public List<BitSet> representatives() {
        return Arrays.stream(this.buckets).flatMapToLong(Arrays::stream).mapToObj(x -> BitSet.valueOf(new long[]{x})).collect(Collectors.toUnmodifiableList());
    }

    public UpwardClosedSet union(UpwardClosedSet otherSet) {
        if (otherSet.buckets.length > this.buckets.length) {
            return otherSet.union(this);
        }
        LongList[] newBuckets = new LongList[this.buckets.length];
        LongOpenHashSet seenElements = new LongOpenHashSet();
        Arrays.setAll(newBuckets, arg_0 -> this.lambda$union$2((LongSet)seenElements, arg_0));
        long[][] lArray = otherSet.buckets;
        int n = lArray.length;
        for (int i = 0; i < n; ++i) {
            long[] bucket;
            for (long element : bucket = lArray[i]) {
                if (seenElements.contains(element)) continue;
                UpwardClosedSet.insert(newBuckets, element);
            }
        }
        return new UpwardClosedSet(newBuckets);
    }

    private void checkInvariants() {
        for (int i = 0; i < this.buckets.length; ++i) {
            for (long element : this.buckets[i]) {
                assert (Long.bitCount(element) == i);
            }
        }
    }

    private static void insert(LongList[] buckets, long newElement) {
        long oldElement;
        LongListIterator iterator;
        LongList bucket;
        int i;
        int bitCount = Long.bitCount(newElement);
        for (i = 0; i < bitCount; ++i) {
            bucket = buckets[i];
            if (bucket == null) continue;
            iterator = bucket.iterator();
            while (iterator.hasNext()) {
                oldElement = iterator.nextLong();
                if (((oldElement ^ 0xFFFFFFFFFFFFFFFFL) & newElement) != 0L) continue;
                return;
            }
        }
        for (i = bitCount + 1; i < buckets.length; ++i) {
            bucket = buckets[i];
            if (bucket == null) continue;
            iterator = bucket.iterator();
            while (iterator.hasNext()) {
                oldElement = iterator.nextLong();
                if ((oldElement & (newElement ^ 0xFFFFFFFFFFFFFFFFL)) != 0L) continue;
                iterator.remove();
            }
        }
        LongList bucket2 = buckets[bitCount];
        if (bucket2 == null) {
            bucket2 = new LongArrayList();
            bucket2.add(newElement);
            buckets[bitCount] = bucket2;
        } else {
            bucket2.add(newElement);
        }
    }

    private /* synthetic */ LongList lambda$union$2(LongSet seenElements, int i) {
        LongArrayList bucket = new LongArrayList(this.buckets[i]);
        seenElements.addAll((LongCollection)bucket);
        return bucket;
    }
}

