/*
 * Decompiled with CFR 0.152.
 */
package owl.factories.jbdd;

import de.tum.in.jbdd.Bdd;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.logging.Level;
import java.util.logging.Logger;

class GcManagedFactory<V extends BddWrapper> {
    private static final Logger logger = Logger.getLogger(GcManagedFactory.class.getName());
    final Bdd factory;
    private final Int2ObjectMap<BddReference<V>> gcObjects = new Int2ObjectOpenHashMap();
    private final Int2ObjectMap<V> nonGcObjects = new Int2ObjectOpenHashMap();
    private final ReferenceQueue<V> queue = new ReferenceQueue();

    GcManagedFactory(Bdd factory) {
        this.factory = factory;
    }

    V canonicalize(V wrapper) {
        int bdd = wrapper.bdd();
        if (this.factory.isNodeRoot(bdd) || this.factory.isVariableOrNegated(bdd)) {
            assert (this.factory.getReferenceCount(bdd) == -1) : GcManagedFactory.reportReferenceCountMismatch(-1, this.factory.getReferenceCount(bdd));
            return (V)((BddWrapper)this.nonGcObjects.merge(bdd, wrapper, (oldWrapper, newWrapper) -> oldWrapper));
        }
        BddReference canonicalReference = (BddReference)this.gcObjects.get(bdd);
        if (canonicalReference == null) {
            assert (this.factory.getReferenceCount(bdd) == 0) : GcManagedFactory.reportReferenceCountMismatch(0, this.factory.getReferenceCount(bdd));
            this.factory.reference(bdd);
        } else {
            assert (this.factory.getReferenceCount(bdd) == 1) : GcManagedFactory.reportReferenceCountMismatch(1, this.factory.getReferenceCount(bdd));
            BddWrapper canonicalWrapper = (BddWrapper)canonicalReference.get();
            if (canonicalWrapper == null) {
                canonicalReference.enqueue();
            } else {
                assert (bdd == canonicalWrapper.bdd());
                return (V)canonicalWrapper;
            }
        }
        assert (this.factory.getReferenceCount(bdd) == 1);
        this.processReferenceQueue(bdd);
        this.gcObjects.put(bdd, new BddReference<V>(wrapper, this.queue));
        assert (this.factory.getReferenceCount(bdd) == 1);
        return wrapper;
    }

    private void processReferenceQueue(int protectedBdd) {
        Reference<V> reference = this.queue.poll();
        if (reference == null) {
            return;
        }
        int count = 0;
        do {
            int bdd = ((BddReference)reference).bdd;
            this.gcObjects.remove(bdd);
            if (bdd == protectedBdd) continue;
            assert (this.factory.getReferenceCount(bdd) == 1);
            this.factory.dereference(bdd);
            assert (this.factory.getReferenceCount(bdd) == 0);
            ++count;
        } while ((reference = this.queue.poll()) != null);
        logger.log(Level.FINEST, "Cleared {0} references", count);
    }

    private static String reportReferenceCountMismatch(int expected, int actual) {
        return String.format("Expected reference count {%d}, but actual count is {%d}.", expected, actual);
    }

    static interface BddWrapper {
        public int bdd();
    }

    private static final class BddReference<V extends BddWrapper>
    extends WeakReference<V> {
        private final int bdd;

        private BddReference(V wrapper, ReferenceQueue<? super V> queue) {
            super(wrapper, queue);
            this.bdd = wrapper.bdd();
        }
    }
}

