/*
 * Decompiled with CFR 0.152.
 */
package owl.game.output;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import de.tum.in.naturals.Indices;
import java.io.BufferedWriter;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.List;
import owl.game.output.Aig;
import owl.game.output.AigConsumer;
import owl.game.output.LabelledAig;

public class AigerPrinter
implements AigConsumer {
    private final boolean binaryOutput;
    private final List<String> inputNames;
    private final List<LabelledAig> latches;
    private final List<String> latchNames;
    private final List<LabelledAig> outputs;
    private final List<String> outputNames;
    private final List<String> comments;

    public AigerPrinter(boolean binaryOutput) {
        this.binaryOutput = binaryOutput;
        this.inputNames = new ArrayList<String>();
        this.latches = new ArrayList<LabelledAig>();
        this.latchNames = new ArrayList<String>();
        this.outputs = new ArrayList<LabelledAig>();
        this.outputNames = new ArrayList<String>();
        this.comments = new ArrayList<String>();
    }

    private static int visitAig(BiMap<Aig, Integer> index, int startIndex, Aig root) {
        assert (root != null);
        ArrayDeque<Aig> toVisit = new ArrayDeque<Aig>();
        if (index.get((Object)root) == null) {
            toVisit.push(root);
        }
        int maxIndex = startIndex;
        while (!toVisit.isEmpty()) {
            assert (toVisit.peek() != null);
            if (((Aig)toVisit.peek()).isVariable() || ((Aig)toVisit.peek()).isConstant()) {
                toVisit.pop();
                continue;
            }
            if (index.get((Object)((Aig)toVisit.peek()).left()) == null) {
                assert (((Aig)toVisit.peek()).left() != null) : "All internal nodes should have exactly two children";
                toVisit.push(((Aig)toVisit.peek()).left());
                continue;
            }
            if (index.get((Object)((Aig)toVisit.peek()).right()) == null) {
                assert (((Aig)toVisit.peek()).right() != null) : "All internal nodes should have exactly two children";
                toVisit.push(((Aig)toVisit.peek()).right());
                continue;
            }
            index.put((Object)((Aig)toVisit.pop()), (Object)maxIndex);
            maxIndex += 2;
        }
        return maxIndex;
    }

    private static int aig2lit(BiMap<Aig, Integer> index, LabelledAig aig) {
        Integer i = (Integer)index.get((Object)aig.aig());
        assert (i != null) : "Make sure the element is in the computed map!";
        return aig.isNegated() ? i + 1 : i;
    }

    private static void encode(PrintWriter writer, int x) {
        char ch;
        int i = x;
        while ((i & 0xFFFFFF80) != 0) {
            ch = (char)(i & 0x7F | 0x80);
            writer.write(ch);
            i >>= 7;
        }
        ch = (char)i;
        writer.write(ch);
    }

    private static int aig2lit(BiMap<Aig, Integer> index, Aig aig, boolean negated) {
        Integer i = (Integer)index.get((Object)aig);
        assert (i != null) : "Make sure the element is in the computed map!";
        return negated ? i + 1 : i;
    }

    @Override
    public int addInput(String name) {
        this.inputNames.add(name);
        return this.inputNames.size();
    }

    @Override
    public int addLatch(String names, LabelledAig circuit) {
        this.latchNames.add(names);
        this.latches.add(circuit);
        return this.inputNames.size() + this.latchNames.size();
    }

    @Override
    public void addOutput(String name, LabelledAig circuit) {
        this.outputNames.add(name);
        this.outputs.add(circuit);
    }

    @Override
    public void addComment(String comment) {
        this.comments.add(comment);
    }

    public void print(OutputStream os) {
        PrintWriter writer = new PrintWriter(new BufferedWriter(new OutputStreamWriter(os, StandardCharsets.UTF_8)));
        this.print(writer);
        writer.flush();
    }

    public void print(PrintWriter writer) {
        int i;
        HashBiMap index = HashBiMap.create();
        index.put((Object)Aig.FALSE, (Object)0);
        int maxIndex = (this.inputNames.size() + this.latches.size() + 1) * 2;
        int varIndex = 2;
        for (i = 1; i <= this.inputNames.size(); ++i) {
            index.put((Object)Aig.leaf(i), (Object)varIndex);
            varIndex += 2;
        }
        for (i = 1; i <= this.latchNames.size(); ++i) {
            index.put((Object)Aig.leaf(i + this.inputNames.size()), (Object)varIndex);
            maxIndex = AigerPrinter.visitAig((BiMap<Aig, Integer>)index, maxIndex, this.latches.get(i - 1).aig());
            varIndex += 2;
        }
        for (LabelledAig output : this.outputs) {
            maxIndex = AigerPrinter.visitAig((BiMap<Aig, Integer>)index, maxIndex, output.aig());
        }
        if (this.binaryOutput) {
            writer.println("aig " + (maxIndex - 2) / 2 + " " + this.inputNames.size() + " " + this.latches.size() + " " + this.outputs.size() + " " + (maxIndex - varIndex) / 2);
            for (LabelledAig latch : this.latches) {
                writer.println(AigerPrinter.aig2lit((BiMap<Aig, Integer>)index, latch));
            }
            for (LabelledAig output : this.outputs) {
                writer.println(AigerPrinter.aig2lit((BiMap<Aig, Integer>)index, output));
            }
            for (int j2 = (this.inputNames.size() + this.latches.size() + 1) * 2; j2 < maxIndex; j2 += 2) {
                Aig gate = (Aig)index.inverse().get((Object)j2);
                assert (gate != null) : "All indices should have been assigned";
                int leftLit = AigerPrinter.aig2lit((BiMap<Aig, Integer>)index, gate.left(), gate.leftIsNegated());
                int rightLit = AigerPrinter.aig2lit((BiMap<Aig, Integer>)index, gate.right(), gate.rightIsNegated());
                assert (rightLit >= leftLit) : "Visiting sequence must be wrong!";
                AigerPrinter.encode(writer, rightLit - leftLit);
            }
            writer.println();
        } else {
            int i2;
            writer.println("aag " + (maxIndex - 2) / 2 + " " + this.inputNames.size() + " " + this.latches.size() + " " + this.outputs.size() + " " + (maxIndex - varIndex) / 2);
            for (i2 = 1; i2 <= this.inputNames.size(); ++i2) {
                writer.println(i2 * 2);
            }
            i2 = this.inputNames.size() + 1;
            for (LabelledAig latch : this.latches) {
                writer.println(i2 * 2 + " " + AigerPrinter.aig2lit((BiMap<Aig, Integer>)index, latch));
                ++i2;
            }
            for (LabelledAig output : this.outputs) {
                writer.println(AigerPrinter.aig2lit((BiMap<Aig, Integer>)index, output));
            }
            for (int j3 = (this.inputNames.size() + this.latches.size() + 1) * 2; j3 < maxIndex; j3 += 2) {
                Aig gate = (Aig)index.inverse().get((Object)j3);
                assert (gate != null) : "All indices should have been assigned";
                writer.println(j3 + " " + AigerPrinter.aig2lit((BiMap<Aig, Integer>)index, gate.left(), gate.leftIsNegated()) + " " + AigerPrinter.aig2lit((BiMap<Aig, Integer>)index, gate.right(), gate.rightIsNegated()));
            }
        }
        Indices.forEachIndexed(this.inputNames, (j, name) -> {
            if (!name.isEmpty()) {
                writer.println("i" + j + " " + name);
            }
        });
        Indices.forEachIndexed(this.latchNames, (j, name) -> {
            if (!name.isEmpty()) {
                writer.println("l" + j + " " + name);
            }
        });
        Indices.forEachIndexed(this.outputNames, (j, name) -> {
            if (!name.isEmpty()) {
                writer.println("o" + j + " " + name);
            }
        });
        if (!this.comments.isEmpty()) {
            writer.println("c");
            for (String comment : this.comments) {
                writer.println(comment);
            }
        }
    }
}

