/*
 * Decompiled with CFR 0.152.
 */
package owl.run.modules;

import com.google.common.base.Throwables;
import com.google.common.io.CharStreams;
import com.google.common.io.LineProcessor;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import jhoafparser.parser.generated.ParseException;
import org.antlr.v4.runtime.RecognitionException;
import org.antlr.v4.runtime.misc.ParseCancellationException;
import owl.automaton.AutomatonReader;
import owl.ltl.LabelledFormula;
import owl.ltl.parser.LtlParser;
import owl.run.PipelineException;
import owl.run.modules.ImmutableReaderParser;
import owl.run.modules.InputReader;
import owl.run.modules.OwlModuleParser;

public final class InputReaders {
    static final Logger logger = Logger.getLogger(InputReaders.class.getName());
    public static final InputReader HOA = (reader, env, callback) -> {
        try {
            AutomatonReader.readHoaStream(reader, env.factorySupplier()::getValuationSetFactory, callback::accept);
        }
        catch (ParseException e) {
            throw new PipelineException("Failed to parse input automaton", e);
        }
    };
    public static final OwlModuleParser.ReaderParser HOA_CLI = ImmutableReaderParser.builder().key("hoa").description("Parses automata given in HOA format, converting them to transition based acceptance if necessary").parser(settings -> HOA).build();
    public static final InputReader LTL = (reader, env, callback) -> CharStreams.readLines((Readable)reader, (LineProcessor)new LineProcessor<Void>(){

        public boolean processLine(String line) {
            LabelledFormula formula;
            if (env.isShutdown()) {
                return false;
            }
            if (line.isEmpty()) {
                return true;
            }
            logger.log(Level.FINEST, "Parsing formula {0}", line);
            try {
                formula = LtlParser.parse(line);
            }
            catch (RecognitionException | ParseCancellationException e) {
                throw new PipelineException("Failed to parse LTL formula " + line, e);
            }
            logger.log(Level.FINE, "Read formula {0} from line {1}", new Object[]{formula, line});
            callback.accept(formula);
            return true;
        }

        public Void getResult() {
            return null;
        }
    });
    public static final OwlModuleParser.ReaderParser LTL_CLI = ImmutableReaderParser.builder().key("ltl").description("Parses LTL formulas and converts them into NNF").parser(settings -> LTL).build();

    public static Consumer<Object> checkedCallback(CheckedCallback consumer) {
        return input -> {
            try {
                consumer.accept(input);
            }
            catch (Exception e) {
                Throwables.throwIfUnchecked((Throwable)e);
                throw new RuntimeException(e);
            }
        };
    }

    private InputReaders() {
    }

    @FunctionalInterface
    public static interface CheckedCallback {
        public void accept(Object var1) throws Exception;
    }
}

