/*
 * Decompiled with CFR 0.152.
 */
package owl.translations.ltl2ldba;

import java.util.List;
import java.util.Objects;
import owl.ltl.EquivalenceClass;
import owl.ltl.LtlLanguageExpressible;
import owl.translations.mastertheorem.AsymmetricEvaluatedFixpoints;
import owl.util.StringUtil;

public final class AsymmetricProductState
implements LtlLanguageExpressible {
    final int index;
    final EquivalenceClass currentCoSafety;
    final List<EquivalenceClass> nextCoSafety;
    final EquivalenceClass safety;
    private final EquivalenceClass language;
    private final int hashCode;
    public final AsymmetricEvaluatedFixpoints evaluatedFixpoints;
    public final AsymmetricEvaluatedFixpoints.DeterministicAutomata automata;

    AsymmetricProductState(int index, EquivalenceClass safety, EquivalenceClass currentCoSafety, List<EquivalenceClass> nextCoSafety, AsymmetricEvaluatedFixpoints evaluatedFixpoints, AsymmetricEvaluatedFixpoints.DeterministicAutomata automata) {
        assert (0 <= index && index < automata.coSafety.size() || index < 0 && -index <= automata.fCoSafety.size() || automata.coSafety.isEmpty() && automata.fCoSafety.isEmpty() && index == 0);
        this.index = index;
        this.currentCoSafety = currentCoSafety;
        this.evaluatedFixpoints = Objects.requireNonNull(evaluatedFixpoints);
        this.safety = safety;
        this.nextCoSafety = List.copyOf(nextCoSafety);
        this.hashCode = Objects.hash(currentCoSafety, evaluatedFixpoints, safety, index, nextCoSafety);
        this.automata = automata;
        EquivalenceClass language = safety.and(currentCoSafety).and(evaluatedFixpoints.language());
        for (EquivalenceClass clazz : nextCoSafety) {
            language = language.and(clazz);
        }
        this.language = language;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AsymmetricProductState)) {
            return false;
        }
        AsymmetricProductState other = (AsymmetricProductState)o;
        return other.hashCode == this.hashCode && this.index == other.index && this.safety.equals(other.safety) && this.currentCoSafety.equals(other.currentCoSafety) && this.nextCoSafety.equals(other.nextCoSafety) && this.evaluatedFixpoints.equals(other.evaluatedFixpoints);
    }

    public int hashCode() {
        return this.hashCode;
    }

    @Override
    public EquivalenceClass language() {
        return this.language;
    }

    public String toString() {
        return this.evaluatedFixpoints + StringUtil.join(this.safety.isTrue() ? null : "GWR=" + this.safety, this.index == 0 ? null : "i=" + this.index, this.currentCoSafety.isTrue() ? null : "C=" + this.currentCoSafety, this.nextCoSafety.isEmpty() ? null : "N=" + this.nextCoSafety);
    }
}

