/*
 * Decompiled with CFR 0.152.
 */
package owl.translations.ltl2ldba;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import owl.ltl.BooleanConstant;
import owl.ltl.Conjunction;
import owl.ltl.Disjunction;
import owl.ltl.Formula;
import owl.ltl.SyntacticFragment;
import owl.ltl.visitors.PropositionalVisitor;

public final class BlockingModalOperatorsVisitor
extends PropositionalVisitor<Set<Formula.ModalOperator>> {
    public static final BlockingModalOperatorsVisitor INSTANCE = new BlockingModalOperatorsVisitor();

    private BlockingModalOperatorsVisitor() {
    }

    @Override
    protected Set<Formula.ModalOperator> visit(Formula.TemporalOperator formula) {
        if (SyntacticFragment.FINITE.contains(formula)) {
            return Set.of();
        }
        if (SyntacticFragment.CO_SAFETY.contains(formula)) {
            return Set.of((Formula.ModalOperator)formula);
        }
        return Set.of();
    }

    @Override
    public Set<Formula.ModalOperator> visit(BooleanConstant booleanConstant) {
        return Set.of();
    }

    @Override
    public Set<Formula.ModalOperator> visit(Conjunction conjunction) {
        HashSet<Formula.ModalOperator> blockingOperators = new HashSet<Formula.ModalOperator>();
        for (Formula child : conjunction.children) {
            if (SyntacticFragment.FINITE.contains(child)) continue;
            blockingOperators.addAll((Collection<Formula.ModalOperator>)child.accept(this));
        }
        return blockingOperators;
    }

    @Override
    public Set<Formula.ModalOperator> visit(Disjunction disjunction) {
        HashSet blockingOperators = null;
        for (Formula child : disjunction.children) {
            if (SyntacticFragment.FINITE.contains(child)) continue;
            if (blockingOperators == null) {
                blockingOperators = new HashSet(child.accept(this));
                continue;
            }
            blockingOperators.retainAll((Collection)child.accept(this));
        }
        return blockingOperators == null ? Set.of() : blockingOperators;
    }
}

