/*
 * Decompiled with CFR 0.152.
 */
package de.tum.in.naturals.bitset;

import de.tum.in.naturals.bitset.BitSets;
import de.tum.in.naturals.bitset.RoaringIterator;
import de.tum.in.naturals.set.NatBitSet;
import de.tum.in.naturals.set.NatBitSets;
import it.unimi.dsi.fastutil.ints.IntIterable;
import it.unimi.dsi.fastutil.ints.IntIterator;
import java.util.BitSet;
import java.util.PrimitiveIterator;
import org.roaringbitmap.RoaringBitmap;

public final class RoaringBitmaps {
    private RoaringBitmaps() {
    }

    public static RoaringBitmap of(IntIterable iterable) {
        if (iterable instanceof NatBitSet) {
            return NatBitSets.toRoaringBitmap((NatBitSet)iterable);
        }
        RoaringBitmap bitmap = new RoaringBitmap();
        iterable.forEach(arg_0 -> ((RoaringBitmap)bitmap).add(arg_0));
        return bitmap;
    }

    public static RoaringBitmap of(Iterable<Integer> iterable) {
        if (iterable instanceof IntIterable) {
            return RoaringBitmaps.of((IntIterable)iterable);
        }
        RoaringBitmap bitmap = new RoaringBitmap();
        iterable.forEach(arg_0 -> ((RoaringBitmap)bitmap).add(arg_0));
        return bitmap;
    }

    public static RoaringBitmap of(PrimitiveIterator.OfInt iterator) {
        RoaringBitmap bitmap = new RoaringBitmap();
        iterator.forEachRemaining(arg_0 -> ((RoaringBitmap)bitmap).add(arg_0));
        return bitmap;
    }

    public static RoaringBitmap of(BitSet bitSet) {
        RoaringBitmap bitmap = new RoaringBitmap();
        BitSets.forEach(bitSet, arg_0 -> ((RoaringBitmap)bitmap).add(arg_0));
        return bitmap;
    }

    public static IntIterator iterator(RoaringBitmap bitmap) {
        return new RoaringIterator(bitmap.getIntIterator());
    }

    public static RoaringBitmap subset(RoaringBitmap bitmap, long from, long to) {
        RoaringBitmap selector = new RoaringBitmap();
        selector.add(from, to);
        return RoaringBitmap.and((RoaringBitmap)bitmap, (RoaringBitmap)selector);
    }
}

