/*
 * Decompiled with CFR 0.152.
 */
package de.tum.in.naturals.map;

import de.tum.in.naturals.map.AbstractInt2DoubleEntrySet;
import it.unimi.dsi.fastutil.doubles.AbstractDoubleCollection;
import it.unimi.dsi.fastutil.doubles.DoubleArrays;
import it.unimi.dsi.fastutil.doubles.DoubleCollection;
import it.unimi.dsi.fastutil.doubles.DoubleIterator;
import it.unimi.dsi.fastutil.ints.AbstractInt2DoubleMap;
import it.unimi.dsi.fastutil.ints.AbstractIntSet;
import it.unimi.dsi.fastutil.ints.Int2DoubleMap;
import it.unimi.dsi.fastutil.ints.IntArrays;
import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.ints.IntIterators;
import it.unimi.dsi.fastutil.ints.IntSet;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import it.unimi.dsi.fastutil.objects.ObjectSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.function.IntConsumer;
import javax.annotation.Nullable;

public class Int2DoubleSortedArrayMap
extends AbstractInt2DoubleMap {
    private static final long serialVersionUID = 4177317104795467442L;
    @Nullable
    private transient EntrySetView entrySetView = null;
    @Nullable
    private transient KeySetView keySetView = null;
    private int[] keys;
    private int size;
    private double[] values;
    @Nullable
    private transient ValuesView valuesView = null;

    public Int2DoubleSortedArrayMap(Map<? extends Integer, ? extends Double> map) {
        if (map instanceof Int2DoubleSortedArrayMap) {
            Int2DoubleSortedArrayMap arrayMap = (Int2DoubleSortedArrayMap)((Object)map);
            this.size = arrayMap.size;
            this.keys = Arrays.copyOf(arrayMap.keys, this.size);
            this.values = Arrays.copyOf(arrayMap.values, this.size);
        } else {
            int size = map.size();
            this.keys = new int[size];
            this.values = new double[size];
            this.putAll(map);
        }
    }

    public Int2DoubleSortedArrayMap() {
        this.keys = IntArrays.EMPTY_ARRAY;
        this.values = DoubleArrays.EMPTY_ARRAY;
        this.size = 0;
    }

    public Int2DoubleSortedArrayMap(int capacity) {
        this.keys = new int[capacity];
        this.values = new double[capacity];
    }

    public Int2DoubleSortedArrayMap(Int2DoubleMap map) {
        this((Map<? extends Integer, ? extends Double>)map);
    }

    public Int2DoubleSortedArrayMap(int key, double value) {
        this.keys = new int[]{key};
        this.values = new double[]{value};
    }

    public void clear() {
        this.size = 0;
    }

    public boolean containsKey(int key) {
        return this.keyIndex(key) >= 0;
    }

    public boolean containsValue(double v) {
        long valueBits = Double.doubleToRawLongBits(v);
        for (int index = 0; index < this.keys.length; ++index) {
            if (Double.doubleToRawLongBits(this.values[index]) != valueBits) continue;
            return true;
        }
        return false;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof Int2DoubleSortedArrayMap) {
            Int2DoubleSortedArrayMap other = (Int2DoubleSortedArrayMap)((Object)o);
            return this.size == other.size && Arrays.equals(this.keys, other.keys) && Arrays.equals(this.values, other.values);
        }
        return super.equals(o);
    }

    public double get(int key) {
        int index = this.keyIndex(key);
        return 0 <= index ? this.values[index] : this.defRetValue;
    }

    public int hashCode() {
        return Arrays.hashCode(this.keys) ^ Arrays.hashCode(this.values);
    }

    public ObjectSet<Int2DoubleMap.Entry> int2DoubleEntrySet() {
        if (this.entrySetView == null) {
            this.entrySetView = new EntrySetView(this);
        }
        return this.entrySetView;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    private int keyIndex(int key) {
        return Arrays.binarySearch(this.keys, 0, this.size, key);
    }

    public IntSet keySet() {
        if (this.keySetView == null) {
            this.keySetView = new KeySetView(this);
        }
        return this.keySetView;
    }

    public double put(int key, double value) {
        if (this.keys.length == 0) {
            this.keys = new int[]{key, 0};
            this.values = new double[]{value, 0.0};
            this.size = 1;
            return this.defRetValue;
        }
        int index = this.keyIndex(key);
        assert (-(this.size + 1) <= index && index < this.size) : this.size + " " + index;
        if (index >= 0) {
            double oldValue = this.values[index];
            this.values[index] = value;
            return oldValue;
        }
        int insertionPoint = -(index + 1);
        int tailLength = this.size - insertionPoint;
        if (this.size == this.keys.length) {
            int newSize = this.size * 2;
            assert (this.size < newSize);
            if (insertionPoint == this.size) {
                this.keys = Arrays.copyOf(this.keys, newSize);
                this.values = Arrays.copyOf(this.values, newSize);
                this.keys[insertionPoint] = key;
                this.values[insertionPoint] = value;
            } else {
                int[] newKeys = new int[newSize];
                System.arraycopy(this.keys, 0, newKeys, 0, insertionPoint);
                System.arraycopy(this.keys, insertionPoint, newKeys, insertionPoint + 1, tailLength);
                double[] newValues = new double[newSize];
                System.arraycopy(this.values, 0, newValues, 0, insertionPoint);
                System.arraycopy(this.values, insertionPoint, newValues, insertionPoint + 1, tailLength);
                this.keys = newKeys;
                this.values = newValues;
                newKeys[insertionPoint] = key;
                newValues[insertionPoint] = value;
            }
        } else if (insertionPoint == this.size) {
            this.keys[this.size] = key;
            this.values[this.size] = value;
        } else {
            assert (insertionPoint < this.size && this.size < this.keys.length);
            assert (0 <= tailLength && insertionPoint + 1 + tailLength <= this.keys.length);
            System.arraycopy(this.keys, insertionPoint, this.keys, insertionPoint + 1, tailLength);
            System.arraycopy(this.values, insertionPoint, this.values, insertionPoint + 1, tailLength);
            this.keys[insertionPoint] = key;
            this.values[insertionPoint] = value;
        }
        ++this.size;
        return this.defRetValue;
    }

    public double remove(int key) {
        int index = this.keyIndex(key);
        if (index < 0) {
            return this.defRetValue;
        }
        double value = this.values[index];
        this.removeIndex(index);
        return value;
    }

    protected void removeIndex(int index) {
        assert (index < this.size);
        int nextIndex = index + 1;
        if (nextIndex < this.size) {
            int tail = this.size - nextIndex;
            System.arraycopy(this.keys, nextIndex, this.keys, index, tail);
            System.arraycopy(this.values, nextIndex, this.values, index, tail);
        }
        --this.size;
    }

    public int size() {
        return this.size;
    }

    public String toString() {
        if (this.isEmpty()) {
            return "{}";
        }
        StringBuilder builder = new StringBuilder();
        builder.append('{').append(this.keys[0]).append('=').append(this.values[0]);
        for (int keyIndex = 1; keyIndex < this.size; ++keyIndex) {
            builder.append(", ").append(this.keys[keyIndex]).append("=>").append(this.values[keyIndex]);
        }
        builder.append('}');
        return builder.toString();
    }

    public void trim() {
        if (this.keys.length == this.size) {
            return;
        }
        this.keys = Arrays.copyOf(this.keys, this.size);
        this.values = Arrays.copyOf(this.values, this.size);
    }

    public DoubleCollection values() {
        if (this.valuesView == null) {
            this.valuesView = new ValuesView(this);
        }
        return this.valuesView;
    }

    private static class EntrySetView
    extends AbstractInt2DoubleEntrySet<Int2DoubleSortedArrayMap> {
        EntrySetView(Int2DoubleSortedArrayMap map) {
            super(map);
        }

        public EntrySetView clone() throws CloneNotSupportedException {
            return (EntrySetView)super.clone();
        }

        public ObjectIterator<Int2DoubleMap.Entry> fastIterator() {
            return new FastEntryIterator((Int2DoubleSortedArrayMap)this.map);
        }

        public ObjectIterator<Int2DoubleMap.Entry> iterator() {
            return new EntryIterator((Int2DoubleSortedArrayMap)this.map);
        }
    }

    private static class KeySetView
    extends AbstractIntSet {
        private final Int2DoubleSortedArrayMap map;

        KeySetView(Int2DoubleSortedArrayMap map) {
            this.map = map;
        }

        public KeySetView clone() {
            return this;
        }

        public void forEach(IntConsumer action) {
            int[] keys = this.map.keys;
            for (int index = 0; index < this.map.size; ++index) {
                action.accept(keys[index]);
            }
        }

        public IntIterator iterator() {
            return IntIterators.wrap((int[])this.map.keys, (int)0, (int)this.map.size);
        }

        public boolean remove(int key) {
            if (!this.map.containsKey(key)) {
                return false;
            }
            this.map.remove(key);
            return true;
        }

        public int size() {
            return this.map.size;
        }
    }

    private static class ValuesView
    extends AbstractDoubleCollection {
        private final Int2DoubleSortedArrayMap map;

        ValuesView(Int2DoubleSortedArrayMap map) {
            this.map = map;
        }

        public void clear() {
            this.map.clear();
        }

        public boolean contains(double v) {
            return this.map.containsValue(v);
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Collection)) {
                return false;
            }
            Collection other = (Collection)o;
            return other.size() == this.size() && this.containsAll(other);
        }

        public int hashCode() {
            return this.map.hashCode() * 31;
        }

        public DoubleIterator iterator() {
            return new ValuesIterator(this.map);
        }

        public int size() {
            return this.map.size;
        }
    }

    private static class ValuesIterator
    implements DoubleIterator {
        private final Int2DoubleSortedArrayMap map;
        private int nextIndex = 0;

        ValuesIterator(Int2DoubleSortedArrayMap map) {
            this.map = map;
        }

        public boolean hasNext() {
            return this.nextIndex < this.map.size;
        }

        public double nextDouble() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            double value = this.map.values[this.nextIndex];
            ++this.nextIndex;
            return value;
        }

        public void remove() {
            if (this.nextIndex == 0) {
                throw new IllegalStateException();
            }
            --this.nextIndex;
            this.map.removeIndex(this.nextIndex);
        }
    }

    private static class MapEntry
    extends AbstractInt2DoubleMap.BasicEntry {
        private final int index;
        private final Int2DoubleSortedArrayMap map;

        MapEntry(Int2DoubleSortedArrayMap map, int index) {
            this.map = map;
            this.index = index;
        }

        public double getDoubleValue() {
            return this.map.values[this.index];
        }

        public int getIntKey() {
            return this.map.keys[this.index];
        }

        public double setValue(double v) {
            double oldValue = this.map.values[this.index];
            ((Int2DoubleSortedArrayMap)this.map).values[this.index] = v;
            return oldValue;
        }
    }

    private static class FastMapEntry
    extends AbstractInt2DoubleMap.BasicEntry {
        private final Int2DoubleSortedArrayMap map;
        int index = -1;

        public FastMapEntry(Int2DoubleSortedArrayMap map) {
            this.map = map;
        }

        public double getDoubleValue() {
            return this.map.values[this.index];
        }

        public int getIntKey() {
            return this.map.keys[this.index];
        }

        public double setValue(double v) {
            double oldValue = this.map.values[this.index];
            ((Int2DoubleSortedArrayMap)this.map).values[this.index] = v;
            return oldValue;
        }
    }

    private static class FastEntryIterator
    implements ObjectIterator<Int2DoubleMap.Entry> {
        private final FastMapEntry entry;
        private final Int2DoubleSortedArrayMap map;

        FastEntryIterator(Int2DoubleSortedArrayMap map) {
            this.entry = new FastMapEntry(map);
            this.map = map;
        }

        public boolean hasNext() {
            return this.entry.index + 1 < this.map.size;
        }

        public Int2DoubleMap.Entry next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            ++this.entry.index;
            return this.entry;
        }

        public void remove() {
            if (this.entry.index == -1) {
                throw new IllegalStateException();
            }
            this.map.removeIndex(this.entry.index);
        }
    }

    private static class EntryIterator
    implements ObjectIterator<Int2DoubleMap.Entry> {
        private final Int2DoubleSortedArrayMap map;
        private int index = 0;

        EntryIterator(Int2DoubleSortedArrayMap map) {
            this.map = map;
        }

        public boolean hasNext() {
            return this.index < this.map.size();
        }

        public MapEntry next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            MapEntry entry = new MapEntry(this.map, this.index);
            ++this.index;
            return entry;
        }

        public void remove() {
            if (this.index == 0) {
                throw new IllegalStateException();
            }
            --this.index;
            this.map.removeIndex(this.index);
        }
    }
}

