/*
 * Decompiled with CFR 0.152.
 */
package de.tum.in.naturals.set;

import com.zaxxer.sparsebits.SparseBitSet;
import de.tum.in.naturals.bitset.SparseBitSets;
import de.tum.in.naturals.set.AbstractBoundedNatBitSet;
import de.tum.in.naturals.set.BoundedNatBitSet;
import de.tum.in.naturals.set.NatBitSetsUtil;
import de.tum.in.naturals.set.SparseNatBitSet;
import it.unimi.dsi.fastutil.ints.IntCollection;
import it.unimi.dsi.fastutil.ints.IntIterator;
import java.util.Collection;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.annotation.Nonnegative;

class SparseBoundedNatBitSet
extends AbstractBoundedNatBitSet {
    private final SparseBitSet bitSet;
    private final boolean complement;
    private final SparseBoundedNatBitSet complementView;

    private SparseBoundedNatBitSet(SparseBoundedNatBitSet other) {
        super(other.domainSize());
        this.bitSet = other.bitSet;
        this.complement = !other.complement;
        this.complementView = other;
        assert (this.checkConsistency());
    }

    private SparseBoundedNatBitSet(SparseBitSet bitSet, @Nonnegative int domainSize, boolean complement) {
        super(domainSize);
        this.bitSet = bitSet;
        this.complement = complement;
        this.complementView = new SparseBoundedNatBitSet(this);
        assert (this.checkConsistency());
    }

    SparseBoundedNatBitSet(SparseBitSet bitSet, @Nonnegative int domainSize) {
        this(bitSet, domainSize, false);
    }

    @Override
    boolean isComplement() {
        return this.complement;
    }

    public boolean isEmpty() {
        assert (this.checkConsistency());
        return this.complement ? this.bitSet.nextClearBit(0) == this.domainSize() : this.bitSet.isEmpty();
    }

    public int size() {
        assert (this.checkConsistency());
        int bitSetCardinality = this.bitSet.cardinality();
        return this.complement ? this.domainSize() - bitSetCardinality : bitSetCardinality;
    }

    public boolean contains(int k) {
        return 0 <= k && (this.complement ? k < this.domainSize() && !this.bitSet.get(k) : this.bitSet.get(k));
    }

    public boolean containsAll(IntCollection indices) {
        assert (this.checkConsistency());
        if (this.isEmpty()) {
            return indices.isEmpty();
        }
        if (indices.isEmpty()) {
            return true;
        }
        if (indices instanceof SparseBoundedNatBitSet) {
            SparseBoundedNatBitSet other = (SparseBoundedNatBitSet)indices;
            int otherLastInt = other.lastInt();
            if (!this.inDomain(otherLastInt) || this.lastInt() < otherLastInt) {
                return false;
            }
            SparseBitSet otherSetBits = other.complement ? other.complementBits() : other.bitSet;
            SparseBitSet unsetBits = this.complement ? this.bitSet : this.complementBits();
            return !unsetBits.intersects(otherSetBits);
        }
        if (indices instanceof SparseNatBitSet) {
            SparseNatBitSet other = (SparseNatBitSet)indices;
            int otherLastInt = other.lastInt();
            if (!this.inDomain(otherLastInt) || this.lastInt() < otherLastInt) {
                return false;
            }
            SparseBitSet otherSetBits = other.getBitSet();
            SparseBitSet unsetBits = this.complement ? this.bitSet : this.complementBits();
            return !unsetBits.intersects(otherSetBits);
        }
        return super.containsAll(indices);
    }

    @Override
    public int lastInt() {
        int lastInt;
        int n = lastInt = this.complement ? SparseBitSets.previousAbsentIndex(this.bitSet, this.domainSize() - 1) : this.bitSet.length() - 1;
        assert (this.checkConsistency());
        if (lastInt == -1) {
            throw new NoSuchElementException();
        }
        assert (0 <= lastInt && lastInt < this.domainSize());
        return lastInt;
    }

    @Override
    public int nextPresentIndex(int index) {
        assert (this.checkConsistency());
        NatBitSetsUtil.checkNonNegative(index);
        if (index >= this.domainSize()) {
            return -1;
        }
        if (this.complement) {
            int nextClear = this.bitSet.nextClearBit(index);
            return nextClear >= this.domainSize() ? -1 : nextClear;
        }
        return this.bitSet.nextSetBit(index);
    }

    @Override
    public int nextAbsentIndex(int index) {
        assert (this.checkConsistency());
        NatBitSetsUtil.checkNonNegative(index);
        if (index >= this.domainSize()) {
            return index;
        }
        if (this.complement) {
            int nextSet = this.bitSet.nextSetBit(index);
            return nextSet == -1 ? this.domainSize() : nextSet;
        }
        return this.bitSet.nextClearBit(index);
    }

    @Override
    public int previousPresentIndex(int index) {
        assert (this.checkConsistency());
        NatBitSetsUtil.checkNonNegative(index);
        int clampedIndex = Math.min(index, this.domainSize() - 1);
        return this.complement ? SparseBitSets.previousAbsentIndex(this.bitSet, clampedIndex) : SparseBitSets.previousPresentIndex(this.bitSet, clampedIndex);
    }

    @Override
    public int previousAbsentIndex(int index) {
        assert (this.checkConsistency());
        NatBitSetsUtil.checkNonNegative(index);
        if (index >= this.domainSize()) {
            return index;
        }
        return this.complement ? SparseBitSets.previousPresentIndex(this.bitSet, index) : SparseBitSets.previousAbsentIndex(this.bitSet, index);
    }

    @Override
    public IntIterator iterator() {
        assert (this.checkConsistency());
        return this.complement ? SparseBitSets.complementIterator(this.bitSet, this.domainSize()) : SparseBitSets.iterator(this.bitSet);
    }

    @Override
    public void set(int index) {
        assert (this.checkConsistency());
        this.checkInDomain(index);
        this.bitSet.set(index, !this.complement);
        assert (this.checkConsistency());
    }

    @Override
    public void set(int index, boolean value) {
        assert (this.checkConsistency());
        this.checkInDomain(index);
        this.bitSet.set(index, value ^ this.complement);
        assert (this.checkConsistency());
    }

    @Override
    public void set(int from, int to) {
        assert (this.checkConsistency());
        this.checkInDomain(from, to);
        if (this.complement) {
            this.bitSet.clear(from, to);
        } else {
            this.bitSet.set(from, to);
        }
        assert (this.checkConsistency());
    }

    public void clear() {
        assert (this.checkConsistency());
        if (this.complement) {
            this.bitSet.set(0, this.domainSize());
        } else {
            this.bitSet.clear();
        }
        assert (this.checkConsistency());
    }

    @Override
    public void clear(int index) {
        assert (this.checkConsistency());
        if (index >= this.domainSize()) {
            return;
        }
        this.bitSet.set(index, this.complement);
        assert (this.checkConsistency());
    }

    @Override
    public void clear(int from, int to) {
        assert (this.checkConsistency());
        this.checkInDomain(from, to);
        int domainSize = this.domainSize();
        if (from >= domainSize) {
            return;
        }
        if (this.complement) {
            this.bitSet.set(from, Math.min(to, domainSize));
        } else {
            this.bitSet.clear(from, Math.min(to, domainSize));
        }
        assert (this.checkConsistency());
    }

    @Override
    public void flip(int index) {
        assert (this.checkConsistency());
        this.checkInDomain(index);
        this.bitSet.flip(index);
        assert (this.checkConsistency());
    }

    @Override
    public void flip(int from, int to) {
        assert (this.checkConsistency());
        this.checkInDomain(from, to);
        this.bitSet.flip(from, to);
        assert (this.checkConsistency());
    }

    @Override
    public boolean intersects(Collection<Integer> indices) {
        if (indices instanceof SparseBoundedNatBitSet) {
            SparseBoundedNatBitSet other = (SparseBoundedNatBitSet)((Object)indices);
            return (this.complement ? this.complementBits() : this.bitSet).intersects(other.isComplement() ? other.complementBits() : other.getBitSet());
        }
        if (indices instanceof SparseNatBitSet) {
            SparseNatBitSet other = (SparseNatBitSet)((Object)indices);
            return (this.complement ? this.complementBits() : this.bitSet).intersects(other.getBitSet());
        }
        return super.intersects(indices);
    }

    @Override
    public void and(IntCollection indices) {
        assert (this.checkConsistency());
        if (indices.isEmpty()) {
            this.clear();
        } else if (indices instanceof SparseBoundedNatBitSet) {
            SparseBoundedNatBitSet other = (SparseBoundedNatBitSet)indices;
            if (this.complement) {
                int domainSize = this.domainSize();
                int otherDomainSize = other.domainSize();
                this.bitSet.or(0, domainSize, other.complement ? other.bitSet : other.complementBits());
                if (otherDomainSize < domainSize) {
                    this.bitSet.set(otherDomainSize, domainSize);
                }
            } else if (other.complement) {
                this.bitSet.andNot(other.bitSet);
                int domainSize = this.domainSize();
                int otherDomainSize = other.domainSize();
                if (otherDomainSize < domainSize) {
                    this.bitSet.clear(otherDomainSize, domainSize);
                }
            } else {
                this.bitSet.and(other.bitSet);
            }
        } else if (indices instanceof SparseNatBitSet) {
            SparseNatBitSet other = (SparseNatBitSet)indices;
            if (this.complement) {
                this.bitSet.flip(0, this.domainSize());
                this.bitSet.and(other.getBitSet());
                this.bitSet.flip(0, this.domainSize());
            } else {
                this.bitSet.and(other.getBitSet());
            }
        } else {
            super.and(indices);
        }
        assert (this.checkConsistency());
    }

    @Override
    public void andNot(IntCollection indices) {
        assert (this.checkConsistency());
        if (this.isEmpty() || indices.isEmpty()) {
            return;
        }
        if (indices instanceof SparseBoundedNatBitSet) {
            SparseBoundedNatBitSet other = (SparseBoundedNatBitSet)indices;
            if (this.complement) {
                this.bitSet.or(0, this.domainSize(), other.complement ? other.complementBits() : other.bitSet);
            } else if (other.complement) {
                this.bitSet.and(0, other.domainSize(), other.bitSet);
            } else {
                this.bitSet.andNot(other.bitSet);
            }
        } else if (indices instanceof SparseNatBitSet) {
            SparseNatBitSet other = (SparseNatBitSet)indices;
            if (this.complement) {
                this.bitSet.or(0, this.domainSize(), other.getBitSet());
            } else {
                this.bitSet.andNot(other.getBitSet());
            }
        } else {
            super.andNot(indices);
        }
        assert (this.checkConsistency());
    }

    @Override
    public void or(IntCollection indices) {
        assert (this.checkConsistency());
        if (indices.isEmpty()) {
            return;
        }
        if (indices instanceof SparseBoundedNatBitSet) {
            SparseBoundedNatBitSet other = (SparseBoundedNatBitSet)indices;
            this.checkInDomain(other.lastInt());
            if (this.complement) {
                if (other.complement) {
                    this.bitSet.and(0, other.domainSize(), other.bitSet);
                } else {
                    this.bitSet.andNot(other.bitSet);
                }
            } else if (other.complement) {
                this.bitSet.or(other.complementBits());
            } else {
                this.bitSet.or(other.bitSet);
            }
        } else if (indices instanceof SparseNatBitSet) {
            SparseNatBitSet other = (SparseNatBitSet)indices;
            this.checkInDomain(other.lastInt());
            if (this.complement) {
                this.bitSet.andNot(other.getBitSet());
            } else {
                this.bitSet.or(0, this.domainSize(), other.getBitSet());
            }
        } else {
            super.or(indices);
        }
        assert (this.checkConsistency());
    }

    @Override
    public void orNot(IntCollection indices) {
        assert (this.checkConsistency());
        if (indices.isEmpty()) {
            if (this.complement) {
                this.bitSet.clear();
            } else {
                this.bitSet.set(0, this.domainSize());
            }
        } else if (indices instanceof SparseBoundedNatBitSet) {
            SparseBoundedNatBitSet other = (SparseBoundedNatBitSet)indices;
            int domainSize = this.domainSize();
            int otherDomainSize = other.domainSize();
            if (this.complement) {
                if (other.complement) {
                    this.bitSet.andNot(other.bitSet);
                    if (otherDomainSize < domainSize) {
                        this.bitSet.clear(otherDomainSize, domainSize);
                    }
                } else {
                    this.bitSet.and(other.bitSet);
                }
            } else {
                if (other.complement) {
                    this.bitSet.or(0, this.domainSize(), other.bitSet);
                } else {
                    int minDomainSize = Math.min(domainSize, otherDomainSize);
                    other.bitSet.flip(0, minDomainSize);
                    this.bitSet.or(0, domainSize, other.bitSet);
                    other.bitSet.flip(0, minDomainSize);
                }
                if (otherDomainSize < domainSize) {
                    this.bitSet.set(otherDomainSize, domainSize);
                }
            }
        } else if (indices instanceof SparseNatBitSet) {
            SparseNatBitSet other = (SparseNatBitSet)indices;
            if (this.complement) {
                this.bitSet.and(other.getBitSet());
            } else {
                SparseBitSet bitSet = other.getBitSet();
                bitSet.flip(0, this.domainSize());
                this.bitSet.or(0, this.domainSize(), bitSet);
                bitSet.flip(0, this.domainSize());
            }
        } else {
            super.orNot(indices);
        }
        assert (this.checkConsistency());
    }

    @Override
    public void xor(IntCollection indices) {
        assert (this.checkConsistency());
        if (indices.isEmpty()) {
            return;
        }
        if (indices instanceof SparseBoundedNatBitSet) {
            SparseBoundedNatBitSet other = (SparseBoundedNatBitSet)indices;
            int otherDomainSize = other.domainSize();
            this.checkInDomain(otherDomainSize - 1);
            this.bitSet.xor(other.bitSet);
            if (other.complement) {
                this.bitSet.flip(0, otherDomainSize);
            }
        } else if (indices instanceof SparseNatBitSet) {
            SparseNatBitSet other = (SparseNatBitSet)indices;
            this.checkInDomain(other.lastInt());
            this.bitSet.xor(other.getBitSet());
        } else {
            super.xor(indices);
        }
        assert (this.checkConsistency());
    }

    @Override
    public SparseBoundedNatBitSet clone() {
        assert (this.checkConsistency());
        return new SparseBoundedNatBitSet(this.bitSet.clone(), this.domainSize(), this.complement);
    }

    @Override
    public BoundedNatBitSet complement() {
        return this.complementView;
    }

    public boolean equals(Object o) {
        assert (this.checkConsistency());
        if (this == o) {
            return true;
        }
        if (!(o instanceof Set)) {
            return false;
        }
        if (this.isEmpty()) {
            return ((Collection)o).isEmpty();
        }
        if (((Collection)o).isEmpty()) {
            return false;
        }
        if (o instanceof SparseBoundedNatBitSet) {
            SparseBoundedNatBitSet nonComplementSet;
            SparseBoundedNatBitSet other = (SparseBoundedNatBitSet)o;
            int domainSize = this.domainSize();
            int otherDomainSize = other.domainSize();
            if (this.complement) {
                if (other.complement) {
                    int largerSize;
                    int smallerSize;
                    SparseBoundedNatBitSet larger;
                    SparseBoundedNatBitSet smaller;
                    if (domainSize == otherDomainSize) {
                        return this.bitSet.equals((Object)other.bitSet);
                    }
                    if (domainSize < otherDomainSize) {
                        smaller = this;
                        larger = other;
                        smallerSize = domainSize;
                        largerSize = otherDomainSize;
                    } else {
                        smaller = other;
                        larger = this;
                        smallerSize = otherDomainSize;
                        largerSize = domainSize;
                    }
                    if (larger.bitSet.nextClearBit(smallerSize) < largerSize) {
                        return false;
                    }
                    smaller.bitSet.xor(0, smallerSize, larger.bitSet);
                    boolean equals = smaller.bitSet.isEmpty();
                    smaller.bitSet.xor(0, smallerSize, larger.bitSet);
                    return equals;
                }
            } else if (!other.complement) {
                return this.bitSet.equals((Object)other.bitSet);
            }
            int complementDomainSize = this.complement ? domainSize : otherDomainSize;
            SparseBoundedNatBitSet sparseBoundedNatBitSet = nonComplementSet = this.complement ? other : this;
            assert (!nonComplementSet.complement);
            return !this.bitSet.intersects(other.bitSet) && this.bitSet.cardinality() + other.bitSet.cardinality() == complementDomainSize && (domainSize == otherDomainSize || nonComplementSet.lastInt() < complementDomainSize);
        }
        if (o instanceof SparseNatBitSet) {
            SparseNatBitSet other = (SparseNatBitSet)o;
            if (other.lastInt() >= this.domainSize()) {
                return false;
            }
            if (this.isComplement()) {
                return this.size() == other.size() && !other.getBitSet().intersects(this.bitSet);
            }
            return this.bitSet.equals((Object)other.getBitSet());
        }
        return super.equals(o);
    }

    SparseBitSet getBitSet() {
        return this.bitSet;
    }

    SparseBitSet complementBits() {
        SparseBitSet copy = this.bitSet.clone();
        copy.flip(0, this.domainSize());
        return copy;
    }

    private boolean checkConsistency() {
        return this.bitSet.length() <= this.domainSize();
    }
}

