/*
 * Decompiled with CFR 0.152.
 */
package de.tum.in.naturals.set;

import com.zaxxer.sparsebits.SparseBitSet;
import de.tum.in.naturals.bitset.SparseBitSets;
import de.tum.in.naturals.set.AbstractNatBitSet;
import de.tum.in.naturals.set.SparseBoundedNatBitSet;
import it.unimi.dsi.fastutil.ints.IntCollection;
import it.unimi.dsi.fastutil.ints.IntIterator;
import java.util.Collection;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.function.IntConsumer;

class SparseNatBitSet
extends AbstractNatBitSet {
    private final SparseBitSet bitSet;

    SparseNatBitSet(SparseBitSet bitSet) {
        this.bitSet = bitSet;
    }

    public boolean isEmpty() {
        return this.bitSet.isEmpty();
    }

    public int size() {
        return this.bitSet.cardinality();
    }

    public boolean contains(int index) {
        return 0 <= index && this.bitSet.get(index);
    }

    public boolean containsAll(IntCollection indices) {
        if (this.isEmpty()) {
            return indices.isEmpty();
        }
        if (indices.isEmpty()) {
            return true;
        }
        if (indices instanceof SparseNatBitSet) {
            SparseNatBitSet other = (SparseNatBitSet)indices;
            if (this.lastInt() < other.lastInt()) {
                return false;
            }
            return SparseBitSets.isSubset(other.bitSet, this.bitSet);
        }
        if (indices instanceof SparseBoundedNatBitSet) {
            SparseBoundedNatBitSet other = (SparseBoundedNatBitSet)indices;
            int lastInt = this.lastInt();
            if (lastInt < other.lastInt()) {
                return false;
            }
            return other.isComplement() ? SparseBitSets.isSubsetConsuming(other.complementBits(), this.bitSet) : SparseBitSets.isSubset(other.getBitSet(), this.bitSet);
        }
        return super.containsAll(indices);
    }

    @Override
    public int firstInt() {
        int firstSet = this.bitSet.nextSetBit(0);
        if (firstSet == -1) {
            throw new NoSuchElementException();
        }
        return firstSet;
    }

    @Override
    public int lastInt() {
        int lastSet = this.bitSet.length() - 1;
        if (lastSet == -1) {
            throw new NoSuchElementException();
        }
        return lastSet;
    }

    @Override
    public int nextPresentIndex(int index) {
        return this.bitSet.nextSetBit(index);
    }

    @Override
    public int nextAbsentIndex(int index) {
        return this.bitSet.nextClearBit(index);
    }

    @Override
    public int previousPresentIndex(int index) {
        return SparseBitSets.previousPresentIndex(this.bitSet, index);
    }

    @Override
    public int previousAbsentIndex(int index) {
        return SparseBitSets.previousAbsentIndex(this.bitSet, index);
    }

    @Override
    public IntIterator iterator() {
        return SparseBitSets.iterator(this.bitSet);
    }

    public void forEach(IntConsumer consumer) {
        SparseBitSets.forEach(this.bitSet, consumer);
    }

    @Override
    public void set(int index) {
        this.bitSet.set(index);
    }

    @Override
    public void set(int index, boolean value) {
        this.bitSet.set(index, value);
    }

    @Override
    public void set(int from, int to) {
        this.bitSet.set(from, to);
    }

    public void clear() {
        this.bitSet.clear();
    }

    @Override
    public void clear(int index) {
        this.bitSet.clear(index);
    }

    @Override
    public void clear(int from, int to) {
        this.bitSet.clear(from, to);
    }

    @Override
    public void clearFrom(int from) {
        this.bitSet.clear(from, Integer.MAX_VALUE);
    }

    @Override
    public void flip(int from, int to) {
        this.bitSet.flip(from, to);
    }

    @Override
    public void flip(int index) {
        this.bitSet.flip(index);
    }

    @Override
    public boolean intersects(Collection<Integer> indices) {
        if (indices instanceof SparseNatBitSet) {
            SparseNatBitSet other = (SparseNatBitSet)((Object)indices);
            return this.bitSet.intersects(other.bitSet);
        }
        if (indices instanceof SparseBoundedNatBitSet) {
            SparseBoundedNatBitSet other = (SparseBoundedNatBitSet)((Object)indices);
            return this.bitSet.intersects(other.isComplement() ? other.complementBits() : other.getBitSet());
        }
        return super.intersects(indices);
    }

    @Override
    public void and(IntCollection indices) {
        if (indices instanceof SparseNatBitSet) {
            SparseNatBitSet other = (SparseNatBitSet)indices;
            this.bitSet.and(other.bitSet);
        } else if (indices instanceof SparseBoundedNatBitSet) {
            SparseBoundedNatBitSet other = (SparseBoundedNatBitSet)indices;
            this.bitSet.clear(other.domainSize(), Integer.MAX_VALUE);
            if (other.isComplement()) {
                this.bitSet.andNot(other.getBitSet());
            } else {
                this.bitSet.and(other.getBitSet());
            }
        } else {
            super.and(indices);
        }
    }

    @Override
    public void andNot(IntCollection indices) {
        if (this.isEmpty() || indices.isEmpty()) {
            return;
        }
        if (indices instanceof SparseNatBitSet) {
            SparseNatBitSet other = (SparseNatBitSet)indices;
            this.bitSet.andNot(other.bitSet);
        } else if (indices instanceof SparseBoundedNatBitSet) {
            SparseBoundedNatBitSet other = (SparseBoundedNatBitSet)indices;
            int domainSize = other.domainSize();
            if (other.isComplement()) {
                this.bitSet.and(0, domainSize, other.getBitSet());
            } else {
                this.bitSet.andNot(other.getBitSet());
            }
        } else {
            super.andNot(indices);
        }
    }

    @Override
    public void or(IntCollection indices) {
        if (indices instanceof SparseNatBitSet) {
            SparseNatBitSet other = (SparseNatBitSet)indices;
            this.bitSet.or(other.bitSet);
        } else if (indices instanceof SparseBoundedNatBitSet) {
            SparseBoundedNatBitSet other = (SparseBoundedNatBitSet)indices;
            this.bitSet.or(other.isComplement() ? other.complementBits() : other.getBitSet());
        } else {
            super.or(indices);
        }
    }

    @Override
    public void xor(IntCollection indices) {
        if (indices instanceof SparseNatBitSet) {
            SparseNatBitSet other = (SparseNatBitSet)indices;
            this.bitSet.xor(other.bitSet);
        } else if (indices instanceof SparseBoundedNatBitSet) {
            SparseBoundedNatBitSet other = (SparseBoundedNatBitSet)indices;
            this.bitSet.xor(other.getBitSet());
            if (other.isComplement()) {
                this.bitSet.flip(0, other.domainSize());
            }
        } else {
            super.xor(indices);
        }
    }

    @Override
    public SparseNatBitSet clone() {
        return new SparseNatBitSet(this.bitSet.clone());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Set)) {
            return false;
        }
        if (this.isEmpty()) {
            return ((Collection)o).isEmpty();
        }
        if (((Collection)o).isEmpty()) {
            return false;
        }
        if (o instanceof SparseNatBitSet) {
            SparseNatBitSet other = (SparseNatBitSet)o;
            return this.bitSet.equals((Object)other.bitSet);
        }
        if (o instanceof SparseBoundedNatBitSet) {
            SparseBoundedNatBitSet other = (SparseBoundedNatBitSet)o;
            if (this.lastInt() >= other.domainSize()) {
                return false;
            }
            if (other.isComplement()) {
                return this.size() == other.size() && !other.getBitSet().intersects(this.bitSet);
            }
            return this.bitSet.equals((Object)other.getBitSet());
        }
        return super.equals(o);
    }

    SparseBitSet getBitSet() {
        return this.bitSet;
    }
}

