/*
 * Decompiled with CFR 0.152.
 */
package jhoafparser.ast;

import jhoafparser.ast.Atom;

public class AtomAcceptance
implements Atom {
    private Type type;
    private Integer accSet = null;
    private boolean negated = false;

    public AtomAcceptance(Type type, Integer accSet, boolean negated) {
        this.type = type;
        this.accSet = accSet;
        this.negated = negated;
    }

    public static AtomAcceptance Fin(int accSet) {
        return new AtomAcceptance(Type.TEMPORAL_FIN, accSet, false);
    }

    public static AtomAcceptance FinNot(int accSet) {
        return new AtomAcceptance(Type.TEMPORAL_FIN, accSet, true);
    }

    public static AtomAcceptance Inf(int accSet) {
        return new AtomAcceptance(Type.TEMPORAL_INF, accSet, false);
    }

    public static AtomAcceptance InfNot(int accSet) {
        return new AtomAcceptance(Type.TEMPORAL_INF, accSet, true);
    }

    @Override
    public Atom clone() {
        return new AtomAcceptance(this.type, this.accSet, this.negated);
    }

    public Type getType() {
        return this.type;
    }

    public int getAcceptanceSet() {
        return this.accSet;
    }

    public boolean isNegated() {
        return this.negated;
    }

    public AtomAcceptance dual() {
        return new AtomAcceptance(this.type.dual(), this.accSet, !this.negated);
    }

    public String toString() {
        return (this.type == Type.TEMPORAL_FIN ? "Fin" : "Inf") + "(" + (this.negated ? "!" : "") + this.accSet + ")";
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.accSet == null ? 0 : this.accSet.hashCode());
        result = 31 * result + (this.negated ? 1231 : 1237);
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AtomAcceptance)) {
            return false;
        }
        AtomAcceptance other = (AtomAcceptance)obj;
        if (this.type != other.type) {
            return false;
        }
        if (this.accSet == null ? other.accSet != null : !this.accSet.equals(other.accSet)) {
            return false;
        }
        return this.negated == other.negated;
    }

    public static enum Type {
        TEMPORAL_FIN,
        TEMPORAL_INF;


        Type dual() {
            return this == TEMPORAL_FIN ? TEMPORAL_INF : TEMPORAL_FIN;
        }
    }
}

