/*
 * Decompiled with CFR 0.152.
 */
package jhoafparser.consumer;

import java.util.ArrayList;
import java.util.List;
import jhoafparser.ast.AtomLabel;
import jhoafparser.ast.BooleanExpression;
import jhoafparser.consumer.HOAConsumer;
import jhoafparser.consumer.HOAConsumerException;
import jhoafparser.consumer.HOAIntermediate;
import jhoafparser.storage.StoredAutomaton;
import jhoafparser.storage.StoredEdgeImplicit;
import jhoafparser.storage.StoredEdgeWithLabel;
import jhoafparser.storage.StoredState;

public abstract class HOAIntermediateBatchProcessState
extends HOAIntermediate {
    private StoredState state;
    private List<StoredEdgeImplicit> edgesImplicit;
    private List<StoredEdgeWithLabel> edgesWithLabel;

    public HOAIntermediateBatchProcessState(HOAConsumer next) {
        super(next);
    }

    @Override
    public final void addState(int id, String info, BooleanExpression<AtomLabel> labelExpr, List<Integer> accSignature) {
        this.state = new StoredState(id, info, labelExpr, accSignature);
    }

    @Override
    public final void addEdgeImplicit(int stateId, List<Integer> conjSuccessors, List<Integer> accSignature) throws HOAConsumerException {
        if (this.edgesImplicit == null) {
            this.edgesImplicit = new ArrayList<StoredEdgeImplicit>();
        }
        if (this.edgesWithLabel != null) {
            throw new HOAConsumerException("Can not mix implicit and explicit edges (state " + stateId + ")");
        }
        this.edgesImplicit.add(new StoredEdgeImplicit(conjSuccessors, accSignature));
    }

    @Override
    public final void addEdgeWithLabel(int stateId, BooleanExpression<AtomLabel> labelExpr, List<Integer> conjSuccessors, List<Integer> accSignature) throws HOAConsumerException {
        if (this.edgesWithLabel == null) {
            this.edgesWithLabel = new ArrayList<StoredEdgeWithLabel>();
        }
        if (this.edgesImplicit != null) {
            throw new HOAConsumerException("Can not mix implicit and explicit edges (state " + stateId + ")");
        }
        this.edgesWithLabel.add(new StoredEdgeWithLabel(labelExpr, conjSuccessors, accSignature));
    }

    @Override
    public void notifyEndOfState(int stateId) throws HOAConsumerException {
        boolean rv = this.processState(this.state, this.edgesImplicit, this.edgesWithLabel);
        if (rv) {
            this.next.addState(this.state.getStateId(), this.state.getInfo(), this.state.getLabelExpr(), this.state.getAccSignature());
            StoredAutomaton.feedEdgesToConsumer(this.next, this.state.getStateId(), this.edgesImplicit, this.edgesWithLabel);
            this.next.notifyEndOfState(this.state.getStateId());
        }
        this.state = null;
        this.edgesImplicit = null;
        this.edgesWithLabel = null;
    }

    public abstract boolean processState(StoredState var1, List<StoredEdgeImplicit> var2, List<StoredEdgeWithLabel> var3) throws HOAConsumerException;
}

