/*
 * Decompiled with CFR 0.152.
 */
package de.tum.in.jbdd;

import de.tum.in.jbdd.Bdd;
import de.tum.in.jbdd.BddCache;
import de.tum.in.jbdd.BddConfiguration;
import de.tum.in.jbdd.MathUtil;
import de.tum.in.jbdd.NodeTable;
import de.tum.in.jbdd.PowerIterator;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collections;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.stream.IntStream;

abstract class AbstractBdd
extends NodeTable
implements Bdd {
    static final BigInteger TWO = BigInteger.ONE.add(BigInteger.ONE);
    protected static final int FALSE_NODE = 0;
    protected static final int TRUE_NODE = 1;
    protected final BddCache cache = new BddCache(this);
    protected int numberOfVariables;
    protected int[] variableNodes;

    AbstractBdd(int nodeSize, BddConfiguration configuration) {
        super(MathUtil.nextPrime(nodeSize), configuration);
        this.variableNodes = new int[configuration.initialVariableNodes()];
        this.numberOfVariables = 0;
    }

    protected static boolean isVariableOrNegatedStore(long nodeStore) {
        int low = (int)AbstractBdd.getLowFromStore(nodeStore);
        int high = (int)AbstractBdd.getHighFromStore(nodeStore);
        return low == 0 && high == 1 || low == 1 && high == 0;
    }

    @Override
    public int trueNode() {
        return 1;
    }

    @Override
    public int falseNode() {
        return 0;
    }

    @Override
    public int numberOfVariables() {
        return this.numberOfVariables;
    }

    @Override
    public int variableNode(int variableNumber) {
        assert (0 <= variableNumber && variableNumber < this.numberOfVariables);
        return this.variableNodes[variableNumber];
    }

    @Override
    public int createVariable() {
        int variableNode = this.saturateNode(this.makeNode(this.numberOfVariables, 0, 1));
        int notVariableNode = this.saturateNode(this.makeNode(this.numberOfVariables, 1, 0));
        if (this.numberOfVariables == this.variableNodes.length) {
            this.variableNodes = Arrays.copyOf(this.variableNodes, this.variableNodes.length * 2);
        }
        this.variableNodes[this.numberOfVariables] = variableNode;
        ++this.numberOfVariables;
        this.cache.putNot(variableNode, notVariableNode);
        this.cache.putNot(notVariableNode, variableNode);
        this.growTree(this.numberOfVariables);
        this.cache.invalidateSatisfaction();
        this.cache.invalidateCompose();
        this.cache.reallocateVolatile();
        this.afterVariableCountChanged();
        return variableNode;
    }

    @Override
    public int[] createVariables(int count) {
        int newSize = this.numberOfVariables + count;
        if (newSize >= this.variableNodes.length) {
            this.variableNodes = Arrays.copyOf(this.variableNodes, Math.max(this.variableNodes.length * 2, newSize));
        }
        int[] variableNodes = new int[count];
        for (int i = 0; i < count; ++i) {
            int variable = this.numberOfVariables + i;
            int variableNode = this.saturateNode(this.makeNode(variable, 0, 1));
            int notVariableNode = this.saturateNode(this.makeNode(variable, 1, 0));
            variableNodes[i] = variableNode;
            this.variableNodes[variable] = variableNode;
            this.cache.putNot(variableNode, notVariableNode);
            this.cache.putNot(notVariableNode, variableNode);
        }
        this.numberOfVariables += count;
        this.growTree(this.numberOfVariables);
        this.cache.invalidateSatisfaction();
        this.cache.invalidateCompose();
        this.cache.reallocateVolatile();
        this.afterVariableCountChanged();
        return variableNodes;
    }

    protected abstract void afterVariableCountChanged();

    @Override
    public boolean isVariable(int node) {
        if (this.isNodeRoot(node)) {
            return false;
        }
        long nodeStore = this.getNodeStore(node);
        return (int)AbstractBdd.getLowFromStore(nodeStore) == 0 && (int)AbstractBdd.getHighFromStore(nodeStore) == 1;
    }

    @Override
    public boolean isVariableNegated(int node) {
        if (this.isNodeRoot(node)) {
            return false;
        }
        long nodeStore = this.getNodeStore(node);
        return (int)AbstractBdd.getLowFromStore(nodeStore) == 1 && (int)AbstractBdd.getHighFromStore(nodeStore) == 0;
    }

    @Override
    public boolean isVariableOrNegated(int node) {
        assert (this.isNodeValidOrRoot(node));
        if (this.isNodeRoot(node)) {
            return false;
        }
        long nodeStore = this.getNodeStore(node);
        return AbstractBdd.isVariableOrNegatedStore(nodeStore);
    }

    @Override
    public boolean evaluate(int node, boolean[] assignment) {
        int currentBdd = node;
        while (currentBdd >= 2) {
            long currentBddStore = this.getNodeStore(currentBdd);
            int currentBddVariable = (int)AbstractBdd.getVariableFromStore(currentBddStore);
            currentBdd = (int)(assignment[currentBddVariable] ? AbstractBdd.getHighFromStore(currentBddStore) : AbstractBdd.getLowFromStore(currentBddStore));
        }
        return currentBdd == 1;
    }

    @Override
    public boolean evaluate(int node, BitSet assignment) {
        int currentBdd = node;
        while (currentBdd >= 2) {
            long currentBddStore = this.getNodeStore(currentBdd);
            int currentBddVariable = (int)AbstractBdd.getVariableFromStore(currentBddStore);
            currentBdd = (int)(assignment.get(currentBddVariable) ? AbstractBdd.getHighFromStore(currentBddStore) : AbstractBdd.getLowFromStore(currentBddStore));
        }
        return currentBdd == 1;
    }

    @Override
    public BitSet getSatisfyingAssignment(int node) {
        assert (this.isNodeValidOrRoot(node));
        if (node == 0) {
            throw new NoSuchElementException("False has no solution");
        }
        BitSet path = new BitSet(this.numberOfVariables);
        int currentNode = node;
        while (currentNode != 1) {
            long store = this.getNodeStore(currentNode);
            int lowNode = (int)AbstractBdd.getLowFromStore(store);
            if (lowNode == 0) {
                int highNode = (int)AbstractBdd.getHighFromStore(store);
                int variable = (int)AbstractBdd.getVariableFromStore(store);
                path.set(variable);
                currentNode = highNode;
                continue;
            }
            currentNode = lowNode;
        }
        return path;
    }

    @Override
    public Iterator<BitSet> solutionIterator(int node) {
        if (node == 0) {
            return Collections.emptyIterator();
        }
        if (node == 1) {
            return new PowerIterator(this.numberOfVariables);
        }
        return new NodeSolutionIterator(this, node);
    }

    abstract int existsSelfSubstitution(int var1, BitSet var2);

    abstract int existsShannon(int var1, BitSet var2);

    @Override
    void notifyGcRun() {
        this.cache.invalidate();
    }

    @Override
    void notifyTableSizeChanged() {
        this.cache.invalidate();
    }

    @Override
    public String statistics() {
        return super.getStatistics() + '\n' + this.cache.getStatistics();
    }

    static final class NodeSolutionIterator
    implements Iterator<BitSet> {
        private static final int NON_PATH_NODE = -1;
        private final AbstractBdd bdd;
        private final BitSet assignment;
        private final int variableCount;
        private final int[] path;
        private boolean firstRun = true;
        private int highestLowVariableWithNonFalseHighBranch = 0;
        private int leafNodeIndex;
        private boolean hasNextPath;
        private boolean hasNextAssignment;
        private final int rootVariable;

        NodeSolutionIterator(AbstractBdd bdd, int node) {
            assert (bdd.isNodeValid(node) || node == 1);
            this.variableCount = bdd.numberOfVariables();
            assert (this.variableCount > 0);
            this.bdd = bdd;
            this.path = new int[this.variableCount];
            this.assignment = new BitSet(this.variableCount);
            this.rootVariable = bdd.variable(node);
            Arrays.fill(this.path, -1);
            this.path[this.rootVariable] = node;
            this.leafNodeIndex = 0;
            this.hasNextPath = true;
            this.hasNextAssignment = true;
        }

        @Override
        public boolean hasNext() {
            assert (!this.hasNextPath || this.hasNextAssignment);
            return this.hasNextAssignment;
        }

        @Override
        public BitSet next() {
            int currentNode;
            if (this.firstRun) {
                this.firstRun = false;
                currentNode = this.path[this.rootVariable];
            } else {
                boolean clearedAny = false;
                for (int index2 = 0; index2 < this.variableCount; ++index2) {
                    if (this.path[index2] != -1) continue;
                    if (this.assignment.get(index2)) {
                        this.assignment.clear(index2);
                        clearedAny = true;
                        continue;
                    }
                    this.assignment.set(index2);
                    if (this.hasNextPath || clearedAny) {
                        this.hasNextAssignment = true;
                    } else {
                        this.hasNextAssignment = false;
                        for (int i = index2 + 1; i < this.variableCount; ++i) {
                            if (this.path[i] != -1 || this.assignment.get(i)) continue;
                            this.hasNextAssignment = true;
                            break;
                        }
                    }
                    assert (this.bdd.evaluate(this.path[this.rootVariable], this.assignment));
                    return this.assignment;
                }
                assert (IntStream.range(0, this.variableCount).noneMatch(index -> this.path[index] == -1 && this.assignment.get(index)));
                assert (this.hasNextPath) : "Expected another path after " + this.assignment + ", node:\n" + this.bdd.treeToString(this.path[this.rootVariable]);
                currentNode = this.path[this.leafNodeIndex];
                int branchIndex = this.leafNodeIndex;
                while (this.assignment.get(branchIndex) || this.bdd.high(currentNode) == 0) {
                    do {
                        if (--branchIndex != -1) continue;
                        throw new NoSuchElementException("No next element");
                    } while (this.path[branchIndex] == -1);
                    currentNode = this.path[branchIndex];
                }
                assert (!this.assignment.get(branchIndex) && this.bdd.high(currentNode) != 0);
                assert (this.leafNodeIndex >= this.highestLowVariableWithNonFalseHighBranch);
                assert (this.bdd.variable(currentNode) == branchIndex);
                this.assignment.clear(branchIndex + 1, this.leafNodeIndex + 1);
                Arrays.fill(this.path, branchIndex + 1, this.leafNodeIndex + 1, -1);
                this.assignment.set(branchIndex);
                assert (this.path[branchIndex] == currentNode);
                currentNode = this.bdd.high(currentNode);
                assert (currentNode != 0);
                this.leafNodeIndex = branchIndex;
                if (this.highestLowVariableWithNonFalseHighBranch == this.leafNodeIndex) {
                    this.highestLowVariableWithNonFalseHighBranch = -1;
                }
            }
            boolean bl = this.hasNextPath = this.highestLowVariableWithNonFalseHighBranch > -1 && this.highestLowVariableWithNonFalseHighBranch < this.leafNodeIndex;
            while (currentNode != 1) {
                assert (currentNode != 0);
                long currentNodeStore = this.bdd.getNodeStore(currentNode);
                this.leafNodeIndex = (int)NodeTable.getVariableFromStore(currentNodeStore);
                this.path[this.leafNodeIndex] = currentNode;
                int low = (int)NodeTable.getLowFromStore(currentNodeStore);
                if (low == 0) {
                    this.assignment.set(this.leafNodeIndex);
                    currentNode = (int)NodeTable.getHighFromStore(currentNodeStore);
                    continue;
                }
                if (!this.hasNextPath && (int)NodeTable.getHighFromStore(currentNodeStore) != 0) {
                    this.hasNextPath = true;
                    this.highestLowVariableWithNonFalseHighBranch = this.leafNodeIndex;
                }
                currentNode = low;
            }
            assert (this.bdd.evaluate(this.path[this.rootVariable], this.assignment));
            for (int node : this.path) {
                if (node != -1) continue;
                this.hasNextAssignment = true;
                return this.assignment;
            }
            this.hasNextAssignment = this.hasNextPath;
            return this.assignment;
        }
    }
}

