/*
 * Decompiled with CFR 0.152.
 */
package de.tum.in.jbdd;

import de.tum.in.jbdd.Bdd;
import de.tum.in.jbdd.BddConfiguration;
import de.tum.in.jbdd.BddIterative;
import de.tum.in.jbdd.BddRecursive;
import de.tum.in.jbdd.CheckedBdd;
import de.tum.in.jbdd.ImmutableBddConfiguration;

public final class BddFactory {
    private BddFactory() {
    }

    public static Bdd buildBdd(int nodeSize) {
        return new BddIterative(nodeSize, ImmutableBddConfiguration.builder().build());
    }

    public static Bdd buildBddRecursive(int nodeSize, BddConfiguration configuration) {
        BddRecursive bdd = new BddRecursive(nodeSize, configuration);
        return configuration.threadSafetyCheck() ? new CheckedBdd(bdd) : bdd;
    }

    public static Bdd buildBddIterative(int nodeSize, BddConfiguration configuration) {
        BddIterative bdd = new BddIterative(nodeSize, configuration);
        return configuration.threadSafetyCheck() ? new CheckedBdd(bdd) : bdd;
    }
}

