/*
 * Decompiled with CFR 0.152.
 */
package de.tum.in.jbdd;

import de.tum.in.jbdd.Bdd;
import de.tum.in.jbdd.HashUtil;
import java.math.BigInteger;
import java.util.AbstractSet;
import java.util.BitSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;

public class BddSet
extends AbstractSet<BitSet> {
    private final Bdd bdd;
    private final int node;

    public BddSet(Bdd bdd, int node) {
        this.bdd = bdd;
        this.node = node;
    }

    public int node() {
        return this.node;
    }

    public Bdd bdd() {
        return this.bdd;
    }

    @Override
    public boolean isEmpty() {
        return this.node == this.bdd.falseNode();
    }

    public boolean isUniverse() {
        return this.node == this.bdd.trueNode();
    }

    @Override
    public boolean contains(Object o) {
        return o instanceof BitSet && this.bdd.evaluate(this.node, (BitSet)o);
    }

    @Override
    public boolean containsAll(Collection<?> collection) {
        if (collection instanceof BddSet) {
            BddSet other = (BddSet)collection;
            if (this.bdd == other.bdd) {
                return this.bdd.implies(other.node, this.node);
            }
        }
        return super.containsAll(collection);
    }

    @Override
    public Iterator<BitSet> iterator() {
        return this.bdd.solutionIterator(this.node);
    }

    @Override
    public void forEach(Consumer<? super BitSet> consumer) {
        this.bdd.forEachSolution(this.node, consumer);
    }

    @Override
    public int size() {
        return this.sizeBig().intValueExact();
    }

    public BigInteger sizeBig() {
        return this.bdd.countSatisfyingAssignments(this.node);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return false;
        }
        if (!(o instanceof Set)) {
            return false;
        }
        Set other = (Set)o;
        BigInteger size = this.bdd.countSatisfyingAssignments(this.node);
        if (o instanceof BddSet) {
            BddSet otherBdd = (BddSet)o;
            BigInteger otherSize = otherBdd.bdd.countSatisfyingAssignments(otherBdd.node);
            if (!size.equals(otherSize)) {
                return false;
            }
            if (this.bdd == otherBdd.bdd) {
                return this.node == otherBdd.node;
            }
        } else if (size.intValueExact() != other.size()) {
            return false;
        }
        for (BitSet bitSet : this) {
            if (other.contains(bitSet)) continue;
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        return this.bdd.hashCode() * 31 + HashUtil.hash(this.node);
    }

    @Override
    public boolean add(BitSet bitSet) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean remove(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(Collection<? extends BitSet> collection) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean retainAll(Collection<?> collection) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeIf(Predicate<? super BitSet> predicate) {
        throw new UnsupportedOperationException();
    }
}

