/*
 * Decompiled with CFR 0.152.
 */
package de.tum.in.jbdd;

import de.tum.in.jbdd.Bdd;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class CanonicalGcManager<V> {
    private static final Logger logger = Logger.getLogger(CanonicalGcManager.class.getName());
    private final Bdd bdd;
    private final Map<Integer, NodeReference<V>> gcObjects = new HashMap<Integer, NodeReference<V>>();
    private final Map<Integer, V> nonGcObjects = new HashMap<Integer, V>();
    private final ReferenceQueue<V> queue = new ReferenceQueue();

    public CanonicalGcManager(Bdd bdd) {
        this.bdd = bdd;
    }

    public V canonicalize(int node, V wrapper) {
        if (this.bdd.isNodeRoot(node) || this.bdd.isVariableOrNegated(node)) {
            assert (this.bdd.getReferenceCount(node) == -1) : CanonicalGcManager.reportReferenceCountMismatch(-1, this.bdd.getReferenceCount(node));
            return (V)this.nonGcObjects.merge(node, wrapper, (oldWrapper, newWrapper) -> oldWrapper);
        }
        NodeReference<V> canonicalReference = this.gcObjects.get(node);
        if (canonicalReference == null) {
            assert (this.bdd.getReferenceCount(node) == 0) : CanonicalGcManager.reportReferenceCountMismatch(0, this.bdd.getReferenceCount(node));
            this.bdd.reference(node);
        } else {
            assert (this.bdd.getReferenceCount(node) == 1) : CanonicalGcManager.reportReferenceCountMismatch(1, this.bdd.getReferenceCount(node));
            Object canonicalWrapper = canonicalReference.get();
            if (canonicalWrapper == null) {
                canonicalReference.enqueue();
            } else {
                return (V)canonicalWrapper;
            }
        }
        assert (this.bdd.getReferenceCount(node) == 1);
        this.processReferenceQueue(node);
        this.gcObjects.put(node, new NodeReference<V>(wrapper, this.queue, node));
        assert (this.bdd.getReferenceCount(node) == 1);
        return wrapper;
    }

    private void processReferenceQueue(int protectedNode) {
        Reference<V> reference = this.queue.poll();
        if (reference == null) {
            return;
        }
        int count = 0;
        do {
            int node = ((NodeReference)reference).node();
            this.gcObjects.remove(node);
            if (node == protectedNode) continue;
            assert (this.bdd.getReferenceCount(node) == 1);
            this.bdd.dereference(node);
            assert (this.bdd.getReferenceCount(node) == 0);
            ++count;
        } while ((reference = this.queue.poll()) != null);
        logger.log(Level.FINEST, "Cleared {0} references", count);
    }

    private static String reportReferenceCountMismatch(int expected, int actual) {
        return String.format("Expected reference count {%d}, but actual count is {%d}.", expected, actual);
    }

    private static final class NodeReference<V>
    extends WeakReference<V> {
        private final int node;

        NodeReference(V referent, ReferenceQueue<? super V> q, int node) {
            super(referent, q);
            this.node = node;
        }

        int node() {
            return this.node;
        }
    }
}

