/*
 * Decompiled with CFR 0.152.
 */
package de.tum.in.jbdd;

import de.tum.in.jbdd.BddConfiguration;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@Generated(from="BddConfiguration", generator="Immutables")
@Immutable
public final class ImmutableBddConfiguration
extends BddConfiguration {
    private final int cacheBinaryBinsPerHash;
    private final int cacheBinaryDivider;
    private final int cacheComposeDivider;
    private final int cacheSatisfactionBinsPerHash;
    private final int cacheSatisfactionDivider;
    private final int cacheTernaryBinsPerHash;
    private final int cacheTernaryDivider;
    private final int cacheNegationBinsPerHash;
    private final int cacheNegationDivider;
    private final int cacheVolatileBinsPerHash;
    private final int cacheVolatileMultiplier;
    private final int initialVariableNodes;
    private final boolean logStatisticsOnShutdown;
    private final int minimumCacheSize;
    private final double minimumFreeNodePercentageAfterGc;
    private final double growthFactor;
    private final boolean useGlobalComposeCache;
    private final boolean useShannonExists;
    private final boolean useGarbageCollection;
    private final int integrityDuplicatesMaximalSize;
    private final boolean threadSafetyCheck;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableBddConfiguration(Builder builder) {
        if (builder.cacheBinaryBinsPerHashIsSet()) {
            this.initShim.cacheBinaryBinsPerHash(builder.cacheBinaryBinsPerHash);
        }
        if (builder.cacheBinaryDividerIsSet()) {
            this.initShim.cacheBinaryDivider(builder.cacheBinaryDivider);
        }
        if (builder.cacheComposeDividerIsSet()) {
            this.initShim.cacheComposeDivider(builder.cacheComposeDivider);
        }
        if (builder.cacheSatisfactionBinsPerHashIsSet()) {
            this.initShim.cacheSatisfactionBinsPerHash(builder.cacheSatisfactionBinsPerHash);
        }
        if (builder.cacheSatisfactionDividerIsSet()) {
            this.initShim.cacheSatisfactionDivider(builder.cacheSatisfactionDivider);
        }
        if (builder.cacheTernaryBinsPerHashIsSet()) {
            this.initShim.cacheTernaryBinsPerHash(builder.cacheTernaryBinsPerHash);
        }
        if (builder.cacheTernaryDividerIsSet()) {
            this.initShim.cacheTernaryDivider(builder.cacheTernaryDivider);
        }
        if (builder.cacheNegationBinsPerHashIsSet()) {
            this.initShim.cacheNegationBinsPerHash(builder.cacheNegationBinsPerHash);
        }
        if (builder.cacheNegationDividerIsSet()) {
            this.initShim.cacheNegationDivider(builder.cacheNegationDivider);
        }
        if (builder.cacheVolatileBinsPerHashIsSet()) {
            this.initShim.cacheVolatileBinsPerHash(builder.cacheVolatileBinsPerHash);
        }
        if (builder.cacheVolatileMultiplierIsSet()) {
            this.initShim.cacheVolatileMultiplier(builder.cacheVolatileMultiplier);
        }
        if (builder.initialVariableNodesIsSet()) {
            this.initShim.initialVariableNodes(builder.initialVariableNodes);
        }
        if (builder.logStatisticsOnShutdownIsSet()) {
            this.initShim.logStatisticsOnShutdown(builder.logStatisticsOnShutdown);
        }
        if (builder.minimumCacheSizeIsSet()) {
            this.initShim.minimumCacheSize(builder.minimumCacheSize);
        }
        if (builder.minimumFreeNodePercentageAfterGcIsSet()) {
            this.initShim.minimumFreeNodePercentageAfterGc(builder.minimumFreeNodePercentageAfterGc);
        }
        if (builder.growthFactorIsSet()) {
            this.initShim.growthFactor(builder.growthFactor);
        }
        if (builder.useGlobalComposeCacheIsSet()) {
            this.initShim.useGlobalComposeCache(builder.useGlobalComposeCache);
        }
        if (builder.useShannonExistsIsSet()) {
            this.initShim.useShannonExists(builder.useShannonExists);
        }
        if (builder.useGarbageCollectionIsSet()) {
            this.initShim.useGarbageCollection(builder.useGarbageCollection);
        }
        if (builder.integrityDuplicatesMaximalSizeIsSet()) {
            this.initShim.integrityDuplicatesMaximalSize(builder.integrityDuplicatesMaximalSize);
        }
        if (builder.threadSafetyCheckIsSet()) {
            this.initShim.threadSafetyCheck(builder.threadSafetyCheck);
        }
        this.cacheBinaryBinsPerHash = this.initShim.cacheBinaryBinsPerHash();
        this.cacheBinaryDivider = this.initShim.cacheBinaryDivider();
        this.cacheComposeDivider = this.initShim.cacheComposeDivider();
        this.cacheSatisfactionBinsPerHash = this.initShim.cacheSatisfactionBinsPerHash();
        this.cacheSatisfactionDivider = this.initShim.cacheSatisfactionDivider();
        this.cacheTernaryBinsPerHash = this.initShim.cacheTernaryBinsPerHash();
        this.cacheTernaryDivider = this.initShim.cacheTernaryDivider();
        this.cacheNegationBinsPerHash = this.initShim.cacheNegationBinsPerHash();
        this.cacheNegationDivider = this.initShim.cacheNegationDivider();
        this.cacheVolatileBinsPerHash = this.initShim.cacheVolatileBinsPerHash();
        this.cacheVolatileMultiplier = this.initShim.cacheVolatileMultiplier();
        this.initialVariableNodes = this.initShim.initialVariableNodes();
        this.logStatisticsOnShutdown = this.initShim.logStatisticsOnShutdown();
        this.minimumCacheSize = this.initShim.minimumCacheSize();
        this.minimumFreeNodePercentageAfterGc = this.initShim.minimumFreeNodePercentageAfterGc();
        this.growthFactor = this.initShim.growthFactor();
        this.useGlobalComposeCache = this.initShim.useGlobalComposeCache();
        this.useShannonExists = this.initShim.useShannonExists();
        this.useGarbageCollection = this.initShim.useGarbageCollection();
        this.integrityDuplicatesMaximalSize = this.initShim.integrityDuplicatesMaximalSize();
        this.threadSafetyCheck = this.initShim.threadSafetyCheck();
        this.initShim = null;
    }

    private ImmutableBddConfiguration(int cacheBinaryBinsPerHash, int cacheBinaryDivider, int cacheComposeDivider, int cacheSatisfactionBinsPerHash, int cacheSatisfactionDivider, int cacheTernaryBinsPerHash, int cacheTernaryDivider, int cacheNegationBinsPerHash, int cacheNegationDivider, int cacheVolatileBinsPerHash, int cacheVolatileMultiplier, int initialVariableNodes, boolean logStatisticsOnShutdown, int minimumCacheSize, double minimumFreeNodePercentageAfterGc, double growthFactor, boolean useGlobalComposeCache, boolean useShannonExists, boolean useGarbageCollection, int integrityDuplicatesMaximalSize, boolean threadSafetyCheck) {
        this.cacheBinaryBinsPerHash = cacheBinaryBinsPerHash;
        this.cacheBinaryDivider = cacheBinaryDivider;
        this.cacheComposeDivider = cacheComposeDivider;
        this.cacheSatisfactionBinsPerHash = cacheSatisfactionBinsPerHash;
        this.cacheSatisfactionDivider = cacheSatisfactionDivider;
        this.cacheTernaryBinsPerHash = cacheTernaryBinsPerHash;
        this.cacheTernaryDivider = cacheTernaryDivider;
        this.cacheNegationBinsPerHash = cacheNegationBinsPerHash;
        this.cacheNegationDivider = cacheNegationDivider;
        this.cacheVolatileBinsPerHash = cacheVolatileBinsPerHash;
        this.cacheVolatileMultiplier = cacheVolatileMultiplier;
        this.initialVariableNodes = initialVariableNodes;
        this.logStatisticsOnShutdown = logStatisticsOnShutdown;
        this.minimumCacheSize = minimumCacheSize;
        this.minimumFreeNodePercentageAfterGc = minimumFreeNodePercentageAfterGc;
        this.growthFactor = growthFactor;
        this.useGlobalComposeCache = useGlobalComposeCache;
        this.useShannonExists = useShannonExists;
        this.useGarbageCollection = useGarbageCollection;
        this.integrityDuplicatesMaximalSize = integrityDuplicatesMaximalSize;
        this.threadSafetyCheck = threadSafetyCheck;
        this.initShim = null;
    }

    @Override
    public int cacheBinaryBinsPerHash() {
        InitShim shim = this.initShim;
        return shim != null ? shim.cacheBinaryBinsPerHash() : this.cacheBinaryBinsPerHash;
    }

    @Override
    public int cacheBinaryDivider() {
        InitShim shim = this.initShim;
        return shim != null ? shim.cacheBinaryDivider() : this.cacheBinaryDivider;
    }

    @Override
    public int cacheComposeDivider() {
        InitShim shim = this.initShim;
        return shim != null ? shim.cacheComposeDivider() : this.cacheComposeDivider;
    }

    @Override
    public int cacheSatisfactionBinsPerHash() {
        InitShim shim = this.initShim;
        return shim != null ? shim.cacheSatisfactionBinsPerHash() : this.cacheSatisfactionBinsPerHash;
    }

    @Override
    public int cacheSatisfactionDivider() {
        InitShim shim = this.initShim;
        return shim != null ? shim.cacheSatisfactionDivider() : this.cacheSatisfactionDivider;
    }

    @Override
    public int cacheTernaryBinsPerHash() {
        InitShim shim = this.initShim;
        return shim != null ? shim.cacheTernaryBinsPerHash() : this.cacheTernaryBinsPerHash;
    }

    @Override
    public int cacheTernaryDivider() {
        InitShim shim = this.initShim;
        return shim != null ? shim.cacheTernaryDivider() : this.cacheTernaryDivider;
    }

    @Override
    public int cacheNegationBinsPerHash() {
        InitShim shim = this.initShim;
        return shim != null ? shim.cacheNegationBinsPerHash() : this.cacheNegationBinsPerHash;
    }

    @Override
    public int cacheNegationDivider() {
        InitShim shim = this.initShim;
        return shim != null ? shim.cacheNegationDivider() : this.cacheNegationDivider;
    }

    @Override
    public int cacheVolatileBinsPerHash() {
        InitShim shim = this.initShim;
        return shim != null ? shim.cacheVolatileBinsPerHash() : this.cacheVolatileBinsPerHash;
    }

    @Override
    public int cacheVolatileMultiplier() {
        InitShim shim = this.initShim;
        return shim != null ? shim.cacheVolatileMultiplier() : this.cacheVolatileMultiplier;
    }

    @Override
    public int initialVariableNodes() {
        InitShim shim = this.initShim;
        return shim != null ? shim.initialVariableNodes() : this.initialVariableNodes;
    }

    @Override
    public boolean logStatisticsOnShutdown() {
        InitShim shim = this.initShim;
        return shim != null ? shim.logStatisticsOnShutdown() : this.logStatisticsOnShutdown;
    }

    @Override
    public int minimumCacheSize() {
        InitShim shim = this.initShim;
        return shim != null ? shim.minimumCacheSize() : this.minimumCacheSize;
    }

    @Override
    public double minimumFreeNodePercentageAfterGc() {
        InitShim shim = this.initShim;
        return shim != null ? shim.minimumFreeNodePercentageAfterGc() : this.minimumFreeNodePercentageAfterGc;
    }

    @Override
    public double growthFactor() {
        InitShim shim = this.initShim;
        return shim != null ? shim.growthFactor() : this.growthFactor;
    }

    @Override
    public boolean useGlobalComposeCache() {
        InitShim shim = this.initShim;
        return shim != null ? shim.useGlobalComposeCache() : this.useGlobalComposeCache;
    }

    @Override
    public boolean useShannonExists() {
        InitShim shim = this.initShim;
        return shim != null ? shim.useShannonExists() : this.useShannonExists;
    }

    @Override
    public boolean useGarbageCollection() {
        InitShim shim = this.initShim;
        return shim != null ? shim.useGarbageCollection() : this.useGarbageCollection;
    }

    @Override
    public int integrityDuplicatesMaximalSize() {
        InitShim shim = this.initShim;
        return shim != null ? shim.integrityDuplicatesMaximalSize() : this.integrityDuplicatesMaximalSize;
    }

    @Override
    public boolean threadSafetyCheck() {
        InitShim shim = this.initShim;
        return shim != null ? shim.threadSafetyCheck() : this.threadSafetyCheck;
    }

    public final ImmutableBddConfiguration withCacheBinaryBinsPerHash(int value) {
        if (this.cacheBinaryBinsPerHash == value) {
            return this;
        }
        return new ImmutableBddConfiguration(value, this.cacheBinaryDivider, this.cacheComposeDivider, this.cacheSatisfactionBinsPerHash, this.cacheSatisfactionDivider, this.cacheTernaryBinsPerHash, this.cacheTernaryDivider, this.cacheNegationBinsPerHash, this.cacheNegationDivider, this.cacheVolatileBinsPerHash, this.cacheVolatileMultiplier, this.initialVariableNodes, this.logStatisticsOnShutdown, this.minimumCacheSize, this.minimumFreeNodePercentageAfterGc, this.growthFactor, this.useGlobalComposeCache, this.useShannonExists, this.useGarbageCollection, this.integrityDuplicatesMaximalSize, this.threadSafetyCheck);
    }

    public final ImmutableBddConfiguration withCacheBinaryDivider(int value) {
        if (this.cacheBinaryDivider == value) {
            return this;
        }
        return new ImmutableBddConfiguration(this.cacheBinaryBinsPerHash, value, this.cacheComposeDivider, this.cacheSatisfactionBinsPerHash, this.cacheSatisfactionDivider, this.cacheTernaryBinsPerHash, this.cacheTernaryDivider, this.cacheNegationBinsPerHash, this.cacheNegationDivider, this.cacheVolatileBinsPerHash, this.cacheVolatileMultiplier, this.initialVariableNodes, this.logStatisticsOnShutdown, this.minimumCacheSize, this.minimumFreeNodePercentageAfterGc, this.growthFactor, this.useGlobalComposeCache, this.useShannonExists, this.useGarbageCollection, this.integrityDuplicatesMaximalSize, this.threadSafetyCheck);
    }

    public final ImmutableBddConfiguration withCacheComposeDivider(int value) {
        if (this.cacheComposeDivider == value) {
            return this;
        }
        return new ImmutableBddConfiguration(this.cacheBinaryBinsPerHash, this.cacheBinaryDivider, value, this.cacheSatisfactionBinsPerHash, this.cacheSatisfactionDivider, this.cacheTernaryBinsPerHash, this.cacheTernaryDivider, this.cacheNegationBinsPerHash, this.cacheNegationDivider, this.cacheVolatileBinsPerHash, this.cacheVolatileMultiplier, this.initialVariableNodes, this.logStatisticsOnShutdown, this.minimumCacheSize, this.minimumFreeNodePercentageAfterGc, this.growthFactor, this.useGlobalComposeCache, this.useShannonExists, this.useGarbageCollection, this.integrityDuplicatesMaximalSize, this.threadSafetyCheck);
    }

    public final ImmutableBddConfiguration withCacheSatisfactionBinsPerHash(int value) {
        if (this.cacheSatisfactionBinsPerHash == value) {
            return this;
        }
        return new ImmutableBddConfiguration(this.cacheBinaryBinsPerHash, this.cacheBinaryDivider, this.cacheComposeDivider, value, this.cacheSatisfactionDivider, this.cacheTernaryBinsPerHash, this.cacheTernaryDivider, this.cacheNegationBinsPerHash, this.cacheNegationDivider, this.cacheVolatileBinsPerHash, this.cacheVolatileMultiplier, this.initialVariableNodes, this.logStatisticsOnShutdown, this.minimumCacheSize, this.minimumFreeNodePercentageAfterGc, this.growthFactor, this.useGlobalComposeCache, this.useShannonExists, this.useGarbageCollection, this.integrityDuplicatesMaximalSize, this.threadSafetyCheck);
    }

    public final ImmutableBddConfiguration withCacheSatisfactionDivider(int value) {
        if (this.cacheSatisfactionDivider == value) {
            return this;
        }
        return new ImmutableBddConfiguration(this.cacheBinaryBinsPerHash, this.cacheBinaryDivider, this.cacheComposeDivider, this.cacheSatisfactionBinsPerHash, value, this.cacheTernaryBinsPerHash, this.cacheTernaryDivider, this.cacheNegationBinsPerHash, this.cacheNegationDivider, this.cacheVolatileBinsPerHash, this.cacheVolatileMultiplier, this.initialVariableNodes, this.logStatisticsOnShutdown, this.minimumCacheSize, this.minimumFreeNodePercentageAfterGc, this.growthFactor, this.useGlobalComposeCache, this.useShannonExists, this.useGarbageCollection, this.integrityDuplicatesMaximalSize, this.threadSafetyCheck);
    }

    public final ImmutableBddConfiguration withCacheTernaryBinsPerHash(int value) {
        if (this.cacheTernaryBinsPerHash == value) {
            return this;
        }
        return new ImmutableBddConfiguration(this.cacheBinaryBinsPerHash, this.cacheBinaryDivider, this.cacheComposeDivider, this.cacheSatisfactionBinsPerHash, this.cacheSatisfactionDivider, value, this.cacheTernaryDivider, this.cacheNegationBinsPerHash, this.cacheNegationDivider, this.cacheVolatileBinsPerHash, this.cacheVolatileMultiplier, this.initialVariableNodes, this.logStatisticsOnShutdown, this.minimumCacheSize, this.minimumFreeNodePercentageAfterGc, this.growthFactor, this.useGlobalComposeCache, this.useShannonExists, this.useGarbageCollection, this.integrityDuplicatesMaximalSize, this.threadSafetyCheck);
    }

    public final ImmutableBddConfiguration withCacheTernaryDivider(int value) {
        if (this.cacheTernaryDivider == value) {
            return this;
        }
        return new ImmutableBddConfiguration(this.cacheBinaryBinsPerHash, this.cacheBinaryDivider, this.cacheComposeDivider, this.cacheSatisfactionBinsPerHash, this.cacheSatisfactionDivider, this.cacheTernaryBinsPerHash, value, this.cacheNegationBinsPerHash, this.cacheNegationDivider, this.cacheVolatileBinsPerHash, this.cacheVolatileMultiplier, this.initialVariableNodes, this.logStatisticsOnShutdown, this.minimumCacheSize, this.minimumFreeNodePercentageAfterGc, this.growthFactor, this.useGlobalComposeCache, this.useShannonExists, this.useGarbageCollection, this.integrityDuplicatesMaximalSize, this.threadSafetyCheck);
    }

    public final ImmutableBddConfiguration withCacheNegationBinsPerHash(int value) {
        if (this.cacheNegationBinsPerHash == value) {
            return this;
        }
        return new ImmutableBddConfiguration(this.cacheBinaryBinsPerHash, this.cacheBinaryDivider, this.cacheComposeDivider, this.cacheSatisfactionBinsPerHash, this.cacheSatisfactionDivider, this.cacheTernaryBinsPerHash, this.cacheTernaryDivider, value, this.cacheNegationDivider, this.cacheVolatileBinsPerHash, this.cacheVolatileMultiplier, this.initialVariableNodes, this.logStatisticsOnShutdown, this.minimumCacheSize, this.minimumFreeNodePercentageAfterGc, this.growthFactor, this.useGlobalComposeCache, this.useShannonExists, this.useGarbageCollection, this.integrityDuplicatesMaximalSize, this.threadSafetyCheck);
    }

    public final ImmutableBddConfiguration withCacheNegationDivider(int value) {
        if (this.cacheNegationDivider == value) {
            return this;
        }
        return new ImmutableBddConfiguration(this.cacheBinaryBinsPerHash, this.cacheBinaryDivider, this.cacheComposeDivider, this.cacheSatisfactionBinsPerHash, this.cacheSatisfactionDivider, this.cacheTernaryBinsPerHash, this.cacheTernaryDivider, this.cacheNegationBinsPerHash, value, this.cacheVolatileBinsPerHash, this.cacheVolatileMultiplier, this.initialVariableNodes, this.logStatisticsOnShutdown, this.minimumCacheSize, this.minimumFreeNodePercentageAfterGc, this.growthFactor, this.useGlobalComposeCache, this.useShannonExists, this.useGarbageCollection, this.integrityDuplicatesMaximalSize, this.threadSafetyCheck);
    }

    public final ImmutableBddConfiguration withCacheVolatileBinsPerHash(int value) {
        if (this.cacheVolatileBinsPerHash == value) {
            return this;
        }
        return new ImmutableBddConfiguration(this.cacheBinaryBinsPerHash, this.cacheBinaryDivider, this.cacheComposeDivider, this.cacheSatisfactionBinsPerHash, this.cacheSatisfactionDivider, this.cacheTernaryBinsPerHash, this.cacheTernaryDivider, this.cacheNegationBinsPerHash, this.cacheNegationDivider, value, this.cacheVolatileMultiplier, this.initialVariableNodes, this.logStatisticsOnShutdown, this.minimumCacheSize, this.minimumFreeNodePercentageAfterGc, this.growthFactor, this.useGlobalComposeCache, this.useShannonExists, this.useGarbageCollection, this.integrityDuplicatesMaximalSize, this.threadSafetyCheck);
    }

    public final ImmutableBddConfiguration withCacheVolatileMultiplier(int value) {
        if (this.cacheVolatileMultiplier == value) {
            return this;
        }
        return new ImmutableBddConfiguration(this.cacheBinaryBinsPerHash, this.cacheBinaryDivider, this.cacheComposeDivider, this.cacheSatisfactionBinsPerHash, this.cacheSatisfactionDivider, this.cacheTernaryBinsPerHash, this.cacheTernaryDivider, this.cacheNegationBinsPerHash, this.cacheNegationDivider, this.cacheVolatileBinsPerHash, value, this.initialVariableNodes, this.logStatisticsOnShutdown, this.minimumCacheSize, this.minimumFreeNodePercentageAfterGc, this.growthFactor, this.useGlobalComposeCache, this.useShannonExists, this.useGarbageCollection, this.integrityDuplicatesMaximalSize, this.threadSafetyCheck);
    }

    public final ImmutableBddConfiguration withInitialVariableNodes(int value) {
        if (this.initialVariableNodes == value) {
            return this;
        }
        return new ImmutableBddConfiguration(this.cacheBinaryBinsPerHash, this.cacheBinaryDivider, this.cacheComposeDivider, this.cacheSatisfactionBinsPerHash, this.cacheSatisfactionDivider, this.cacheTernaryBinsPerHash, this.cacheTernaryDivider, this.cacheNegationBinsPerHash, this.cacheNegationDivider, this.cacheVolatileBinsPerHash, this.cacheVolatileMultiplier, value, this.logStatisticsOnShutdown, this.minimumCacheSize, this.minimumFreeNodePercentageAfterGc, this.growthFactor, this.useGlobalComposeCache, this.useShannonExists, this.useGarbageCollection, this.integrityDuplicatesMaximalSize, this.threadSafetyCheck);
    }

    public final ImmutableBddConfiguration withLogStatisticsOnShutdown(boolean value) {
        if (this.logStatisticsOnShutdown == value) {
            return this;
        }
        return new ImmutableBddConfiguration(this.cacheBinaryBinsPerHash, this.cacheBinaryDivider, this.cacheComposeDivider, this.cacheSatisfactionBinsPerHash, this.cacheSatisfactionDivider, this.cacheTernaryBinsPerHash, this.cacheTernaryDivider, this.cacheNegationBinsPerHash, this.cacheNegationDivider, this.cacheVolatileBinsPerHash, this.cacheVolatileMultiplier, this.initialVariableNodes, value, this.minimumCacheSize, this.minimumFreeNodePercentageAfterGc, this.growthFactor, this.useGlobalComposeCache, this.useShannonExists, this.useGarbageCollection, this.integrityDuplicatesMaximalSize, this.threadSafetyCheck);
    }

    public final ImmutableBddConfiguration withMinimumCacheSize(int value) {
        if (this.minimumCacheSize == value) {
            return this;
        }
        return new ImmutableBddConfiguration(this.cacheBinaryBinsPerHash, this.cacheBinaryDivider, this.cacheComposeDivider, this.cacheSatisfactionBinsPerHash, this.cacheSatisfactionDivider, this.cacheTernaryBinsPerHash, this.cacheTernaryDivider, this.cacheNegationBinsPerHash, this.cacheNegationDivider, this.cacheVolatileBinsPerHash, this.cacheVolatileMultiplier, this.initialVariableNodes, this.logStatisticsOnShutdown, value, this.minimumFreeNodePercentageAfterGc, this.growthFactor, this.useGlobalComposeCache, this.useShannonExists, this.useGarbageCollection, this.integrityDuplicatesMaximalSize, this.threadSafetyCheck);
    }

    public final ImmutableBddConfiguration withMinimumFreeNodePercentageAfterGc(double value) {
        if (Double.doubleToLongBits(this.minimumFreeNodePercentageAfterGc) == Double.doubleToLongBits(value)) {
            return this;
        }
        return new ImmutableBddConfiguration(this.cacheBinaryBinsPerHash, this.cacheBinaryDivider, this.cacheComposeDivider, this.cacheSatisfactionBinsPerHash, this.cacheSatisfactionDivider, this.cacheTernaryBinsPerHash, this.cacheTernaryDivider, this.cacheNegationBinsPerHash, this.cacheNegationDivider, this.cacheVolatileBinsPerHash, this.cacheVolatileMultiplier, this.initialVariableNodes, this.logStatisticsOnShutdown, this.minimumCacheSize, value, this.growthFactor, this.useGlobalComposeCache, this.useShannonExists, this.useGarbageCollection, this.integrityDuplicatesMaximalSize, this.threadSafetyCheck);
    }

    public final ImmutableBddConfiguration withGrowthFactor(double value) {
        if (Double.doubleToLongBits(this.growthFactor) == Double.doubleToLongBits(value)) {
            return this;
        }
        return new ImmutableBddConfiguration(this.cacheBinaryBinsPerHash, this.cacheBinaryDivider, this.cacheComposeDivider, this.cacheSatisfactionBinsPerHash, this.cacheSatisfactionDivider, this.cacheTernaryBinsPerHash, this.cacheTernaryDivider, this.cacheNegationBinsPerHash, this.cacheNegationDivider, this.cacheVolatileBinsPerHash, this.cacheVolatileMultiplier, this.initialVariableNodes, this.logStatisticsOnShutdown, this.minimumCacheSize, this.minimumFreeNodePercentageAfterGc, value, this.useGlobalComposeCache, this.useShannonExists, this.useGarbageCollection, this.integrityDuplicatesMaximalSize, this.threadSafetyCheck);
    }

    public final ImmutableBddConfiguration withUseGlobalComposeCache(boolean value) {
        if (this.useGlobalComposeCache == value) {
            return this;
        }
        return new ImmutableBddConfiguration(this.cacheBinaryBinsPerHash, this.cacheBinaryDivider, this.cacheComposeDivider, this.cacheSatisfactionBinsPerHash, this.cacheSatisfactionDivider, this.cacheTernaryBinsPerHash, this.cacheTernaryDivider, this.cacheNegationBinsPerHash, this.cacheNegationDivider, this.cacheVolatileBinsPerHash, this.cacheVolatileMultiplier, this.initialVariableNodes, this.logStatisticsOnShutdown, this.minimumCacheSize, this.minimumFreeNodePercentageAfterGc, this.growthFactor, value, this.useShannonExists, this.useGarbageCollection, this.integrityDuplicatesMaximalSize, this.threadSafetyCheck);
    }

    public final ImmutableBddConfiguration withUseShannonExists(boolean value) {
        if (this.useShannonExists == value) {
            return this;
        }
        return new ImmutableBddConfiguration(this.cacheBinaryBinsPerHash, this.cacheBinaryDivider, this.cacheComposeDivider, this.cacheSatisfactionBinsPerHash, this.cacheSatisfactionDivider, this.cacheTernaryBinsPerHash, this.cacheTernaryDivider, this.cacheNegationBinsPerHash, this.cacheNegationDivider, this.cacheVolatileBinsPerHash, this.cacheVolatileMultiplier, this.initialVariableNodes, this.logStatisticsOnShutdown, this.minimumCacheSize, this.minimumFreeNodePercentageAfterGc, this.growthFactor, this.useGlobalComposeCache, value, this.useGarbageCollection, this.integrityDuplicatesMaximalSize, this.threadSafetyCheck);
    }

    public final ImmutableBddConfiguration withUseGarbageCollection(boolean value) {
        if (this.useGarbageCollection == value) {
            return this;
        }
        return new ImmutableBddConfiguration(this.cacheBinaryBinsPerHash, this.cacheBinaryDivider, this.cacheComposeDivider, this.cacheSatisfactionBinsPerHash, this.cacheSatisfactionDivider, this.cacheTernaryBinsPerHash, this.cacheTernaryDivider, this.cacheNegationBinsPerHash, this.cacheNegationDivider, this.cacheVolatileBinsPerHash, this.cacheVolatileMultiplier, this.initialVariableNodes, this.logStatisticsOnShutdown, this.minimumCacheSize, this.minimumFreeNodePercentageAfterGc, this.growthFactor, this.useGlobalComposeCache, this.useShannonExists, value, this.integrityDuplicatesMaximalSize, this.threadSafetyCheck);
    }

    public final ImmutableBddConfiguration withIntegrityDuplicatesMaximalSize(int value) {
        if (this.integrityDuplicatesMaximalSize == value) {
            return this;
        }
        return new ImmutableBddConfiguration(this.cacheBinaryBinsPerHash, this.cacheBinaryDivider, this.cacheComposeDivider, this.cacheSatisfactionBinsPerHash, this.cacheSatisfactionDivider, this.cacheTernaryBinsPerHash, this.cacheTernaryDivider, this.cacheNegationBinsPerHash, this.cacheNegationDivider, this.cacheVolatileBinsPerHash, this.cacheVolatileMultiplier, this.initialVariableNodes, this.logStatisticsOnShutdown, this.minimumCacheSize, this.minimumFreeNodePercentageAfterGc, this.growthFactor, this.useGlobalComposeCache, this.useShannonExists, this.useGarbageCollection, value, this.threadSafetyCheck);
    }

    public final ImmutableBddConfiguration withThreadSafetyCheck(boolean value) {
        if (this.threadSafetyCheck == value) {
            return this;
        }
        return new ImmutableBddConfiguration(this.cacheBinaryBinsPerHash, this.cacheBinaryDivider, this.cacheComposeDivider, this.cacheSatisfactionBinsPerHash, this.cacheSatisfactionDivider, this.cacheTernaryBinsPerHash, this.cacheTernaryDivider, this.cacheNegationBinsPerHash, this.cacheNegationDivider, this.cacheVolatileBinsPerHash, this.cacheVolatileMultiplier, this.initialVariableNodes, this.logStatisticsOnShutdown, this.minimumCacheSize, this.minimumFreeNodePercentageAfterGc, this.growthFactor, this.useGlobalComposeCache, this.useShannonExists, this.useGarbageCollection, this.integrityDuplicatesMaximalSize, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableBddConfiguration && this.equalTo((ImmutableBddConfiguration)another);
    }

    private boolean equalTo(ImmutableBddConfiguration another) {
        return this.cacheBinaryBinsPerHash == another.cacheBinaryBinsPerHash && this.cacheBinaryDivider == another.cacheBinaryDivider && this.cacheComposeDivider == another.cacheComposeDivider && this.cacheSatisfactionBinsPerHash == another.cacheSatisfactionBinsPerHash && this.cacheSatisfactionDivider == another.cacheSatisfactionDivider && this.cacheTernaryBinsPerHash == another.cacheTernaryBinsPerHash && this.cacheTernaryDivider == another.cacheTernaryDivider && this.cacheNegationBinsPerHash == another.cacheNegationBinsPerHash && this.cacheNegationDivider == another.cacheNegationDivider && this.cacheVolatileBinsPerHash == another.cacheVolatileBinsPerHash && this.cacheVolatileMultiplier == another.cacheVolatileMultiplier && this.initialVariableNodes == another.initialVariableNodes && this.logStatisticsOnShutdown == another.logStatisticsOnShutdown && this.minimumCacheSize == another.minimumCacheSize && Double.doubleToLongBits(this.minimumFreeNodePercentageAfterGc) == Double.doubleToLongBits(another.minimumFreeNodePercentageAfterGc) && Double.doubleToLongBits(this.growthFactor) == Double.doubleToLongBits(another.growthFactor) && this.useGlobalComposeCache == another.useGlobalComposeCache && this.useShannonExists == another.useShannonExists && this.useGarbageCollection == another.useGarbageCollection && this.integrityDuplicatesMaximalSize == another.integrityDuplicatesMaximalSize && this.threadSafetyCheck == another.threadSafetyCheck;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.cacheBinaryBinsPerHash;
        h += (h << 5) + this.cacheBinaryDivider;
        h += (h << 5) + this.cacheComposeDivider;
        h += (h << 5) + this.cacheSatisfactionBinsPerHash;
        h += (h << 5) + this.cacheSatisfactionDivider;
        h += (h << 5) + this.cacheTernaryBinsPerHash;
        h += (h << 5) + this.cacheTernaryDivider;
        h += (h << 5) + this.cacheNegationBinsPerHash;
        h += (h << 5) + this.cacheNegationDivider;
        h += (h << 5) + this.cacheVolatileBinsPerHash;
        h += (h << 5) + this.cacheVolatileMultiplier;
        h += (h << 5) + this.initialVariableNodes;
        h += (h << 5) + Boolean.hashCode(this.logStatisticsOnShutdown);
        h += (h << 5) + this.minimumCacheSize;
        h += (h << 5) + Double.hashCode(this.minimumFreeNodePercentageAfterGc);
        h += (h << 5) + Double.hashCode(this.growthFactor);
        h += (h << 5) + Boolean.hashCode(this.useGlobalComposeCache);
        h += (h << 5) + Boolean.hashCode(this.useShannonExists);
        h += (h << 5) + Boolean.hashCode(this.useGarbageCollection);
        h += (h << 5) + this.integrityDuplicatesMaximalSize;
        h += (h << 5) + Boolean.hashCode(this.threadSafetyCheck);
        return h;
    }

    public String toString() {
        return "BddConfiguration{cacheBinaryBinsPerHash=" + this.cacheBinaryBinsPerHash + ", cacheBinaryDivider=" + this.cacheBinaryDivider + ", cacheComposeDivider=" + this.cacheComposeDivider + ", cacheSatisfactionBinsPerHash=" + this.cacheSatisfactionBinsPerHash + ", cacheSatisfactionDivider=" + this.cacheSatisfactionDivider + ", cacheTernaryBinsPerHash=" + this.cacheTernaryBinsPerHash + ", cacheTernaryDivider=" + this.cacheTernaryDivider + ", cacheNegationBinsPerHash=" + this.cacheNegationBinsPerHash + ", cacheNegationDivider=" + this.cacheNegationDivider + ", cacheVolatileBinsPerHash=" + this.cacheVolatileBinsPerHash + ", cacheVolatileMultiplier=" + this.cacheVolatileMultiplier + ", initialVariableNodes=" + this.initialVariableNodes + ", logStatisticsOnShutdown=" + this.logStatisticsOnShutdown + ", minimumCacheSize=" + this.minimumCacheSize + ", minimumFreeNodePercentageAfterGc=" + this.minimumFreeNodePercentageAfterGc + ", growthFactor=" + this.growthFactor + ", useGlobalComposeCache=" + this.useGlobalComposeCache + ", useShannonExists=" + this.useShannonExists + ", useGarbageCollection=" + this.useGarbageCollection + ", integrityDuplicatesMaximalSize=" + this.integrityDuplicatesMaximalSize + ", threadSafetyCheck=" + this.threadSafetyCheck + "}";
    }

    public static ImmutableBddConfiguration copyOf(BddConfiguration instance) {
        if (instance instanceof ImmutableBddConfiguration) {
            return (ImmutableBddConfiguration)instance;
        }
        return ImmutableBddConfiguration.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="BddConfiguration", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long OPT_BIT_CACHE_BINARY_BINS_PER_HASH = 1L;
        private static final long OPT_BIT_CACHE_BINARY_DIVIDER = 2L;
        private static final long OPT_BIT_CACHE_COMPOSE_DIVIDER = 4L;
        private static final long OPT_BIT_CACHE_SATISFACTION_BINS_PER_HASH = 8L;
        private static final long OPT_BIT_CACHE_SATISFACTION_DIVIDER = 16L;
        private static final long OPT_BIT_CACHE_TERNARY_BINS_PER_HASH = 32L;
        private static final long OPT_BIT_CACHE_TERNARY_DIVIDER = 64L;
        private static final long OPT_BIT_CACHE_NEGATION_BINS_PER_HASH = 128L;
        private static final long OPT_BIT_CACHE_NEGATION_DIVIDER = 256L;
        private static final long OPT_BIT_CACHE_VOLATILE_BINS_PER_HASH = 512L;
        private static final long OPT_BIT_CACHE_VOLATILE_MULTIPLIER = 1024L;
        private static final long OPT_BIT_INITIAL_VARIABLE_NODES = 2048L;
        private static final long OPT_BIT_LOG_STATISTICS_ON_SHUTDOWN = 4096L;
        private static final long OPT_BIT_MINIMUM_CACHE_SIZE = 8192L;
        private static final long OPT_BIT_MINIMUM_FREE_NODE_PERCENTAGE_AFTER_GC = 16384L;
        private static final long OPT_BIT_GROWTH_FACTOR = 32768L;
        private static final long OPT_BIT_USE_GLOBAL_COMPOSE_CACHE = 65536L;
        private static final long OPT_BIT_USE_SHANNON_EXISTS = 131072L;
        private static final long OPT_BIT_USE_GARBAGE_COLLECTION = 262144L;
        private static final long OPT_BIT_INTEGRITY_DUPLICATES_MAXIMAL_SIZE = 524288L;
        private static final long OPT_BIT_THREAD_SAFETY_CHECK = 0x100000L;
        private long optBits;
        private int cacheBinaryBinsPerHash;
        private int cacheBinaryDivider;
        private int cacheComposeDivider;
        private int cacheSatisfactionBinsPerHash;
        private int cacheSatisfactionDivider;
        private int cacheTernaryBinsPerHash;
        private int cacheTernaryDivider;
        private int cacheNegationBinsPerHash;
        private int cacheNegationDivider;
        private int cacheVolatileBinsPerHash;
        private int cacheVolatileMultiplier;
        private int initialVariableNodes;
        private boolean logStatisticsOnShutdown;
        private int minimumCacheSize;
        private double minimumFreeNodePercentageAfterGc;
        private double growthFactor;
        private boolean useGlobalComposeCache;
        private boolean useShannonExists;
        private boolean useGarbageCollection;
        private int integrityDuplicatesMaximalSize;
        private boolean threadSafetyCheck;

        private Builder() {
        }

        public final Builder from(BddConfiguration instance) {
            Objects.requireNonNull(instance, "instance");
            this.cacheBinaryBinsPerHash(instance.cacheBinaryBinsPerHash());
            this.cacheBinaryDivider(instance.cacheBinaryDivider());
            this.cacheComposeDivider(instance.cacheComposeDivider());
            this.cacheSatisfactionBinsPerHash(instance.cacheSatisfactionBinsPerHash());
            this.cacheSatisfactionDivider(instance.cacheSatisfactionDivider());
            this.cacheTernaryBinsPerHash(instance.cacheTernaryBinsPerHash());
            this.cacheTernaryDivider(instance.cacheTernaryDivider());
            this.cacheNegationBinsPerHash(instance.cacheNegationBinsPerHash());
            this.cacheNegationDivider(instance.cacheNegationDivider());
            this.cacheVolatileBinsPerHash(instance.cacheVolatileBinsPerHash());
            this.cacheVolatileMultiplier(instance.cacheVolatileMultiplier());
            this.initialVariableNodes(instance.initialVariableNodes());
            this.logStatisticsOnShutdown(instance.logStatisticsOnShutdown());
            this.minimumCacheSize(instance.minimumCacheSize());
            this.minimumFreeNodePercentageAfterGc(instance.minimumFreeNodePercentageAfterGc());
            this.growthFactor(instance.growthFactor());
            this.useGlobalComposeCache(instance.useGlobalComposeCache());
            this.useShannonExists(instance.useShannonExists());
            this.useGarbageCollection(instance.useGarbageCollection());
            this.integrityDuplicatesMaximalSize(instance.integrityDuplicatesMaximalSize());
            this.threadSafetyCheck(instance.threadSafetyCheck());
            return this;
        }

        public final Builder cacheBinaryBinsPerHash(int cacheBinaryBinsPerHash) {
            this.cacheBinaryBinsPerHash = cacheBinaryBinsPerHash;
            this.optBits |= 1L;
            return this;
        }

        public final Builder cacheBinaryDivider(int cacheBinaryDivider) {
            this.cacheBinaryDivider = cacheBinaryDivider;
            this.optBits |= 2L;
            return this;
        }

        public final Builder cacheComposeDivider(int cacheComposeDivider) {
            this.cacheComposeDivider = cacheComposeDivider;
            this.optBits |= 4L;
            return this;
        }

        public final Builder cacheSatisfactionBinsPerHash(int cacheSatisfactionBinsPerHash) {
            this.cacheSatisfactionBinsPerHash = cacheSatisfactionBinsPerHash;
            this.optBits |= 8L;
            return this;
        }

        public final Builder cacheSatisfactionDivider(int cacheSatisfactionDivider) {
            this.cacheSatisfactionDivider = cacheSatisfactionDivider;
            this.optBits |= 0x10L;
            return this;
        }

        public final Builder cacheTernaryBinsPerHash(int cacheTernaryBinsPerHash) {
            this.cacheTernaryBinsPerHash = cacheTernaryBinsPerHash;
            this.optBits |= 0x20L;
            return this;
        }

        public final Builder cacheTernaryDivider(int cacheTernaryDivider) {
            this.cacheTernaryDivider = cacheTernaryDivider;
            this.optBits |= 0x40L;
            return this;
        }

        public final Builder cacheNegationBinsPerHash(int cacheNegationBinsPerHash) {
            this.cacheNegationBinsPerHash = cacheNegationBinsPerHash;
            this.optBits |= 0x80L;
            return this;
        }

        public final Builder cacheNegationDivider(int cacheNegationDivider) {
            this.cacheNegationDivider = cacheNegationDivider;
            this.optBits |= 0x100L;
            return this;
        }

        public final Builder cacheVolatileBinsPerHash(int cacheVolatileBinsPerHash) {
            this.cacheVolatileBinsPerHash = cacheVolatileBinsPerHash;
            this.optBits |= 0x200L;
            return this;
        }

        public final Builder cacheVolatileMultiplier(int cacheVolatileMultiplier) {
            this.cacheVolatileMultiplier = cacheVolatileMultiplier;
            this.optBits |= 0x400L;
            return this;
        }

        public final Builder initialVariableNodes(int initialVariableNodes) {
            this.initialVariableNodes = initialVariableNodes;
            this.optBits |= 0x800L;
            return this;
        }

        public final Builder logStatisticsOnShutdown(boolean logStatisticsOnShutdown) {
            this.logStatisticsOnShutdown = logStatisticsOnShutdown;
            this.optBits |= 0x1000L;
            return this;
        }

        public final Builder minimumCacheSize(int minimumCacheSize) {
            this.minimumCacheSize = minimumCacheSize;
            this.optBits |= 0x2000L;
            return this;
        }

        public final Builder minimumFreeNodePercentageAfterGc(double minimumFreeNodePercentageAfterGc) {
            this.minimumFreeNodePercentageAfterGc = minimumFreeNodePercentageAfterGc;
            this.optBits |= 0x4000L;
            return this;
        }

        public final Builder growthFactor(double growthFactor) {
            this.growthFactor = growthFactor;
            this.optBits |= 0x8000L;
            return this;
        }

        public final Builder useGlobalComposeCache(boolean useGlobalComposeCache) {
            this.useGlobalComposeCache = useGlobalComposeCache;
            this.optBits |= 0x10000L;
            return this;
        }

        public final Builder useShannonExists(boolean useShannonExists) {
            this.useShannonExists = useShannonExists;
            this.optBits |= 0x20000L;
            return this;
        }

        public final Builder useGarbageCollection(boolean useGarbageCollection) {
            this.useGarbageCollection = useGarbageCollection;
            this.optBits |= 0x40000L;
            return this;
        }

        public final Builder integrityDuplicatesMaximalSize(int integrityDuplicatesMaximalSize) {
            this.integrityDuplicatesMaximalSize = integrityDuplicatesMaximalSize;
            this.optBits |= 0x80000L;
            return this;
        }

        public final Builder threadSafetyCheck(boolean threadSafetyCheck) {
            this.threadSafetyCheck = threadSafetyCheck;
            this.optBits |= 0x100000L;
            return this;
        }

        public ImmutableBddConfiguration build() {
            return new ImmutableBddConfiguration(this);
        }

        private boolean cacheBinaryBinsPerHashIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean cacheBinaryDividerIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private boolean cacheComposeDividerIsSet() {
            return (this.optBits & 4L) != 0L;
        }

        private boolean cacheSatisfactionBinsPerHashIsSet() {
            return (this.optBits & 8L) != 0L;
        }

        private boolean cacheSatisfactionDividerIsSet() {
            return (this.optBits & 0x10L) != 0L;
        }

        private boolean cacheTernaryBinsPerHashIsSet() {
            return (this.optBits & 0x20L) != 0L;
        }

        private boolean cacheTernaryDividerIsSet() {
            return (this.optBits & 0x40L) != 0L;
        }

        private boolean cacheNegationBinsPerHashIsSet() {
            return (this.optBits & 0x80L) != 0L;
        }

        private boolean cacheNegationDividerIsSet() {
            return (this.optBits & 0x100L) != 0L;
        }

        private boolean cacheVolatileBinsPerHashIsSet() {
            return (this.optBits & 0x200L) != 0L;
        }

        private boolean cacheVolatileMultiplierIsSet() {
            return (this.optBits & 0x400L) != 0L;
        }

        private boolean initialVariableNodesIsSet() {
            return (this.optBits & 0x800L) != 0L;
        }

        private boolean logStatisticsOnShutdownIsSet() {
            return (this.optBits & 0x1000L) != 0L;
        }

        private boolean minimumCacheSizeIsSet() {
            return (this.optBits & 0x2000L) != 0L;
        }

        private boolean minimumFreeNodePercentageAfterGcIsSet() {
            return (this.optBits & 0x4000L) != 0L;
        }

        private boolean growthFactorIsSet() {
            return (this.optBits & 0x8000L) != 0L;
        }

        private boolean useGlobalComposeCacheIsSet() {
            return (this.optBits & 0x10000L) != 0L;
        }

        private boolean useShannonExistsIsSet() {
            return (this.optBits & 0x20000L) != 0L;
        }

        private boolean useGarbageCollectionIsSet() {
            return (this.optBits & 0x40000L) != 0L;
        }

        private boolean integrityDuplicatesMaximalSizeIsSet() {
            return (this.optBits & 0x80000L) != 0L;
        }

        private boolean threadSafetyCheckIsSet() {
            return (this.optBits & 0x100000L) != 0L;
        }
    }

    private final class InitShim {
        private byte cacheBinaryBinsPerHashBuildStage = 0;
        private int cacheBinaryBinsPerHash;
        private byte cacheBinaryDividerBuildStage = 0;
        private int cacheBinaryDivider;
        private byte cacheComposeDividerBuildStage = 0;
        private int cacheComposeDivider;
        private byte cacheSatisfactionBinsPerHashBuildStage = 0;
        private int cacheSatisfactionBinsPerHash;
        private byte cacheSatisfactionDividerBuildStage = 0;
        private int cacheSatisfactionDivider;
        private byte cacheTernaryBinsPerHashBuildStage = 0;
        private int cacheTernaryBinsPerHash;
        private byte cacheTernaryDividerBuildStage = 0;
        private int cacheTernaryDivider;
        private byte cacheNegationBinsPerHashBuildStage = 0;
        private int cacheNegationBinsPerHash;
        private byte cacheNegationDividerBuildStage = 0;
        private int cacheNegationDivider;
        private byte cacheVolatileBinsPerHashBuildStage = 0;
        private int cacheVolatileBinsPerHash;
        private byte cacheVolatileMultiplierBuildStage = 0;
        private int cacheVolatileMultiplier;
        private byte initialVariableNodesBuildStage = 0;
        private int initialVariableNodes;
        private byte logStatisticsOnShutdownBuildStage = 0;
        private boolean logStatisticsOnShutdown;
        private byte minimumCacheSizeBuildStage = 0;
        private int minimumCacheSize;
        private byte minimumFreeNodePercentageAfterGcBuildStage = 0;
        private double minimumFreeNodePercentageAfterGc;
        private byte growthFactorBuildStage = 0;
        private double growthFactor;
        private byte useGlobalComposeCacheBuildStage = 0;
        private boolean useGlobalComposeCache;
        private byte useShannonExistsBuildStage = 0;
        private boolean useShannonExists;
        private byte useGarbageCollectionBuildStage = 0;
        private boolean useGarbageCollection;
        private byte integrityDuplicatesMaximalSizeBuildStage = 0;
        private int integrityDuplicatesMaximalSize;
        private byte threadSafetyCheckBuildStage = 0;
        private boolean threadSafetyCheck;

        private InitShim() {
        }

        int cacheBinaryBinsPerHash() {
            if (this.cacheBinaryBinsPerHashBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.cacheBinaryBinsPerHashBuildStage == 0) {
                this.cacheBinaryBinsPerHashBuildStage = (byte)-1;
                this.cacheBinaryBinsPerHash = ImmutableBddConfiguration.super.cacheBinaryBinsPerHash();
                this.cacheBinaryBinsPerHashBuildStage = 1;
            }
            return this.cacheBinaryBinsPerHash;
        }

        void cacheBinaryBinsPerHash(int cacheBinaryBinsPerHash) {
            this.cacheBinaryBinsPerHash = cacheBinaryBinsPerHash;
            this.cacheBinaryBinsPerHashBuildStage = 1;
        }

        int cacheBinaryDivider() {
            if (this.cacheBinaryDividerBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.cacheBinaryDividerBuildStage == 0) {
                this.cacheBinaryDividerBuildStage = (byte)-1;
                this.cacheBinaryDivider = ImmutableBddConfiguration.super.cacheBinaryDivider();
                this.cacheBinaryDividerBuildStage = 1;
            }
            return this.cacheBinaryDivider;
        }

        void cacheBinaryDivider(int cacheBinaryDivider) {
            this.cacheBinaryDivider = cacheBinaryDivider;
            this.cacheBinaryDividerBuildStage = 1;
        }

        int cacheComposeDivider() {
            if (this.cacheComposeDividerBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.cacheComposeDividerBuildStage == 0) {
                this.cacheComposeDividerBuildStage = (byte)-1;
                this.cacheComposeDivider = ImmutableBddConfiguration.super.cacheComposeDivider();
                this.cacheComposeDividerBuildStage = 1;
            }
            return this.cacheComposeDivider;
        }

        void cacheComposeDivider(int cacheComposeDivider) {
            this.cacheComposeDivider = cacheComposeDivider;
            this.cacheComposeDividerBuildStage = 1;
        }

        int cacheSatisfactionBinsPerHash() {
            if (this.cacheSatisfactionBinsPerHashBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.cacheSatisfactionBinsPerHashBuildStage == 0) {
                this.cacheSatisfactionBinsPerHashBuildStage = (byte)-1;
                this.cacheSatisfactionBinsPerHash = ImmutableBddConfiguration.super.cacheSatisfactionBinsPerHash();
                this.cacheSatisfactionBinsPerHashBuildStage = 1;
            }
            return this.cacheSatisfactionBinsPerHash;
        }

        void cacheSatisfactionBinsPerHash(int cacheSatisfactionBinsPerHash) {
            this.cacheSatisfactionBinsPerHash = cacheSatisfactionBinsPerHash;
            this.cacheSatisfactionBinsPerHashBuildStage = 1;
        }

        int cacheSatisfactionDivider() {
            if (this.cacheSatisfactionDividerBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.cacheSatisfactionDividerBuildStage == 0) {
                this.cacheSatisfactionDividerBuildStage = (byte)-1;
                this.cacheSatisfactionDivider = ImmutableBddConfiguration.super.cacheSatisfactionDivider();
                this.cacheSatisfactionDividerBuildStage = 1;
            }
            return this.cacheSatisfactionDivider;
        }

        void cacheSatisfactionDivider(int cacheSatisfactionDivider) {
            this.cacheSatisfactionDivider = cacheSatisfactionDivider;
            this.cacheSatisfactionDividerBuildStage = 1;
        }

        int cacheTernaryBinsPerHash() {
            if (this.cacheTernaryBinsPerHashBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.cacheTernaryBinsPerHashBuildStage == 0) {
                this.cacheTernaryBinsPerHashBuildStage = (byte)-1;
                this.cacheTernaryBinsPerHash = ImmutableBddConfiguration.super.cacheTernaryBinsPerHash();
                this.cacheTernaryBinsPerHashBuildStage = 1;
            }
            return this.cacheTernaryBinsPerHash;
        }

        void cacheTernaryBinsPerHash(int cacheTernaryBinsPerHash) {
            this.cacheTernaryBinsPerHash = cacheTernaryBinsPerHash;
            this.cacheTernaryBinsPerHashBuildStage = 1;
        }

        int cacheTernaryDivider() {
            if (this.cacheTernaryDividerBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.cacheTernaryDividerBuildStage == 0) {
                this.cacheTernaryDividerBuildStage = (byte)-1;
                this.cacheTernaryDivider = ImmutableBddConfiguration.super.cacheTernaryDivider();
                this.cacheTernaryDividerBuildStage = 1;
            }
            return this.cacheTernaryDivider;
        }

        void cacheTernaryDivider(int cacheTernaryDivider) {
            this.cacheTernaryDivider = cacheTernaryDivider;
            this.cacheTernaryDividerBuildStage = 1;
        }

        int cacheNegationBinsPerHash() {
            if (this.cacheNegationBinsPerHashBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.cacheNegationBinsPerHashBuildStage == 0) {
                this.cacheNegationBinsPerHashBuildStage = (byte)-1;
                this.cacheNegationBinsPerHash = ImmutableBddConfiguration.super.cacheNegationBinsPerHash();
                this.cacheNegationBinsPerHashBuildStage = 1;
            }
            return this.cacheNegationBinsPerHash;
        }

        void cacheNegationBinsPerHash(int cacheNegationBinsPerHash) {
            this.cacheNegationBinsPerHash = cacheNegationBinsPerHash;
            this.cacheNegationBinsPerHashBuildStage = 1;
        }

        int cacheNegationDivider() {
            if (this.cacheNegationDividerBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.cacheNegationDividerBuildStage == 0) {
                this.cacheNegationDividerBuildStage = (byte)-1;
                this.cacheNegationDivider = ImmutableBddConfiguration.super.cacheNegationDivider();
                this.cacheNegationDividerBuildStage = 1;
            }
            return this.cacheNegationDivider;
        }

        void cacheNegationDivider(int cacheNegationDivider) {
            this.cacheNegationDivider = cacheNegationDivider;
            this.cacheNegationDividerBuildStage = 1;
        }

        int cacheVolatileBinsPerHash() {
            if (this.cacheVolatileBinsPerHashBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.cacheVolatileBinsPerHashBuildStage == 0) {
                this.cacheVolatileBinsPerHashBuildStage = (byte)-1;
                this.cacheVolatileBinsPerHash = ImmutableBddConfiguration.super.cacheVolatileBinsPerHash();
                this.cacheVolatileBinsPerHashBuildStage = 1;
            }
            return this.cacheVolatileBinsPerHash;
        }

        void cacheVolatileBinsPerHash(int cacheVolatileBinsPerHash) {
            this.cacheVolatileBinsPerHash = cacheVolatileBinsPerHash;
            this.cacheVolatileBinsPerHashBuildStage = 1;
        }

        int cacheVolatileMultiplier() {
            if (this.cacheVolatileMultiplierBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.cacheVolatileMultiplierBuildStage == 0) {
                this.cacheVolatileMultiplierBuildStage = (byte)-1;
                this.cacheVolatileMultiplier = ImmutableBddConfiguration.super.cacheVolatileMultiplier();
                this.cacheVolatileMultiplierBuildStage = 1;
            }
            return this.cacheVolatileMultiplier;
        }

        void cacheVolatileMultiplier(int cacheVolatileMultiplier) {
            this.cacheVolatileMultiplier = cacheVolatileMultiplier;
            this.cacheVolatileMultiplierBuildStage = 1;
        }

        int initialVariableNodes() {
            if (this.initialVariableNodesBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.initialVariableNodesBuildStage == 0) {
                this.initialVariableNodesBuildStage = (byte)-1;
                this.initialVariableNodes = ImmutableBddConfiguration.super.initialVariableNodes();
                this.initialVariableNodesBuildStage = 1;
            }
            return this.initialVariableNodes;
        }

        void initialVariableNodes(int initialVariableNodes) {
            this.initialVariableNodes = initialVariableNodes;
            this.initialVariableNodesBuildStage = 1;
        }

        boolean logStatisticsOnShutdown() {
            if (this.logStatisticsOnShutdownBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.logStatisticsOnShutdownBuildStage == 0) {
                this.logStatisticsOnShutdownBuildStage = (byte)-1;
                this.logStatisticsOnShutdown = ImmutableBddConfiguration.super.logStatisticsOnShutdown();
                this.logStatisticsOnShutdownBuildStage = 1;
            }
            return this.logStatisticsOnShutdown;
        }

        void logStatisticsOnShutdown(boolean logStatisticsOnShutdown) {
            this.logStatisticsOnShutdown = logStatisticsOnShutdown;
            this.logStatisticsOnShutdownBuildStage = 1;
        }

        int minimumCacheSize() {
            if (this.minimumCacheSizeBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.minimumCacheSizeBuildStage == 0) {
                this.minimumCacheSizeBuildStage = (byte)-1;
                this.minimumCacheSize = ImmutableBddConfiguration.super.minimumCacheSize();
                this.minimumCacheSizeBuildStage = 1;
            }
            return this.minimumCacheSize;
        }

        void minimumCacheSize(int minimumCacheSize) {
            this.minimumCacheSize = minimumCacheSize;
            this.minimumCacheSizeBuildStage = 1;
        }

        double minimumFreeNodePercentageAfterGc() {
            if (this.minimumFreeNodePercentageAfterGcBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.minimumFreeNodePercentageAfterGcBuildStage == 0) {
                this.minimumFreeNodePercentageAfterGcBuildStage = (byte)-1;
                this.minimumFreeNodePercentageAfterGc = ImmutableBddConfiguration.super.minimumFreeNodePercentageAfterGc();
                this.minimumFreeNodePercentageAfterGcBuildStage = 1;
            }
            return this.minimumFreeNodePercentageAfterGc;
        }

        void minimumFreeNodePercentageAfterGc(double minimumFreeNodePercentageAfterGc) {
            this.minimumFreeNodePercentageAfterGc = minimumFreeNodePercentageAfterGc;
            this.minimumFreeNodePercentageAfterGcBuildStage = 1;
        }

        double growthFactor() {
            if (this.growthFactorBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.growthFactorBuildStage == 0) {
                this.growthFactorBuildStage = (byte)-1;
                this.growthFactor = ImmutableBddConfiguration.super.growthFactor();
                this.growthFactorBuildStage = 1;
            }
            return this.growthFactor;
        }

        void growthFactor(double growthFactor) {
            this.growthFactor = growthFactor;
            this.growthFactorBuildStage = 1;
        }

        boolean useGlobalComposeCache() {
            if (this.useGlobalComposeCacheBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.useGlobalComposeCacheBuildStage == 0) {
                this.useGlobalComposeCacheBuildStage = (byte)-1;
                this.useGlobalComposeCache = ImmutableBddConfiguration.super.useGlobalComposeCache();
                this.useGlobalComposeCacheBuildStage = 1;
            }
            return this.useGlobalComposeCache;
        }

        void useGlobalComposeCache(boolean useGlobalComposeCache) {
            this.useGlobalComposeCache = useGlobalComposeCache;
            this.useGlobalComposeCacheBuildStage = 1;
        }

        boolean useShannonExists() {
            if (this.useShannonExistsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.useShannonExistsBuildStage == 0) {
                this.useShannonExistsBuildStage = (byte)-1;
                this.useShannonExists = ImmutableBddConfiguration.super.useShannonExists();
                this.useShannonExistsBuildStage = 1;
            }
            return this.useShannonExists;
        }

        void useShannonExists(boolean useShannonExists) {
            this.useShannonExists = useShannonExists;
            this.useShannonExistsBuildStage = 1;
        }

        boolean useGarbageCollection() {
            if (this.useGarbageCollectionBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.useGarbageCollectionBuildStage == 0) {
                this.useGarbageCollectionBuildStage = (byte)-1;
                this.useGarbageCollection = ImmutableBddConfiguration.super.useGarbageCollection();
                this.useGarbageCollectionBuildStage = 1;
            }
            return this.useGarbageCollection;
        }

        void useGarbageCollection(boolean useGarbageCollection) {
            this.useGarbageCollection = useGarbageCollection;
            this.useGarbageCollectionBuildStage = 1;
        }

        int integrityDuplicatesMaximalSize() {
            if (this.integrityDuplicatesMaximalSizeBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.integrityDuplicatesMaximalSizeBuildStage == 0) {
                this.integrityDuplicatesMaximalSizeBuildStage = (byte)-1;
                this.integrityDuplicatesMaximalSize = ImmutableBddConfiguration.super.integrityDuplicatesMaximalSize();
                this.integrityDuplicatesMaximalSizeBuildStage = 1;
            }
            return this.integrityDuplicatesMaximalSize;
        }

        void integrityDuplicatesMaximalSize(int integrityDuplicatesMaximalSize) {
            this.integrityDuplicatesMaximalSize = integrityDuplicatesMaximalSize;
            this.integrityDuplicatesMaximalSizeBuildStage = 1;
        }

        boolean threadSafetyCheck() {
            if (this.threadSafetyCheckBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.threadSafetyCheckBuildStage == 0) {
                this.threadSafetyCheckBuildStage = (byte)-1;
                this.threadSafetyCheck = ImmutableBddConfiguration.super.threadSafetyCheck();
                this.threadSafetyCheckBuildStage = 1;
            }
            return this.threadSafetyCheck;
        }

        void threadSafetyCheck(boolean threadSafetyCheck) {
            this.threadSafetyCheck = threadSafetyCheck;
            this.threadSafetyCheckBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.cacheBinaryBinsPerHashBuildStage == -1) {
                attributes.add("cacheBinaryBinsPerHash");
            }
            if (this.cacheBinaryDividerBuildStage == -1) {
                attributes.add("cacheBinaryDivider");
            }
            if (this.cacheComposeDividerBuildStage == -1) {
                attributes.add("cacheComposeDivider");
            }
            if (this.cacheSatisfactionBinsPerHashBuildStage == -1) {
                attributes.add("cacheSatisfactionBinsPerHash");
            }
            if (this.cacheSatisfactionDividerBuildStage == -1) {
                attributes.add("cacheSatisfactionDivider");
            }
            if (this.cacheTernaryBinsPerHashBuildStage == -1) {
                attributes.add("cacheTernaryBinsPerHash");
            }
            if (this.cacheTernaryDividerBuildStage == -1) {
                attributes.add("cacheTernaryDivider");
            }
            if (this.cacheNegationBinsPerHashBuildStage == -1) {
                attributes.add("cacheNegationBinsPerHash");
            }
            if (this.cacheNegationDividerBuildStage == -1) {
                attributes.add("cacheNegationDivider");
            }
            if (this.cacheVolatileBinsPerHashBuildStage == -1) {
                attributes.add("cacheVolatileBinsPerHash");
            }
            if (this.cacheVolatileMultiplierBuildStage == -1) {
                attributes.add("cacheVolatileMultiplier");
            }
            if (this.initialVariableNodesBuildStage == -1) {
                attributes.add("initialVariableNodes");
            }
            if (this.logStatisticsOnShutdownBuildStage == -1) {
                attributes.add("logStatisticsOnShutdown");
            }
            if (this.minimumCacheSizeBuildStage == -1) {
                attributes.add("minimumCacheSize");
            }
            if (this.minimumFreeNodePercentageAfterGcBuildStage == -1) {
                attributes.add("minimumFreeNodePercentageAfterGc");
            }
            if (this.growthFactorBuildStage == -1) {
                attributes.add("growthFactor");
            }
            if (this.useGlobalComposeCacheBuildStage == -1) {
                attributes.add("useGlobalComposeCache");
            }
            if (this.useShannonExistsBuildStage == -1) {
                attributes.add("useShannonExists");
            }
            if (this.useGarbageCollectionBuildStage == -1) {
                attributes.add("useGarbageCollection");
            }
            if (this.integrityDuplicatesMaximalSizeBuildStage == -1) {
                attributes.add("integrityDuplicatesMaximalSize");
            }
            if (this.threadSafetyCheckBuildStage == -1) {
                attributes.add("threadSafetyCheck");
            }
            return "Cannot build BddConfiguration, attribute initializers form cycle " + attributes;
        }
    }
}

