/*
 * Decompiled with CFR 0.152.
 */
package owl.automaton;

import com.google.common.collect.Maps;
import java.util.BitSet;
import java.util.List;
import java.util.Set;
import owl.automaton.Automaton;
import owl.automaton.acceptance.OmegaAcceptance;
import owl.automaton.edge.Edge;
import owl.collections.ValuationTree;

public interface EdgeMapAutomatonMixin<S, A extends OmegaAcceptance>
extends Automaton<S, A> {
    public static final List<Automaton.PreferredEdgeAccess> ACCESS_MODES = List.of(Automaton.PreferredEdgeAccess.EDGE_MAP, Automaton.PreferredEdgeAccess.EDGE_TREE, Automaton.PreferredEdgeAccess.EDGES);

    @Override
    default public Set<Edge<S>> edges(S state) {
        return this.edgeMap(state).keySet();
    }

    @Override
    default public Set<Edge<S>> edges(S state, BitSet valuation) {
        return Maps.filterValues(this.edgeMap(state), x -> x.contains(valuation)).keySet();
    }

    @Override
    default public ValuationTree<Edge<S>> edgeTree(S state) {
        return this.factory().inverse(this.edgeMap(state));
    }

    @Override
    default public List<Automaton.PreferredEdgeAccess> preferredEdgeAccess() {
        return ACCESS_MODES;
    }
}

