/*
 * Decompiled with CFR 0.152.
 */
package owl.automaton.acceptance.optimization;

import com.google.common.collect.Sets;
import com.google.common.graph.ImmutableGraph;
import it.unimi.dsi.fastutil.ints.Int2IntAVLTreeMap;
import it.unimi.dsi.fastutil.ints.Int2IntMap;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.BitSet;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.IntUnaryOperator;
import java.util.logging.Level;
import java.util.logging.Logger;
import owl.automaton.Automaton;
import owl.automaton.MutableAutomaton;
import owl.automaton.MutableAutomatonUtil;
import owl.automaton.Views;
import owl.automaton.acceptance.GeneralizedRabinAcceptance;
import owl.automaton.acceptance.OmegaAcceptance;
import owl.automaton.acceptance.ParityAcceptance;
import owl.automaton.acceptance.RabinAcceptance;
import owl.automaton.acceptance.optimization.GeneralizedRabinAcceptanceOptimizations;
import owl.automaton.acceptance.optimization.ParityAcceptanceOptimizations;
import owl.automaton.algorithm.LanguageEmptiness;
import owl.automaton.algorithm.SccDecomposition;
import owl.automaton.edge.Edge;
import owl.automaton.hoa.HoaWriter;
import owl.run.modules.OwlModule;

public final class AcceptanceOptimizations {
    private static final Logger logger = Logger.getLogger(AcceptanceOptimizations.class.getName());
    private static final List<Consumer<MutableAutomaton<?, GeneralizedRabinAcceptance>>> generalizedRabinDefaultAllList = List.of(GeneralizedRabinAcceptanceOptimizations::minimizeOverlap, GeneralizedRabinAcceptanceOptimizations::minimizeMergePairs, AcceptanceOptimizations::removeTransientAcceptance, GeneralizedRabinAcceptanceOptimizations::removeComplementaryInfSets, GeneralizedRabinAcceptanceOptimizations::minimizeEdgeImplications, GeneralizedRabinAcceptanceOptimizations::minimizeSccIrrelevant, GeneralizedRabinAcceptanceOptimizations::minimizePairImplications, GeneralizedRabinAcceptanceOptimizations::minimizeMergePairs, GeneralizedRabinAcceptanceOptimizations::removeComplementaryInfSets, GeneralizedRabinAcceptanceOptimizations::minimizePairImplications, GeneralizedRabinAcceptanceOptimizations::minimizeEdgeImplications, GeneralizedRabinAcceptanceOptimizations::minimizeSccIrrelevant, GeneralizedRabinAcceptanceOptimizations::mergeBuchiTypePairs);
    private static final List<Consumer<MutableAutomaton<?, GeneralizedRabinAcceptance>>> rabinDefaultAllList = List.of(GeneralizedRabinAcceptanceOptimizations::minimizeOverlap, GeneralizedRabinAcceptanceOptimizations::minimizeMergePairs, AcceptanceOptimizations::removeTransientAcceptance, GeneralizedRabinAcceptanceOptimizations::minimizeEdgeImplications, GeneralizedRabinAcceptanceOptimizations::minimizeSccIrrelevant, GeneralizedRabinAcceptanceOptimizations::minimizePairImplications, GeneralizedRabinAcceptanceOptimizations::minimizeMergePairs, GeneralizedRabinAcceptanceOptimizations::minimizePairImplications, GeneralizedRabinAcceptanceOptimizations::minimizeEdgeImplications, GeneralizedRabinAcceptanceOptimizations::minimizeSccIrrelevant, GeneralizedRabinAcceptanceOptimizations::mergeBuchiTypePairs);
    private static final List<Consumer<MutableAutomaton<?, ParityAcceptance>>> parityDefaultList = List.of(AcceptanceOptimizations::removeTransientAcceptance, AcceptanceOptimizations::removeDeadStates, ParityAcceptanceOptimizations::minimizePriorities, ParityAcceptanceOptimizations::setAcceptingSets);
    public static final OwlModule<OwlModule.Transformer> MODULE = OwlModule.of("optimize-aut", "Heuristically removes states and acceptance sets from the given automaton.", (commandLine, environment) -> new AcceptanceOptimizationTransformer());

    private AcceptanceOptimizations() {
    }

    public static <S, A extends OmegaAcceptance> MutableAutomaton<S, A> optimize(Automaton<S, A> automaton) {
        MutableAutomaton<S, A> mutableAutomaton = MutableAutomatonUtil.asMutable(automaton);
        Object acceptance = mutableAutomaton.acceptance();
        if (acceptance instanceof RabinAcceptance) {
            AcceptanceOptimizations.apply(mutableAutomaton, rabinDefaultAllList);
        } else if (acceptance instanceof GeneralizedRabinAcceptance) {
            MutableAutomaton<S, A> dgra = mutableAutomaton;
            AcceptanceOptimizations.apply(dgra, generalizedRabinDefaultAllList);
        } else if (acceptance instanceof ParityAcceptance) {
            MutableAutomaton<S, A> dpa = mutableAutomaton;
            AcceptanceOptimizations.apply(dpa, parityDefaultList);
        } else {
            AcceptanceOptimizations.apply(mutableAutomaton, List.of(AcceptanceOptimizations::removeTransientAcceptance));
            logger.log(Level.FINE, "Received unsupported acceptance type {0}", acceptance.getClass());
        }
        return mutableAutomaton;
    }

    private static <S, A extends OmegaAcceptance> void apply(MutableAutomaton<S, ?> automaton, List<Consumer<MutableAutomaton<?, A>>> optimizations) {
        logger.log(Level.FINE, "Optimizing automaton with {0}", optimizations);
        for (Consumer<MutableAutomaton<?, A>> optimization : optimizations) {
            logger.log(Level.FINEST, () -> String.format("Current automaton: %s", HoaWriter.toString(automaton)));
            logger.log(Level.FINER, "Applying {0}", optimization);
            optimization.accept(automaton);
            automaton.trim();
        }
        logger.log(Level.FINEST, () -> String.format("Automaton after optimization:%n%s", HoaWriter.toString(automaton)));
    }

    public static <S> void removeDeadStates(MutableAutomaton<S, ?> automaton) {
        AcceptanceOptimizations.removeDeadStates(automaton, true);
    }

    public static <S> void removeDeadStates(MutableAutomaton<S, ?> automaton, boolean removeTransientEdges) {
        SccDecomposition sccDecomposition = SccDecomposition.of(automaton);
        List sccs = sccDecomposition.sccs();
        ImmutableGraph<Integer> condensationGraph = sccDecomposition.condensation();
        HashSet<Integer> rejectingIndices = new HashSet<Integer>();
        for (int sccIndex = sccs.size() - 1; sccIndex >= 0; --sccIndex) {
            Sets.SetView successors;
            Set<S> scc = sccs.get(sccIndex);
            if (sccDecomposition.isTransientScc(scc)) {
                if (!rejectingIndices.containsAll(condensationGraph.successors((Object)sccIndex))) continue;
                rejectingIndices.add(sccIndex);
                continue;
            }
            S state2 = scc.iterator().next();
            Automaton<S, ?> filtered = Views.filtered(automaton, Views.Filter.of(scc));
            if (!LanguageEmptiness.isEmpty(filtered, Set.of(state2)) || !rejectingIndices.containsAll((Collection<?>)(successors = Sets.difference((Set)condensationGraph.successors((Object)sccIndex), Set.of(Integer.valueOf(sccIndex)))))) continue;
            rejectingIndices.add(sccIndex);
        }
        BitSet rejectingSet = ((OmegaAcceptance)automaton.acceptance()).rejectingSet().orElse(null);
        automaton.removeStateIf(s -> rejectingIndices.contains(sccDecomposition.index(s)));
        automaton.updateEdges((state, edge) -> {
            int sccIndex = sccDecomposition.index(state);
            if (removeTransientEdges && !((Set)sccs.get(sccIndex)).contains(edge.successor())) {
                return edge.withoutAcceptance();
            }
            if (!rejectingIndices.contains(sccIndex)) {
                return edge;
            }
            return rejectingSet == null ? edge : edge.withAcceptance(rejectingSet);
        });
        automaton.trim();
    }

    static <S> void removeIndices(MutableAutomaton<S, ?> automaton, Set<S> states, BitSet indicesToRemove) {
        if (indicesToRemove.isEmpty() || states.isEmpty()) {
            return;
        }
        logger.log(Level.FINER, "Removing acceptance indices {0} on subset", indicesToRemove);
        IntUnaryOperator transformer = index -> indicesToRemove.get(index) ? -1 : index;
        automaton.updateEdges(states, (state, edge) -> edge.withAcceptance(transformer));
        automaton.trim();
    }

    static void removeAndRemapIndices(MutableAutomaton<?, ?> automaton, IntSet indicesToRemove) {
        if (indicesToRemove.isEmpty()) {
            automaton.trim();
            return;
        }
        int acceptanceSets = ((OmegaAcceptance)automaton.acceptance()).acceptanceSets();
        Int2IntAVLTreeMap remapping = new Int2IntAVLTreeMap();
        remapping.defaultReturnValue(Integer.MAX_VALUE);
        int newIndex = 0;
        for (int index = 0; index < acceptanceSets; ++index) {
            if (indicesToRemove.contains(index)) {
                remapping.put(index, -1);
                continue;
            }
            remapping.put(index, newIndex);
            ++newIndex;
        }
        logger.log(Level.FINER, "Remapping acceptance indices: {0}", remapping);
        automaton.updateEdges((arg_0, arg_1) -> AcceptanceOptimizations.lambda$removeAndRemapIndices$7((Int2IntMap)remapping, arg_0, arg_1));
        automaton.trim();
    }

    public static <S, A extends OmegaAcceptance> MutableAutomaton<S, A> removeTransientAcceptance(MutableAutomaton<S, A> automaton) {
        SccDecomposition sccDecomposition = SccDecomposition.of(automaton);
        sccDecomposition.sccs();
        sccDecomposition.condensation();
        automaton.updateEdges((state, edge) -> {
            Set<Object> scc = sccDecomposition.scc(state);
            if (sccDecomposition.isTransientScc(scc)) {
                return edge.withoutAcceptance();
            }
            return scc.contains(edge.successor()) ? edge : edge.withoutAcceptance();
        });
        automaton.trim();
        return automaton;
    }

    private static /* synthetic */ Edge lambda$removeAndRemapIndices$7(Int2IntMap remapping, Object state, Edge edge) {
        return edge.withAcceptance((IntUnaryOperator)remapping);
    }

    public static class AcceptanceOptimizationTransformer
    implements OwlModule.AutomatonTransformer {
        @Override
        public Object transform(Automaton<Object, ?> object) {
            MutableAutomaton<Object, ?> mutableAutomaton = MutableAutomatonUtil.asMutable(object);
            try {
                AcceptanceOptimizations.removeDeadStates(mutableAutomaton);
            }
            catch (UnsupportedOperationException ex) {
                logger.log(Level.FINE, "Unsupported acceptance type {0} for emptiness-check", mutableAutomaton.acceptance().getClass());
            }
            return AcceptanceOptimizations.optimize(mutableAutomaton);
        }
    }
}

