/*
 * Decompiled with CFR 0.152.
 */
package owl.automaton.algorithm;

import com.google.auto.value.AutoValue;
import com.google.auto.value.extension.memoized.Memoized;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.graph.GraphBuilder;
import com.google.common.graph.ImmutableGraph;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Predicate;
import owl.automaton.Automaton;
import owl.automaton.SuccessorFunction;
import owl.automaton.algorithm.AutoValue_SccDecomposition;
import owl.automaton.algorithm.Tarjan;

@AutoValue
public abstract class SccDecomposition<S> {
    protected abstract Set<S> initialStates();

    protected abstract SuccessorFunction<S> successorFunction();

    public static <S> SccDecomposition<S> of(Automaton<S, ?> automaton) {
        return SccDecomposition.of(automaton.initialStates(), automaton::successors);
    }

    public static <S> SccDecomposition<S> of(Set<S> initialStates, SuccessorFunction<S> successorFunction) {
        return new AutoValue_SccDecomposition<S>(Set.copyOf(initialStates), successorFunction);
    }

    public boolean anySccMatches(Predicate<? super Set<S>> predicate) {
        Tarjan<S> tarjan = new Tarjan<S>(this.successorFunction(), predicate);
        return this.initialStates().stream().anyMatch(tarjan::run);
    }

    @Memoized
    public List<Set<S>> sccs() {
        SuccessorFunction successorFunction = this.successorFunction();
        ArrayDeque topologicalSortedSccs = new ArrayDeque();
        ArrayList<Set> localTopologicalSortedSccs = new ArrayList<Set>();
        HashSet seenStates = new HashSet();
        AtomicBoolean insertBefore = new AtomicBoolean(false);
        Tarjan<Object> tarjan = new Tarjan<Object>(x -> {
            Object successors = successorFunction.apply(x);
            if (!seenStates.isEmpty() && !Collections.disjoint(seenStates, successors)) {
                insertBefore.set(true);
            }
            return successorFunction.apply(x);
        }, x -> {
            localTopologicalSortedSccs.add(Set.copyOf(x));
            return false;
        });
        for (S initialState : this.initialStates()) {
            localTopologicalSortedSccs.forEach(seenStates::addAll);
            localTopologicalSortedSccs.clear();
            tarjan.run(initialState);
            if (insertBefore.get()) {
                localTopologicalSortedSccs.forEach(topologicalSortedSccs::addFirst);
                insertBefore.set(false);
                continue;
            }
            topologicalSortedSccs.addAll(Lists.reverse(localTopologicalSortedSccs));
        }
        return List.copyOf(topologicalSortedSccs);
    }

    @Memoized
    public List<Set<S>> sccsWithoutTransient() {
        ArrayList<Set<S>> nonTransientSccs = new ArrayList<Set<S>>(this.sccs());
        nonTransientSccs.removeIf(this::isTransientScc);
        return List.copyOf(nonTransientSccs);
    }

    public int index(S state) {
        return this.indexMap().getOrDefault(state, -1);
    }

    public Set<S> scc(S state) {
        int index = this.indexMap().get(state);
        Preconditions.checkArgument((index >= 0 ? 1 : 0) != 0);
        return this.sccs().get(index);
    }

    @Memoized
    public Map<S, Integer> indexMap() {
        HashMap<S, Integer> indexMap = new HashMap<S, Integer>();
        List<Set<S>> sccs = this.sccs();
        int s = sccs.size();
        for (int i = 0; i < s; ++i) {
            Integer iObject = i;
            for (S state : sccs.get(i)) {
                indexMap.put(state, iObject);
            }
        }
        return Map.copyOf(indexMap);
    }

    @Memoized
    public ImmutableGraph<Integer> condensation() {
        ImmutableGraph.Builder builder = GraphBuilder.directed().allowsSelfLoops(true).immutable();
        int i = 0;
        for (Set<S> scc : this.sccs()) {
            builder.addNode((Object)i);
            for (S state : scc) {
                Iterator iterator = this.successorFunction().apply((Object)state).iterator();
                while (iterator.hasNext()) {
                    Object successor = iterator.next();
                    builder.putEdge((Object)i, (Object)this.index(successor));
                }
            }
            ++i;
        }
        return builder.build();
    }

    @Memoized
    public Set<Integer> bottomSccs() {
        ImmutableGraph<Integer> graph = this.condensation();
        HashSet<Integer> bottomSccs = new HashSet<Integer>();
        for (Integer scc : graph.nodes()) {
            if (!Set.of(scc).containsAll(graph.successors((Object)scc))) continue;
            bottomSccs.add(scc);
        }
        return Set.of((Integer[])bottomSccs.toArray(Integer[]::new));
    }

    public boolean isBottomScc(Set<S> scc) {
        int index = this.sccs().indexOf(scc);
        return Set.of(Integer.valueOf(index)).containsAll(this.condensation().successors((Object)index));
    }

    @Memoized
    public Set<Integer> transientSccs() {
        ImmutableGraph<Integer> graph = this.condensation();
        HashSet<Integer> transientSccs = new HashSet<Integer>();
        for (Integer scc : graph.nodes()) {
            if (graph.hasEdgeConnecting((Object)scc, (Object)scc)) continue;
            transientSccs.add(scc);
        }
        return Set.of((Integer[])transientSccs.toArray(Integer[]::new));
    }

    public boolean isTransientScc(Set<S> scc) {
        if (scc.size() > 1) {
            return false;
        }
        int index = this.index(Iterables.getOnlyElement(scc));
        return !this.condensation().hasEdgeConnecting((Object)index, (Object)index);
    }
}

