/*
 * Decompiled with CFR 0.152.
 */
package owl.collections;

import com.google.auto.value.AutoValue;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import owl.collections.AutoValue_Pair;

@AutoValue
public abstract class Pair<A, B> {
    public abstract A fst();

    public abstract B snd();

    public static <A, B> Pair<A, B> of(A fst, B snd) {
        Objects.requireNonNull(fst);
        Objects.requireNonNull(snd);
        return new AutoValue_Pair<A, B>(fst, snd);
    }

    public static <A, B> Set<Pair<A, B>> allPairs(Set<A> fstSet, Set<B> sndSet) {
        HashSet<Pair<A, B>> pairs = new HashSet<Pair<A, B>>();
        for (A fst : fstSet) {
            for (B snd : sndSet) {
                pairs.add(Pair.of(fst, snd));
            }
        }
        return pairs;
    }

    public Pair<B, A> swap() {
        return Pair.of(this.snd(), this.fst());
    }

    public <C> Pair<C, B> mapFst(Function<A, C> fun) {
        return Pair.of(fun.apply(this.fst()), this.snd());
    }

    public <C> Pair<A, C> mapSnd(Function<B, C> fun) {
        return Pair.of(this.fst(), fun.apply(this.snd()));
    }

    public String toString() {
        return "(" + this.fst() + "," + this.snd() + ")";
    }
}

