/*
 * Decompiled with CFR 0.152.
 */
package owl.ltl;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import owl.ltl.BooleanConstant;
import owl.ltl.Disjunction;
import owl.ltl.Formula;
import owl.ltl.visitors.BinaryVisitor;
import owl.ltl.visitors.IntVisitor;
import owl.ltl.visitors.Visitor;

public final class Conjunction
extends Formula.NaryPropositionalOperator {
    public Conjunction(Formula ... conjuncts) {
        this(Conjunction.sortedList(Set.of(conjuncts)), null);
    }

    public Conjunction(Collection<? extends Formula> conjuncts) {
        this(Conjunction.sortedList(new HashSet<Formula>(conjuncts)), null);
    }

    private Conjunction(List<? extends Formula> conjuncts, @Nullable Void internal) {
        super((Class<? extends Formula.NaryPropositionalOperator>)Conjunction.class, List.copyOf(conjuncts));
    }

    public static Formula of(Formula e1, Formula e2) {
        ArrayList<Formula> list = new ArrayList<Formula>();
        list.add(e1);
        list.add(e2);
        return Conjunction.ofInternal(list);
    }

    public static Formula of(Formula ... formulas) {
        ArrayList<Formula> list = new ArrayList<Formula>(formulas.length);
        Collections.addAll(list, formulas);
        return Conjunction.ofInternal(list);
    }

    public static Formula of(Collection<? extends Formula> collection) {
        return Conjunction.ofInternal(new ArrayList<Formula>(collection));
    }

    public static Formula of(Stream<? extends Formula> stream) {
        return Conjunction.ofInternal(stream.collect(Collectors.toCollection(ArrayList::new)));
    }

    static Formula ofInternal(ArrayList<Formula> list) {
        boolean sorted = false;
        while (!sorted) {
            list.sort(null);
            sorted = true;
            for (int i = list.size() - 1; i >= 0; --i) {
                Formula child = list.get(i);
                if (BooleanConstant.FALSE.equals(child)) {
                    return BooleanConstant.FALSE;
                }
                if (BooleanConstant.TRUE.equals(child)) {
                    list.remove(i);
                    continue;
                }
                if (i > 0 && list.get(i - 1).equals(child)) {
                    list.remove(i);
                    continue;
                }
                if (!(child instanceof Conjunction)) continue;
                list.remove(i);
                list.addAll(child.operands);
                sorted = false;
            }
        }
        switch (list.size()) {
            case 0: {
                return BooleanConstant.TRUE;
            }
            case 1: {
                return list.get(0);
            }
        }
        return new Conjunction(list, null);
    }

    @Override
    public int accept(IntVisitor v) {
        return v.visit(this);
    }

    @Override
    public <R> R accept(Visitor<R> v) {
        return v.visit(this);
    }

    public <A, B> A accept(BinaryVisitor<B, A> v, B parameter) {
        return v.visit(this, parameter);
    }

    @Override
    public Formula nnf() {
        return Conjunction.ofInternal(this.mapInternal(Formula::nnf));
    }

    @Override
    public Formula not() {
        return Disjunction.ofInternal(this.mapInternal(Formula::not));
    }

    @Override
    public Formula substitute(Function<? super Formula.TemporalOperator, ? extends Formula> substitution) {
        Formula conjunction = Conjunction.ofInternal(this.mapInternal(c -> c.substitute(substitution)));
        return this.equals(conjunction) ? this : conjunction;
    }

    @Override
    public Formula temporalStep(BitSet valuation) {
        Formula conjunction = Conjunction.ofInternal(this.mapInternal(c -> c.temporalStep(valuation)));
        if (this.equals(conjunction)) {
            return this;
        }
        return conjunction;
    }

    @Override
    protected String operatorSymbol() {
        return "&";
    }
}

