/*
 * Decompiled with CFR 0.152.
 */
package owl.ltl;

import com.google.common.collect.Comparators;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import owl.ltl.Biconditional;
import owl.ltl.BooleanConstant;
import owl.ltl.Conjunction;
import owl.ltl.Disjunction;
import owl.ltl.FOperator;
import owl.ltl.Formulas;
import owl.ltl.GOperator;
import owl.ltl.Literal;
import owl.ltl.MOperator;
import owl.ltl.Negation;
import owl.ltl.ROperator;
import owl.ltl.UOperator;
import owl.ltl.WOperator;
import owl.ltl.XOperator;
import owl.ltl.visitors.BinaryVisitor;
import owl.ltl.visitors.IntVisitor;
import owl.ltl.visitors.Visitor;

public abstract class Formula
implements Comparable<Formula> {
    private static final Comparator<Iterable<Formula>> LIST_COMPARATOR = Comparators.lexicographical(Formula::compareTo);
    public final List<Formula> operands;
    private final int hashCode;
    private final int height;

    Formula(Class<? extends Formula> clazz, List<? extends Formula> operands) {
        this(clazz, operands, 42);
    }

    Formula(Class<? extends Formula> clazz, List<? extends Formula> operands, int valueHashCode) {
        this.operands = List.copyOf(operands);
        this.hashCode = Objects.hash(clazz, this.operands, valueHashCode);
        this.height = this.operands.isEmpty() ? 0 : Formulas.height(this.operands) + 1;
    }

    public abstract int accept(IntVisitor var1);

    public abstract <R> R accept(Visitor<R> var1);

    public abstract <R, P> R accept(BinaryVisitor<P, R> var1, P var2);

    public final BitSet atomicPropositions(boolean includeNested) {
        BitSet atomicPropositions = new BitSet();
        ArrayDeque<Formula> workQueue = new ArrayDeque<Formula>(List.of(this));
        while (!workQueue.isEmpty()) {
            Formula formula = (Formula)workQueue.removeLast();
            if (formula instanceof Literal) {
                atomicPropositions.set(((Literal)formula).getAtom());
                continue;
            }
            if (!(formula instanceof PropositionalOperator) && (!includeNested || !(formula instanceof TemporalOperator))) continue;
            workQueue.addAll(formula.operands);
        }
        return atomicPropositions;
    }

    public final boolean allMatch(Predicate<Formula> predicate) {
        if (!predicate.test(this)) {
            return false;
        }
        for (Formula child : this.operands) {
            if (child.allMatch(predicate)) continue;
            return false;
        }
        return true;
    }

    public final boolean anyMatch(Predicate<Formula> predicate) {
        if (predicate.test(this)) {
            return true;
        }
        for (Formula child : this.operands) {
            if (!child.anyMatch(predicate)) continue;
            return true;
        }
        return false;
    }

    @Override
    public final int compareTo(Formula that) {
        int heightComparison = Integer.compare(this.height, that.height);
        if (heightComparison != 0) {
            return heightComparison;
        }
        int classComparison = Integer.compare(Formula.classIndex(this), Formula.classIndex(that));
        if (classComparison != 0) {
            return classComparison;
        }
        assert (this.getClass().equals(that.getClass()));
        int valueComparison = this.compareValue(that);
        if (valueComparison != 0) {
            return valueComparison;
        }
        int lengthComparison = Integer.compare(this.operands.size(), that.operands.size());
        if (lengthComparison != 0) {
            return lengthComparison;
        }
        return LIST_COMPARATOR.compare(this.operands, that.operands);
    }

    protected int compareValue(Formula o) {
        return 0;
    }

    public final boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Formula)) {
            return false;
        }
        Formula that = (Formula)o;
        return this.hashCode == that.hashCode && this.height == that.height && this.getClass().equals(that.getClass()) && this.equalsValue(that) && this.operands.equals(that.operands);
    }

    protected boolean equalsValue(Formula o) {
        return true;
    }

    public final int hashCode() {
        return this.hashCode;
    }

    public final int height() {
        return this.height;
    }

    public abstract boolean isPureEventual();

    public abstract boolean isPureUniversal();

    public final boolean isSuspendable() {
        return this.isPureEventual() && this.isPureUniversal();
    }

    public abstract Formula nnf();

    public abstract Formula not();

    public final <E extends Formula> Set<E> subformulas(Class<E> clazz) {
        return this.subformulas(clazz::isInstance, clazz::cast);
    }

    public final Set<Formula> subformulas(Predicate<? super Formula> predicate) {
        return this.subformulas(predicate, x -> x);
    }

    public final <E extends Formula> Set<E> subformulas(Predicate<? super Formula> predicate, Function<? super Formula, E> cast) {
        HashSet<Formula> subformulas = new HashSet<Formula>();
        ArrayDeque<Formula> workQueue = new ArrayDeque<Formula>(List.of(this));
        while (!workQueue.isEmpty()) {
            Formula formula = (Formula)workQueue.removeLast();
            if (predicate.test(formula)) {
                subformulas.add((Formula)cast.apply(formula));
            }
            workQueue.addAll(formula.operands);
        }
        return subformulas;
    }

    public abstract Formula substitute(Function<? super TemporalOperator, ? extends Formula> var1);

    public abstract Formula temporalStep(BitSet var1);

    public abstract Formula unfold();

    private static int classIndex(Formula formula) {
        if (formula instanceof BooleanConstant) {
            return 0;
        }
        if (formula instanceof Literal) {
            return 1;
        }
        if (formula instanceof Negation) {
            return 2;
        }
        if (formula instanceof Conjunction) {
            return 3;
        }
        if (formula instanceof Disjunction) {
            return 4;
        }
        if (formula instanceof Biconditional) {
            return 5;
        }
        if (formula instanceof FOperator) {
            return 6;
        }
        if (formula instanceof GOperator) {
            return 7;
        }
        if (formula instanceof XOperator) {
            return 8;
        }
        if (formula instanceof MOperator) {
            return 9;
        }
        if (formula instanceof ROperator) {
            return 10;
        }
        if (formula instanceof UOperator) {
            return 11;
        }
        if (formula instanceof WOperator) {
            return 12;
        }
        throw new AssertionError();
    }

    public static abstract class NaryPropositionalOperator
    extends PropositionalOperator {
        NaryPropositionalOperator(Class<? extends NaryPropositionalOperator> clazz, List<Formula> children) {
            super((Class<? extends PropositionalOperator>)clazz, children);
        }

        @Override
        public final boolean isPureEventual() {
            return this.operands.stream().allMatch(Formula::isPureEventual);
        }

        @Override
        public final boolean isPureUniversal() {
            return this.operands.stream().allMatch(Formula::isPureUniversal);
        }

        public final List<Formula> map(UnaryOperator<Formula> mapper) {
            return this.mapInternal(mapper);
        }

        public final String toString() {
            return this.operands.stream().map(Object::toString).collect(Collectors.joining(this.operatorSymbol(), "(", ")"));
        }

        protected static List<? extends Formula> sortedList(Set<? extends Formula> children) {
            Object[] arrayChildren = (Formula[])children.toArray(Formula[]::new);
            Arrays.sort(arrayChildren);
            return List.of(arrayChildren);
        }

        protected final ArrayList<Formula> mapInternal(UnaryOperator<Formula> mapper) {
            ArrayList<Formula> mappedChildren = new ArrayList<Formula>(this.operands);
            mappedChildren.replaceAll(mapper);
            return mappedChildren;
        }

        protected abstract String operatorSymbol();
    }

    public static abstract class BinaryTemporalOperator
    extends TemporalOperator {
        BinaryTemporalOperator(Class<? extends BinaryTemporalOperator> clazz, Formula leftOperand, Formula rightOperand) {
            super((Class<? extends TemporalOperator>)clazz, List.of(leftOperand, rightOperand));
        }

        @Override
        public final boolean isPureEventual() {
            return false;
        }

        @Override
        public final boolean isPureUniversal() {
            return false;
        }

        public final String toString() {
            return String.format("(%s%s%s)", this.leftOperand(), this.operatorSymbol(), this.rightOperand());
        }

        public Formula leftOperand() {
            assert (this.operands.size() == 2);
            return (Formula)this.operands.get(0);
        }

        public Formula rightOperand() {
            assert (this.operands.size() == 2);
            return (Formula)this.operands.get(1);
        }
    }

    public static abstract class UnaryTemporalOperator
    extends TemporalOperator {
        UnaryTemporalOperator(Class<? extends UnaryTemporalOperator> clazz, Formula operand) {
            super((Class<? extends TemporalOperator>)clazz, List.of(operand));
        }

        public String toString() {
            return this.operatorSymbol() + this.operand();
        }

        public Formula operand() {
            assert (this.operands.size() == 1);
            return (Formula)this.operands.get(0);
        }
    }

    public static abstract class TemporalOperator
    extends Formula {
        TemporalOperator(Class<? extends TemporalOperator> clazz, List<Formula> children) {
            super(clazz, children);
        }

        public abstract String operatorSymbol();

        @Override
        public final Formula substitute(Function<? super TemporalOperator, ? extends Formula> substitution) {
            return substitution.apply(this);
        }

        @Override
        public final Formula temporalStep(BitSet valuation) {
            if (this instanceof XOperator) {
                return ((XOperator)this).operand();
            }
            return this;
        }

        @Override
        protected final int compareValue(Formula o) {
            return 0;
        }

        @Override
        protected final boolean equalsValue(Formula o) {
            return true;
        }
    }

    public static abstract class PropositionalOperator
    extends Formula {
        PropositionalOperator(Class<? extends PropositionalOperator> clazz, List<Formula> children) {
            super(clazz, children);
        }

        PropositionalOperator(Class<? extends PropositionalOperator> clazz, List<Formula> children, int valueHashCode) {
            super(clazz, children, valueHashCode);
        }

        @Override
        public final Formula unfold() {
            return this.substitute(Formula::unfold);
        }
    }
}

