/*
 * Decompiled with CFR 0.152.
 */
package owl.run;

import com.google.auto.value.AutoValue;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import owl.run.AutoValue_Pipeline;
import owl.run.PipelineException;
import owl.run.modules.OwlModule;

@AutoValue
public abstract class Pipeline {
    private static final Logger logger = Logger.getLogger(Pipeline.class.getName());

    public abstract OwlModule.InputReader input();

    public abstract List<OwlModule.Transformer> transformers();

    public abstract OwlModule.OutputWriter output();

    public static Pipeline of(OwlModule.InputReader reader, List<OwlModule.Transformer> transformers, OwlModule.OutputWriter writer) {
        return new AutoValue_Pipeline(reader, List.copyOf(transformers), writer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(ReadableByteChannel inputChannel, WritableByteChannel outputChannel) throws IOException {
        AtomicBoolean shutdownSignal = new AtomicBoolean(false);
        try (Reader reader = Channels.newReader(inputChannel, StandardCharsets.UTF_8.name());
             Writer writer = Channels.newWriter(outputChannel, StandardCharsets.UTF_8.name());){
            this.input().read(reader, input -> {
                try {
                    logger.log(Level.FINEST, "Handling input {0}", input);
                    long startTime = System.nanoTime();
                    Object output = input;
                    for (OwlModule.Transformer transformer : this.transformers()) {
                        output = transformer.transform(output);
                    }
                    long executionTime = System.nanoTime() - startTime;
                    logger.log(Level.FINE, () -> String.format("Execution of transformers for %s took %.2f sec", input, (double)executionTime / (double)TimeUnit.SECONDS.toNanos(1L)));
                    this.output().write(writer, output);
                    writer.flush();
                }
                catch (IOException exception) {
                    throw new PipelineException("Error writing result", exception);
                }
            }, shutdownSignal::get);
        }
        finally {
            shutdownSignal.set(true);
        }
    }
}

