/*
 * Decompiled with CFR 0.152.
 */
package owl.translations.mastertheorem;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import owl.factories.Factories;
import owl.ltl.BooleanConstant;
import owl.ltl.Conjunction;
import owl.ltl.Disjunction;
import owl.ltl.EquivalenceClass;
import owl.ltl.FOperator;
import owl.ltl.Formula;
import owl.ltl.Formulas;
import owl.ltl.GOperator;
import owl.ltl.LtlLanguageExpressible;
import owl.ltl.MOperator;
import owl.ltl.UOperator;
import owl.ltl.XOperator;
import owl.ltl.rewriter.NormalForms;
import owl.ltl.rewriter.SimplifierFactory;
import owl.translations.canonical.DeterministicConstructions;
import owl.translations.canonical.NonDeterministicConstructions;
import owl.translations.mastertheorem.ExtendedRewriter;
import owl.translations.mastertheorem.Fixpoints;
import owl.translations.mastertheorem.Predicates;

public final class SymmetricEvaluatedFixpoints
implements Comparable<SymmetricEvaluatedFixpoints>,
LtlLanguageExpressible {
    public final Fixpoints fixpoints;
    public final Set<FOperator> almostAlways;
    public final Set<GOperator> infinitelyOften;
    private final EquivalenceClass language;

    private SymmetricEvaluatedFixpoints(Fixpoints fixpoints, Collection<FOperator> almostAlways, Collection<GOperator> infinitelyOften, EquivalenceClass language) {
        this.fixpoints = fixpoints;
        this.almostAlways = Set.copyOf(almostAlways);
        this.infinitelyOften = Set.copyOf(infinitelyOften);
        this.language = language;
    }

    public static Set<SymmetricEvaluatedFixpoints> build(Formula formula, Fixpoints fixpoints, Factories factories) {
        HashSet<Formula.TemporalOperator> unusedFixpoints = new HashSet<Formula.TemporalOperator>(fixpoints.fixpoints());
        ExtendedRewriter.ToCoSafety toCoSafety = new ExtendedRewriter.ToCoSafety(fixpoints, unusedFixpoints::remove);
        ExtendedRewriter.ToSafety toSafety = new ExtendedRewriter.ToSafety(fixpoints, unusedFixpoints::remove);
        Set<Object> infinitelyOftenFormulas = new HashSet();
        for (Formula.TemporalOperator temporalOperator : fixpoints.leastFixpoints()) {
            Formula formula2 = SymmetricEvaluatedFixpoints.unwrapX(SimplifierFactory.apply(GOperator.of(FOperator.of(toCoSafety.apply(temporalOperator))), SimplifierFactory.Mode.SYNTACTIC_FIXPOINT, SimplifierFactory.Mode.PULL_UP_X));
            if (formula2.equals(BooleanConstant.TRUE)) continue;
            if (formula2.equals(BooleanConstant.FALSE)) {
                return Set.of();
            }
            for (Set<Formula> set : NormalForms.toCnf(formula2)) {
                assert (!set.isEmpty());
                Formula disjunction = Disjunction.of(set.stream().map(SymmetricEvaluatedFixpoints::unwrapGf));
                assert (!(disjunction instanceof BooleanConstant));
                infinitelyOftenFormulas.add(SymmetricEvaluatedFixpoints.wrapGf(disjunction));
            }
        }
        ArrayList sortedInfinitelyOftenFormulas = new ArrayList(infinitelyOftenFormulas);
        sortedInfinitelyOftenFormulas.sort(Comparator.reverseOrder());
        for (GOperator gOperator : sortedInfinitelyOftenFormulas) {
            Formula operand = SymmetricEvaluatedFixpoints.unwrapGf(gOperator);
            if (!(operand instanceof Conjunction)) continue;
            for (Object conjunct : ((Conjunction)operand).operands) {
                Formula formula3 = SymmetricEvaluatedFixpoints.unwrapX((Formula)conjunct);
                if (formula3 instanceof FOperator) {
                    infinitelyOftenFormulas.removeIf(y -> y.operand().equals(unwrappedConjunct));
                    continue;
                }
                if (formula3 instanceof UOperator) {
                    infinitelyOftenFormulas.removeIf(y -> SymmetricEvaluatedFixpoints.unwrapGf(y).equals(SymmetricEvaluatedFixpoints.unwrapX(((UOperator)unwrappedConjunct).rightOperand())));
                    continue;
                }
                if (formula3 instanceof MOperator) {
                    infinitelyOftenFormulas.removeIf(y -> SymmetricEvaluatedFixpoints.unwrapGf(y).equals(SymmetricEvaluatedFixpoints.unwrapX(((MOperator)unwrappedConjunct).leftOperand())));
                    continue;
                }
                infinitelyOftenFormulas.remove(SymmetricEvaluatedFixpoints.wrapGf(formula3));
            }
        }
        infinitelyOftenFormulas = Set.of((GOperator[])infinitelyOftenFormulas.toArray(GOperator[]::new));
        ArrayList almostAlwaysFormulasAlternatives = new ArrayList();
        for (Formula.TemporalOperator temporalOperator : fixpoints.greatestFixpoints()) {
            Formula almostAlways = SymmetricEvaluatedFixpoints.unwrapX(SimplifierFactory.apply(FOperator.of(GOperator.of(toSafety.apply(temporalOperator))), SimplifierFactory.Mode.SYNTACTIC_FIXPOINT, SimplifierFactory.Mode.PULL_UP_X));
            if (almostAlways.equals(BooleanConstant.TRUE)) continue;
            if (almostAlways.equals(BooleanConstant.FALSE)) {
                return Set.of();
            }
            HashSet<FOperator> hashSet = new HashSet<FOperator>();
            for (Set set : NormalForms.toDnf(almostAlways)) {
                assert (!set.isEmpty());
                Formula conjunction = Conjunction.of(set.stream().map(SymmetricEvaluatedFixpoints::unwrapFg));
                assert (!(conjunction instanceof BooleanConstant));
                hashSet.add(SymmetricEvaluatedFixpoints.wrapFg(conjunction));
            }
            assert (!hashSet.isEmpty());
            almostAlwaysFormulasAlternatives.add(hashSet);
        }
        ExtendedRewriter.ToSafety toSafety2 = new ExtendedRewriter.ToSafety(fixpoints.leastFixpoints(), unusedFixpoints::remove);
        for (Formula.TemporalOperator greatestFixpoint : formula.subformulas(Predicates.IS_GREATEST_FIXPOINT, Formula.TemporalOperator.class::cast)) {
            toSafety2.apply(greatestFixpoint);
        }
        if (!unusedFixpoints.isEmpty()) {
            return Set.of();
        }
        HashSet<SymmetricEvaluatedFixpoints> hashSet = new HashSet<SymmetricEvaluatedFixpoints>();
        for (List list : Sets.cartesianProduct(almostAlwaysFormulasAlternatives)) {
            Formula language = Conjunction.of(Stream.concat(list.stream().map(Formula.UnaryTemporalOperator::operand), infinitelyOftenFormulas.stream()));
            EquivalenceClass equivalenceClass = factories.eqFactory.of(language.unfold());
            if (equivalenceClass.isFalse()) continue;
            hashSet.add(new SymmetricEvaluatedFixpoints(fixpoints, list, infinitelyOftenFormulas, equivalenceClass));
        }
        return hashSet;
    }

    @Override
    public int compareTo(SymmetricEvaluatedFixpoints that) {
        int comparison = Formulas.compare(this.infinitelyOften, that.infinitelyOften);
        if (comparison != 0) {
            return -comparison;
        }
        comparison = Formulas.compare(this.almostAlways, that.almostAlways);
        if (comparison != 0) {
            return comparison;
        }
        return this.fixpoints.compareTo(that.fixpoints);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SymmetricEvaluatedFixpoints)) {
            return false;
        }
        SymmetricEvaluatedFixpoints that = (SymmetricEvaluatedFixpoints)o;
        return this.fixpoints.equals(that.fixpoints) && this.almostAlways.equals(that.almostAlways) && this.infinitelyOften.equals(that.infinitelyOften);
    }

    public int hashCode() {
        return Objects.hash(this.fixpoints, this.almostAlways, this.infinitelyOften);
    }

    public boolean isEmpty() {
        return this.almostAlways.isEmpty() && this.infinitelyOften.isEmpty();
    }

    public boolean isSafety() {
        return this.infinitelyOften.isEmpty();
    }

    public boolean isLiveness() {
        return this.almostAlways.isEmpty();
    }

    @Override
    public EquivalenceClass language() {
        return this.language;
    }

    public String toString() {
        return "<" + this.almostAlways + ", " + this.infinitelyOften + ">";
    }

    public DeterministicAutomata deterministicAutomata(Factories factories, boolean generalized) {
        DeterministicConstructions.GfCoSafety gfCoSafetyAutomaton;
        DeterministicConstructions.Safety safetyAutomaton = DeterministicConstructions.Safety.of(factories, Conjunction.of(this.almostAlways.stream().map(Formula.UnaryTemporalOperator::operand)));
        DeterministicConstructions.GfCoSafety gfCoSafety = gfCoSafetyAutomaton = this.infinitelyOften.isEmpty() ? null : DeterministicConstructions.GfCoSafety.of(factories, new TreeSet<GOperator>(this.infinitelyOften), generalized);
        assert (!((EquivalenceClass)safetyAutomaton.onlyInitialState()).isFalse());
        return new DeterministicAutomata(gfCoSafetyAutomaton, safetyAutomaton);
    }

    public NonDeterministicAutomata nonDeterministicAutomata(Factories factories, boolean generalized) {
        NonDeterministicConstructions.Safety safetyAutomaton = NonDeterministicConstructions.Safety.of(factories, Conjunction.of(this.almostAlways.stream().map(Formula.UnaryTemporalOperator::operand)));
        NonDeterministicConstructions.GfCoSafety gfCoSafetyAutomaton = this.infinitelyOften.isEmpty() ? null : NonDeterministicConstructions.GfCoSafety.of(factories, new TreeSet<GOperator>(this.infinitelyOften), generalized);
        return new NonDeterministicAutomata(gfCoSafetyAutomaton, safetyAutomaton);
    }

    private static Formula unwrapFg(Formula formula) {
        return ((GOperator)((FOperator)formula).operand()).operand();
    }

    private static Formula unwrapGf(Formula formula) {
        return ((FOperator)((GOperator)formula).operand()).operand();
    }

    private static Formula unwrapX(Formula formula) {
        Formula unwrappedFormula = formula;
        while (unwrappedFormula instanceof XOperator) {
            unwrappedFormula = ((XOperator)unwrappedFormula).operand();
        }
        return unwrappedFormula;
    }

    private static FOperator wrapFg(Formula formula) {
        if (formula instanceof FOperator && ((FOperator)formula).operand() instanceof GOperator) {
            return (FOperator)formula;
        }
        return formula instanceof GOperator ? new FOperator(formula) : new FOperator(new GOperator(formula));
    }

    private static GOperator wrapGf(Formula formula) {
        if (formula instanceof GOperator && ((GOperator)formula).operand() instanceof FOperator) {
            return (GOperator)formula;
        }
        return formula instanceof FOperator ? new GOperator(formula) : new GOperator(new FOperator(formula));
    }

    public static final class NonDeterministicAutomata {
        @Nullable
        public final NonDeterministicConstructions.GfCoSafety gfCoSafetyAutomaton;
        public final NonDeterministicConstructions.Safety safetyAutomaton;

        private NonDeterministicAutomata(@Nullable NonDeterministicConstructions.GfCoSafety gfCoSafetyAutomaton, NonDeterministicConstructions.Safety safetyAutomaton) {
            this.gfCoSafetyAutomaton = gfCoSafetyAutomaton;
            this.safetyAutomaton = safetyAutomaton;
        }
    }

    public static final class DeterministicAutomata {
        @Nullable
        public final DeterministicConstructions.GfCoSafety gfCoSafetyAutomaton;
        public final DeterministicConstructions.Safety safetyAutomaton;

        private DeterministicAutomata(@Nullable DeterministicConstructions.GfCoSafety gfCoSafetyAutomaton, DeterministicConstructions.Safety safetyAutomaton) {
            this.gfCoSafetyAutomaton = gfCoSafetyAutomaton;
            this.safetyAutomaton = safetyAutomaton;
        }
    }
}

