/*
 * Decompiled with CFR 0.152.
 */
package owl.translations.nbadet;

import com.google.common.collect.Sets;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import owl.automaton.Automaton;
import owl.automaton.acceptance.BuchiAcceptance;
import owl.automaton.algorithm.simulations.BuchiSimulation;
import owl.automaton.algorithm.simulations.ColorRefinement;
import owl.automaton.edge.Edge;
import owl.collections.Pair;
import owl.collections.ValuationSet;
import owl.run.RunUtil;
import owl.translations.nbadet.NbaDet;
import owl.translations.nbadet.NbaSimAlgorithm;

public final class NbaLangInclusions {
    private static final Logger logger = Logger.getLogger(NbaDet.class.getName());

    private NbaLangInclusions() {
    }

    public static Set<SimType> getQuotientable() {
        return Set.of(SimType.NULL_SIM, SimType.DIRECT_SIM, SimType.DIRECT_REFINEMENT_SIM, SimType.DELAYED_SIM);
    }

    public static <S> Map<SimType, NbaSimAlgorithm<S, ?>> getAlgos() {
        return Map.of(SimType.NULL_SIM, new NbaSimNull(), SimType.DIRECT_SIM, new NbaSimDirect(), SimType.DELAYED_SIM, new NbaSimDelayed(), SimType.FAIR_SIM, new NbaSimFair(), SimType.LOOKAHEAD_DIRECT_SIM, new NbaSimLookaheadDirect(), SimType.DIRECT_REFINEMENT_SIM, new NbaSimDirectRefinement());
    }

    public static Map<String, SimType> getAlgoArgs() {
        return Map.of("null", SimType.NULL_SIM, "direct", SimType.DIRECT_SIM, "refinement", SimType.DIRECT_REFINEMENT_SIM, "delayed", SimType.DELAYED_SIM, "fair", SimType.FAIR_SIM, "la-direct", SimType.LOOKAHEAD_DIRECT_SIM);
    }

    public static <S> Set<Pair<S, S>> computeLangInclusions(Automaton<S, BuchiAcceptance> aut, Set<Pair<SimType, String>> algset) {
        Map algos = NbaLangInclusions.getAlgos();
        return algset.stream().map(sim -> {
            logger.log(Level.FINE, "running simulation algorithm for " + sim.fst());
            if (!algos.containsKey(sim.fst())) {
                RunUtil.failWithMessage("ERROR: simulation not implemented yet: " + sim.fst());
            }
            NbaSimAlgorithm alg = (NbaSimAlgorithm)algos.get(sim.fst());
            return alg.run(aut, (String)sim.snd());
        }).reduce(Set.of(), Sets::union);
    }

    public static <S> Set<S> getNbaAccPseudoSinks(Automaton<S, BuchiAcceptance> aut) {
        return aut.states().stream().filter(st -> aut.edgeMap(st).entrySet().stream().filter(e -> ((Edge)e.getKey()).successor().equals(st) && ((BuchiAcceptance)aut.acceptance()).isAcceptingEdge((Edge)e.getKey())).map(Map.Entry::getValue).reduce(ValuationSet::union).orElse(aut.factory().empty()).isUniverse()).collect(Collectors.toSet());
    }

    static class NbaSimNull<S>
    extends NbaSimWithPebbles<S> {
        NbaSimNull() {
        }

        @Override
        public Set<Pair<S, S>> compute(Automaton<S, BuchiAcceptance> aut, Integer parsedArg) {
            logger.fine("running null simulation with int argument " + parsedArg.toString());
            return Set.of();
        }
    }

    static class NbaSimLookaheadDirect<S>
    extends NbaSimWithPebbles<S> {
        NbaSimLookaheadDirect() {
        }

        @Override
        public Set<Pair<S, S>> compute(Automaton<S, BuchiAcceptance> aut, Integer parsedArg) {
            logger.fine("running direct sim with lookahead " + parsedArg.toString());
            return new BuchiSimulation().directLookaheadSimulation(aut, aut, parsedArg);
        }
    }

    static class NbaSimFair<S>
    extends NbaSimWithPebbles<S> {
        NbaSimFair() {
        }

        @Override
        public Set<Pair<S, S>> compute(Automaton<S, BuchiAcceptance> aut, Integer parsedArg) {
            logger.fine("running fair simulation with " + parsedArg.toString() + " pebbles.");
            return new BuchiSimulation().fairSimulation(aut, aut, parsedArg);
        }
    }

    static class NbaSimDelayed<S>
    extends NbaSimWithPebbles<S> {
        NbaSimDelayed() {
        }

        @Override
        public Set<Pair<S, S>> compute(Automaton<S, BuchiAcceptance> aut, Integer parsedArg) {
            logger.fine("running delayed simulation with " + parsedArg.toString() + " pebbles.");
            return new BuchiSimulation().delayedSimulation(aut, aut, parsedArg);
        }
    }

    static class NbaSimDirect<S>
    extends NbaSimWithPebbles<S> {
        NbaSimDirect() {
        }

        @Override
        public Set<Pair<S, S>> compute(Automaton<S, BuchiAcceptance> aut, Integer parsedArg) {
            logger.fine("running direct simulation with " + parsedArg.toString() + " pebbles.");
            return new BuchiSimulation().directSimulation(aut, aut, parsedArg);
        }
    }

    static class NbaSimDirectRefinement<S>
    extends NbaSimWithPebbles<S> {
        NbaSimDirectRefinement() {
        }

        @Override
        public Set<Pair<S, S>> compute(Automaton<S, BuchiAcceptance> aut, Integer parsedArg) {
            logger.fine("running direct simulation based on color refinement.");
            return ColorRefinement.of(aut);
        }
    }

    static class NbaSimWithPebbles<S>
    implements NbaSimAlgorithm<S, Integer> {
        NbaSimWithPebbles() {
        }

        @Override
        public Set<Pair<S, S>> compute(Automaton<S, BuchiAcceptance> aut, Integer parsedArg) {
            logger.log(Level.FINE, "running sim with arg: " + parsedArg.toString());
            return Set.of();
        }

        @Override
        public Integer parseArg(String arg) {
            int i = 1;
            if (arg.isBlank()) {
                return i;
            }
            try {
                i = Integer.parseInt(arg);
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException(e);
            }
            return i;
        }
    }

    public static enum SimType {
        NULL_SIM,
        DIRECT_SIM,
        DELAYED_SIM,
        FAIR_SIM,
        LOOKAHEAD_DIRECT_SIM,
        DIRECT_REFINEMENT_SIM;

    }
}

