/*
 * Decompiled with CFR 0.152.
 */
package owl.translations.nbadet;

import com.google.auto.value.AutoValue;
import com.google.common.graph.Graphs;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import owl.automaton.Automaton;
import owl.automaton.AutomatonUtil;
import owl.automaton.Views;
import owl.automaton.acceptance.BuchiAcceptance;
import owl.automaton.algorithm.LanguageEmptiness;
import owl.automaton.algorithm.SccDecomposition;
import owl.automaton.edge.Edge;
import owl.translations.nbadet.AutoValue_NbaSccInfo;

@AutoValue
public abstract class NbaSccInfo<S> {
    public abstract SccDecomposition<S> sccDecomposition();

    public abstract Set<Integer> trvSccs();

    public abstract Set<Integer> botSccs();

    public abstract Set<Integer> detSccs();

    public abstract Set<Integer> rejSccs();

    public abstract Set<Integer> accSccs();

    public IntStream ids() {
        return IntStream.range(0, this.sccDecomposition().sccs().size());
    }

    public boolean isSccReachable(int s, int t) {
        if (s == t) {
            return !this.sccDecomposition().isTransientScc(this.sccDecomposition().sccs().get(s));
        }
        return Graphs.reachableNodes(this.sccDecomposition().condensation(), (Object)s).contains(t);
    }

    public boolean isStateReachable(S p, S q) {
        if (this.sccDecomposition().index(p) < 0 || this.sccDecomposition().index(q) < 0) {
            return false;
        }
        if (this.sccDecomposition().index(p) == this.sccDecomposition().index(q)) {
            return !this.trvSccs().contains(this.sccDecomposition().index(p));
        }
        return this.isSccReachable(this.sccDecomposition().index(p), this.sccDecomposition().index(q));
    }

    String sccToString(int i) {
        return this.sccDecomposition().sccs().get(i).toString() + ":" + (this.trvSccs().contains(i) ? "T" : "") + (this.botSccs().contains(i) ? "B" : "") + (this.detSccs().contains(i) ? "D" : "") + (this.rejSccs().contains(i) ? "R" : "") + (this.accSccs().contains(i) ? "A" : "");
    }

    public String toString() {
        return IntStream.range(0, this.sccDecomposition().sccs().size()).mapToObj(this::sccToString).collect(Collectors.joining(", ", "[", "]"));
    }

    public static <S> NbaSccInfo<S> of(Automaton<S, BuchiAcceptance> aut) {
        SccDecomposition<S> sccD = SccDecomposition.of(aut);
        Set<Integer> trvSccs = sccD.transientSccs();
        Set<Integer> botSccs = sccD.bottomSccs();
        HashSet<Integer> detSccs = new HashSet<Integer>();
        HashSet<Integer> accSccs = new HashSet<Integer>();
        HashSet<Integer> rejSccs = new HashSet<Integer>();
        for (int i = 0; i < sccD.sccs().size(); ++i) {
            Set<S> scc = sccD.sccs().get(i);
            Views.Filter<Object> filt = Views.Filter.builder().initialStates(scc).stateFilter(scc::contains).build();
            Automaton<Object, BuchiAcceptance> restrictedAut = Views.filtered(aut, filt);
            if (AutomatonUtil.getNondeterministicStates(restrictedAut).isEmpty()) {
                detSccs.add(i);
            }
            Views.Filter<Object> justScc = Views.Filter.builder().initialStates(scc).stateFilter(scc::contains).build();
            if (LanguageEmptiness.isEmpty(Views.filtered(aut, justScc), Set.of(scc.iterator().next()))) {
                rejSccs.add(i);
            }
            Views.Filter<Object> justRej = Views.Filter.builder().initialStates(scc).stateFilter(scc::contains).edgeFilter((s, e) -> !((BuchiAcceptance)aut.acceptance()).isAcceptingEdge((Edge<?>)e)).build();
            Automaton<Object, BuchiAcceptance> rejSubAut = Views.filtered(aut, justRej);
            SccDecomposition<Object> sccScci = SccDecomposition.of(rejSubAut);
            boolean noRejLoops = sccScci.sccs().stream().allMatch(sccScci::isTransientScc);
            if (!noRejLoops || trvSccs.contains(i)) continue;
            accSccs.add(i);
        }
        return new AutoValue_NbaSccInfo<S>(sccD, trvSccs, botSccs, detSccs, rejSccs, accSccs);
    }
}

