/*
 * Decompiled with CFR 0.152.
 */
package owl.translations.rabinizer;

import com.google.common.collect.ImmutableTable;
import com.google.common.collect.Iterables;
import com.google.common.collect.Table;
import de.tum.in.naturals.Indices;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import owl.automaton.Automaton;
import owl.automaton.algorithm.SccDecomposition;
import owl.collections.ValuationSet;
import owl.ltl.EquivalenceClass;

final class MasterStatePartition {
    final List<Set<EquivalenceClass>> sccs;
    final ImmutableTable<EquivalenceClass, EquivalenceClass, ValuationSet> outgoingTransitions;
    final Set<EquivalenceClass> transientStates;

    private MasterStatePartition(List<Set<EquivalenceClass>> sccs, Set<EquivalenceClass> transientStates, Table<EquivalenceClass, EquivalenceClass, ValuationSet> outgoingTransitions) {
        this.sccs = List.copyOf(sccs);
        this.transientStates = Set.copyOf(transientStates);
        this.outgoingTransitions = ImmutableTable.copyOf(outgoingTransitions);
    }

    public static MasterStatePartition create(Automaton<EquivalenceClass, ?> masterAutomaton) {
        SccDecomposition<EquivalenceClass> masterSccs = SccDecomposition.of(masterAutomaton);
        ImmutableTable.Builder outgoingTransitionsBuilder = ImmutableTable.builder();
        ArrayList<Set<EquivalenceClass>> sccListBuilder = new ArrayList<Set<EquivalenceClass>>();
        HashSet<EquivalenceClass> transientStatesBuilder = new HashSet<EquivalenceClass>();
        for (Set<EquivalenceClass> scc : masterSccs.sccs()) {
            scc.forEach(state -> masterAutomaton.edgeMap((EquivalenceClass)state).forEach((edge, valuations) -> {
                if (!scc.contains(edge.successor())) {
                    outgoingTransitionsBuilder.put(state, (Object)((EquivalenceClass)edge.successor()), valuations);
                }
            }));
            if (masterSccs.isTransientScc(scc)) {
                transientStatesBuilder.add((EquivalenceClass)Iterables.getOnlyElement(scc));
                continue;
            }
            sccListBuilder.add(Set.copyOf(scc));
        }
        return new MasterStatePartition(sccListBuilder, transientStatesBuilder, (Table<EquivalenceClass, EquivalenceClass, ValuationSet>)outgoingTransitionsBuilder.build());
    }

    int partitionSize() {
        return this.sccs.size();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder(32 + 40 * this.transientStates.size() + 100 * this.sccs.size());
        builder.append("Master state partitioning:");
        if (!this.transientStates.isEmpty()) {
            builder.append("\n  Transient: ").append(this.transientStates);
        }
        Indices.forEachIndexed(this.sccs, (index, element) -> builder.append("\n  ").append(index).append(": ").append(element));
        return builder.toString();
    }
}

