/*
 * Decompiled with CFR 0.152.
 */
package owl.automaton;

import java.util.Set;
import owl.automaton.AnnotatedState;
import owl.automaton.Automaton;
import owl.automaton.HashMapAutomaton;
import owl.automaton.Views;
import owl.automaton.acceptance.OmegaAcceptance;
import owl.automaton.algorithm.SccDecomposition;

public final class AnnotatedStateOptimisation {
    private AnnotatedStateOptimisation() {
    }

    public static <S extends AnnotatedState<?>, A extends OmegaAcceptance> Automaton<S, A> optimizeInitialState(Automaton<S, A> automaton) {
        HashMapAutomaton<Object, A> mutableAutomatonCopy = HashMapAutomaton.copyOf(automaton);
        if (mutableAutomatonCopy.initialStates().isEmpty()) {
            return mutableAutomatonCopy;
        }
        Object originalInitialState = ((AnnotatedState)mutableAutomatonCopy.onlyInitialState()).state();
        AnnotatedState candidateInitialState = null;
        int size = mutableAutomatonCopy.size();
        for (Set<S> scc : SccDecomposition.of(mutableAutomatonCopy).sccsWithoutTransient()) {
            for (AnnotatedState state : scc) {
                int newSize;
                if (!originalInitialState.equals(state.state()) || (newSize = Views.filtered(mutableAutomatonCopy, Views.Filter.of(Set.of(state))).size()) >= size) continue;
                candidateInitialState = state;
                size = newSize;
            }
        }
        if (candidateInitialState != null) {
            mutableAutomatonCopy.initialStates(Set.of(candidateInitialState));
            mutableAutomatonCopy.trim();
        }
        return mutableAutomatonCopy;
    }
}

