/*
 * Decompiled with CFR 0.152.
 */
package owl.automaton;

import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.IntUnaryOperator;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionGroup;
import org.apache.commons.cli.Options;
import owl.automaton.Automaton;
import owl.automaton.HashMapAutomaton;
import owl.automaton.MutableAutomaton;
import owl.automaton.MutableAutomatonUtil;
import owl.automaton.SingletonAutomaton;
import owl.automaton.acceptance.ParityAcceptance;
import owl.run.modules.OwlModule;

public final class ParityUtil {
    public static final OwlModule<OwlModule.Transformer> COMPLEMENT_MODULE = OwlModule.of("complement-parity", "Complements a parity automaton", (commandLine, environment) -> OwlModule.AutomatonTransformer.of(automaton -> ParityUtil.complement(MutableAutomatonUtil.asMutable(automaton), new MutableAutomatonUtil.Sink()), ParityAcceptance.class));
    public static final OwlModule<OwlModule.Transformer> CONVERSION_MODULE = OwlModule.of("convert-parity", "Converts a parity automaton into the desired type", new Options().addOptionGroup(new OptionGroup().addOption(new Option(null, "max", false, null)).addOption(new Option(null, "min", false, null))).addOptionGroup(new OptionGroup().addOption(new Option(null, "even", false, null)).addOption(new Option(null, "odd", false, null))), (commandLine, environment) -> {
        Boolean toMax = commandLine.hasOption("max") ? Boolean.TRUE : (commandLine.hasOption("min") ? Boolean.FALSE : null);
        Boolean toEven = commandLine.hasOption("even") ? Boolean.TRUE : (commandLine.hasOption("odd") ? Boolean.FALSE : null);
        return OwlModule.AutomatonTransformer.of(automaton -> {
            ParityAcceptance.Parity target = ((ParityAcceptance)automaton.acceptance()).parity();
            if (toEven != null) {
                target = target.setEven(toEven);
            }
            if (toMax != null) {
                target = target.setMax(toMax);
            }
            return ParityUtil.convert(automaton, target, new MutableAutomatonUtil.Sink());
        }, ParityAcceptance.class);
    });

    private ParityUtil() {
    }

    public static <S> MutableAutomaton<S, ParityAcceptance> complement(MutableAutomaton<S, ParityAcceptance> automaton, S sinkState) {
        assert (automaton.is(Automaton.Property.DETERMINISTIC));
        ParityAcceptance acceptance = (ParityAcceptance)automaton.acceptance();
        if (acceptance.acceptanceSets() == 0 && !acceptance.emptyIsAccepting()) {
            ParityAcceptance parityAcceptance = new ParityAcceptance(1, ParityAcceptance.Parity.MIN_EVEN);
            Automaton<S, ParityAcceptance> universalAutomaton = SingletonAutomaton.of(automaton.factory(), sinkState, parityAcceptance, parityAcceptance.acceptingSet().orElseThrow());
            return HashMapAutomaton.copyOf(universalAutomaton);
        }
        if (acceptance.acceptanceSets() <= 1) {
            acceptance = acceptance.withAcceptanceSets(2);
            automaton.acceptance(acceptance);
        }
        MutableAutomatonUtil.complete(automaton, sinkState);
        automaton.acceptance(acceptance.complement());
        return automaton;
    }

    public static <S> Automaton<S, ParityAcceptance> convert(Automaton<S, ParityAcceptance> automaton, ParityAcceptance.Parity toParity, S sink) {
        int colours;
        if (automaton.acceptance().parity().equals((Object)toParity)) {
            return automaton;
        }
        MutableAutomaton<Object, ParityAcceptance> mutableAutomaton = MutableAutomatonUtil.asMutable(automaton);
        mutableAutomaton.updateAcceptance(x -> x.withAcceptanceSets(Math.max(3, x.acceptanceSets())));
        MutableAutomatonUtil.complete(mutableAutomaton, sink);
        ParityAcceptance fromAcceptance = (ParityAcceptance)mutableAutomaton.acceptance();
        if (fromAcceptance.parity().max()) {
            colours = fromAcceptance.acceptanceSets();
            mutableAutomaton.acceptance(fromAcceptance.withAcceptanceSets(colours + 2));
            mutableAutomaton.updateEdges((state, edge) -> {
                if (edge.hasAcceptanceSets()) {
                    return edge.withAcceptance(edge.largestAcceptanceSet() + 2);
                }
                return edge.withAcceptance(1);
            });
        } else {
            colours = fromAcceptance.acceptanceSets();
            mutableAutomaton.acceptance(fromAcceptance.withAcceptanceSets(colours + 2));
            mutableAutomaton.updateEdges((state, edge) -> {
                if (edge.hasAcceptanceSets()) {
                    return edge.withAcceptance(edge.smallestAcceptanceSet() + 2);
                }
                return edge.withAcceptance(colours);
            });
        }
        fromAcceptance = (ParityAcceptance)mutableAutomaton.acceptance();
        if (fromAcceptance.parity().max() == toParity.max()) {
            assert (fromAcceptance.parity().even() != toParity.even());
        } else {
            int leastImportantColor;
            int acceptanceSets = fromAcceptance.acceptanceSets();
            int n = leastImportantColor = fromAcceptance.parity().max() ? 0 : acceptanceSets - 1;
            int offset = fromAcceptance.parity().even() == toParity.even() ? (fromAcceptance.isAccepting(leastImportantColor) ? 0 : 1) : (fromAcceptance.isAccepting(leastImportantColor) ? -1 : -2);
            int newAcceptanceSets = acceptanceSets + offset;
            IntUnaryOperator mapping = i -> newAcceptanceSets - i;
            throw new UnsupportedOperationException("This combination of options is (currently) unsupported.");
        }
        IntUnaryOperator mapping = i -> i + 1;
        AtomicInteger maximalNewAcceptance = new AtomicInteger(0);
        mutableAutomaton.updateEdges((state, edge) -> {
            if (!edge.hasAcceptanceSets()) {
                throw new IllegalStateException();
            }
            int newAcceptance = mapping.applyAsInt(edge.smallestAcceptanceSet());
            if (maximalNewAcceptance.get() < newAcceptance) {
                maximalNewAcceptance.set(newAcceptance);
            }
            return edge.withAcceptance(newAcceptance);
        });
        mutableAutomaton.trim();
        mutableAutomaton.acceptance(new ParityAcceptance(maximalNewAcceptance.get() + 1, toParity));
        return mutableAutomaton;
    }
}

