/*
 * Decompiled with CFR 0.152.
 */
package owl.automaton.acceptance;

import java.util.Arrays;
import java.util.BitSet;
import java.util.List;
import java.util.Map;
import java.util.OptionalInt;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import jhoafparser.ast.AtomAcceptance;
import jhoafparser.ast.BooleanExpression;
import jhoafparser.extensions.BooleanExpressions;
import owl.automaton.Automaton;
import owl.automaton.EmptyAutomaton;
import owl.automaton.acceptance.AllAcceptance;
import owl.automaton.acceptance.BuchiAcceptance;
import owl.automaton.acceptance.CoBuchiAcceptance;
import owl.automaton.acceptance.EmersonLeiAcceptance;
import owl.automaton.acceptance.GeneralizedBuchiAcceptance;
import owl.automaton.acceptance.GeneralizedCoBuchiAcceptance;
import owl.automaton.acceptance.GeneralizedRabinAcceptance;
import owl.automaton.acceptance.OmegaAcceptance;
import owl.automaton.acceptance.ParityAcceptance;
import owl.automaton.acceptance.RabinAcceptance;
import owl.automaton.edge.Edge;
import owl.collections.Collections3;
import owl.collections.ValuationSet;
import owl.collections.ValuationTree;
import owl.factories.ValuationSetFactory;

public final class OmegaAcceptanceCast {
    private static final Map<Class<? extends OmegaAcceptance>, Function<AllAcceptance, OmegaAcceptance>> ALL_CAST_MAP = Map.of(BuchiAcceptance.class, x -> BuchiAcceptance.INSTANCE, CoBuchiAcceptance.class, x -> CoBuchiAcceptance.INSTANCE, GeneralizedBuchiAcceptance.class, x -> GeneralizedBuchiAcceptance.of(0), GeneralizedRabinAcceptance.class, x -> GeneralizedRabinAcceptance.of(GeneralizedRabinAcceptance.RabinPair.ofGeneralized(0, 0)), ParityAcceptance.class, x -> new ParityAcceptance(2, ParityAcceptance.Parity.MIN_EVEN), RabinAcceptance.class, x -> RabinAcceptance.of(1));
    private static final Map<Class<? extends OmegaAcceptance>, BiConsumer<AllAcceptance, BitSet>> ALL_EDGE_CAST_MAP = Map.of(BuchiAcceptance.class, (x, y) -> y.set(0), ParityAcceptance.class, (x, y) -> y.set(0), RabinAcceptance.class, (x, y) -> y.set(1));
    private static final Map<Class<? extends OmegaAcceptance>, Function<BuchiAcceptance, OmegaAcceptance>> BUCHI_CAST_MAP = Map.of(GeneralizedRabinAcceptance.class, x -> RabinAcceptance.of(1), ParityAcceptance.class, x -> new ParityAcceptance(2, ParityAcceptance.Parity.MIN_EVEN), RabinAcceptance.class, x -> RabinAcceptance.of(1));
    private static final Map<Class<? extends OmegaAcceptance>, BiConsumer<BuchiAcceptance, BitSet>> BUCHI_EDGE_CAST_MAP = Map.of(GeneralizedRabinAcceptance.class, (x, y) -> OmegaAcceptanceCast.bitSetShift(y), ParityAcceptance.class, (x, bitSet) -> {
        if (!bitSet.get(0)) {
            bitSet.set(1);
        }
    }, RabinAcceptance.class, (x, y) -> OmegaAcceptanceCast.bitSetShift(y));
    private static final Map<Class<? extends OmegaAcceptance>, Function<CoBuchiAcceptance, OmegaAcceptance>> CO_BUCHI_CAST_MAP = Map.of(GeneralizedRabinAcceptance.class, x -> GeneralizedRabinAcceptance.of(x.booleanExpression()), ParityAcceptance.class, x -> new ParityAcceptance(2, ParityAcceptance.Parity.MIN_ODD), RabinAcceptance.class, x -> RabinAcceptance.of(1));
    private static final Map<Class<? extends OmegaAcceptance>, BiConsumer<CoBuchiAcceptance, BitSet>> CO_BUCHI_EDGE_CAST_MAP = Map.of(ParityAcceptance.class, (x, bitSet) -> {
        if (!bitSet.get(0)) {
            bitSet.set(1);
        }
    }, RabinAcceptance.class, (x, bitSet) -> {
        if (!bitSet.get(0)) {
            bitSet.set(1);
        }
    });
    private static final Map<Class<? extends OmegaAcceptance>, Function<GeneralizedBuchiAcceptance, OmegaAcceptance>> GENERALIZED_BUCHI_CAST_MAP = Map.of(GeneralizedRabinAcceptance.class, x -> GeneralizedRabinAcceptance.of(GeneralizedRabinAcceptance.RabinPair.ofGeneralized(0, x.acceptanceSets())));
    private static final Map<Class<? extends OmegaAcceptance>, BiConsumer<GeneralizedBuchiAcceptance, BitSet>> GENERALIZED_BUCHI_EDGE_CAST_MAP = Map.of(GeneralizedRabinAcceptance.class, (x, y) -> OmegaAcceptanceCast.bitSetShift(y));
    private static final Map<Class<? extends OmegaAcceptance>, Function<GeneralizedCoBuchiAcceptance, OmegaAcceptance>> GENERALIZED_CO_BUCHI_CAST_MAP = Map.of(RabinAcceptance.class, x -> RabinAcceptance.of(x.size), GeneralizedRabinAcceptance.class, x -> GeneralizedRabinAcceptance.of(IntStream.range(0, x.size).mapToObj(i -> GeneralizedRabinAcceptance.RabinPair.ofGeneralized(i, 0)).collect(Collectors.toList())));
    private static final Map<Class<? extends OmegaAcceptance>, BiConsumer<GeneralizedCoBuchiAcceptance, BitSet>> GENERALIZED_CO_BUCHI_EDGE_CAST_MAP = Map.of(RabinAcceptance.class, (x, y) -> OmegaAcceptanceCast.bitSetSpread(x.size, y));

    private OmegaAcceptanceCast() {
    }

    public static <S, A extends OmegaAcceptance, B extends OmegaAcceptance> Automaton<S, B> cast(Automaton<S, A> automaton, Class<B> acceptanceClass) {
        Object oldAcceptance = automaton.acceptance();
        Class<?> oldAcceptanceClass = oldAcceptance.getClass();
        if (acceptanceClass.isAssignableFrom(oldAcceptanceClass)) {
            Automaton<S, A> castedAutomaton = automaton;
            return castedAutomaton;
        }
        if (acceptanceClass.equals(EmersonLeiAcceptance.class)) {
            return new CastedAutomaton<S, OmegaAcceptance, A>(automaton, (OmegaAcceptance)acceptanceClass.cast(new EmersonLeiAcceptance((OmegaAcceptance)automaton.acceptance())), null);
        }
        BiConsumer<?, BitSet> edgeCast = OmegaAcceptanceCast.edgeCastMap(oldAcceptanceClass).get(acceptanceClass);
        return new CastedAutomaton<S, B, A>(automaton, OmegaAcceptanceCast.cast(oldAcceptance, oldAcceptanceClass, acceptanceClass), edgeCast == null ? null : edge -> {
            BitSet set = edge.acceptanceSets();
            edgeCast.accept(oldAcceptance, set);
            return edge.withAcceptance(set);
        });
    }

    public static <S> Automaton<S, ?> castHeuristically(Automaton<S, ?> automaton) {
        BooleanExpression<AtomAcceptance> expression = ((OmegaAcceptance)automaton.acceptance()).booleanExpression();
        if (expression.isFALSE()) {
            return EmptyAutomaton.of(automaton.factory(), AllAcceptance.INSTANCE);
        }
        if (OmegaAcceptanceCast.detectAllAcceptance(expression)) {
            return new CastedAutomaton(automaton, AllAcceptance.INSTANCE, null);
        }
        if (OmegaAcceptanceCast.detectBuechi(expression)) {
            return new CastedAutomaton(automaton, BuchiAcceptance.INSTANCE, null);
        }
        if (OmegaAcceptanceCast.detectCoBuechi(expression)) {
            return new CastedAutomaton(automaton, CoBuchiAcceptance.INSTANCE, null);
        }
        OptionalInt size1 = OmegaAcceptanceCast.detectGeneralizedBuechi(expression);
        if (size1.isPresent()) {
            return new CastedAutomaton(automaton, GeneralizedBuchiAcceptance.of(size1.getAsInt()), null);
        }
        OptionalInt size2 = OmegaAcceptanceCast.detectGeneralizedCoBuechi(expression);
        if (size2.isPresent()) {
            return new CastedAutomaton(automaton, GeneralizedCoBuchiAcceptance.of(size2.getAsInt()), null);
        }
        int[] mapping = new int[((OmegaAcceptance)automaton.acceptance()).acceptanceSets()];
        OptionalInt size3 = OmegaAcceptanceCast.detectRabin(expression, mapping);
        if (size3.isPresent()) {
            return new CastedAutomaton(automaton, RabinAcceptance.of(size3.getAsInt()), edge -> edge.withAcceptance(x -> mapping[x]));
        }
        return automaton;
    }

    public static <A extends OmegaAcceptance, B extends OmegaAcceptance> B cast(A acceptance, Class<B> acceptanceClass) {
        Class<?> oldAcceptanceClass = acceptance.getClass();
        if (acceptanceClass.isAssignableFrom(oldAcceptanceClass)) {
            return (B)((OmegaAcceptance)acceptanceClass.cast(acceptance));
        }
        if (acceptanceClass.equals(EmersonLeiAcceptance.class)) {
            return (B)((OmegaAcceptance)acceptanceClass.cast(new EmersonLeiAcceptance(acceptance)));
        }
        return OmegaAcceptanceCast.cast(acceptance, oldAcceptanceClass, acceptanceClass);
    }

    public static boolean isInstanceOf(Class<? extends OmegaAcceptance> clazz1, Class<? extends OmegaAcceptance> clazz2) {
        return clazz2.isAssignableFrom(clazz1) || clazz2.equals(EmersonLeiAcceptance.class) || OmegaAcceptanceCast.castMap(clazz1).containsKey(clazz2);
    }

    private static void bitSetShift(BitSet bitSet) {
        for (int i = bitSet.length(); i > 0; --i) {
            bitSet.set(i, bitSet.get(i - 1));
        }
        bitSet.clear(0);
    }

    private static void bitSetSpread(int size, BitSet bitSet) {
        for (int i = size - 1; i >= 0; --i) {
            boolean fin = bitSet.get(i);
            bitSet.set(2 * i, fin);
            bitSet.set(2 * i + 1, !fin);
        }
    }

    private static <A extends OmegaAcceptance, B extends OmegaAcceptance> B cast(A acceptance, Class<A> oldClass, Class<B> newClass) {
        Function<A, OmegaAcceptance> cast = OmegaAcceptanceCast.castMap(oldClass).get(newClass);
        if (cast == null) {
            throw new ClassCastException(String.format("Cannot cast %s (%s) to %s.", oldClass.getSimpleName(), acceptance.booleanExpression(), newClass.getSimpleName()));
        }
        return (B)((OmegaAcceptance)newClass.cast(cast.apply(acceptance)));
    }

    private static <A extends OmegaAcceptance> Map<Class<? extends OmegaAcceptance>, Function<A, OmegaAcceptance>> castMap(Class<A> clazz) {
        if (AllAcceptance.class.equals(clazz)) {
            return ALL_CAST_MAP;
        }
        if (BuchiAcceptance.class.equals(clazz)) {
            return BUCHI_CAST_MAP;
        }
        if (CoBuchiAcceptance.class.equals(clazz)) {
            return CO_BUCHI_CAST_MAP;
        }
        if (GeneralizedBuchiAcceptance.class.equals(clazz)) {
            return GENERALIZED_BUCHI_CAST_MAP;
        }
        if (GeneralizedCoBuchiAcceptance.class.equals(clazz)) {
            return GENERALIZED_CO_BUCHI_CAST_MAP;
        }
        return Map.of();
    }

    private static <A extends OmegaAcceptance> Map<Class<? extends OmegaAcceptance>, BiConsumer<A, BitSet>> edgeCastMap(Class<A> clazz) {
        if (AllAcceptance.class.equals(clazz)) {
            return ALL_EDGE_CAST_MAP;
        }
        if (BuchiAcceptance.class.equals(clazz)) {
            return BUCHI_EDGE_CAST_MAP;
        }
        if (CoBuchiAcceptance.class.equals(clazz)) {
            return CO_BUCHI_EDGE_CAST_MAP;
        }
        if (GeneralizedBuchiAcceptance.class.equals(clazz)) {
            return GENERALIZED_BUCHI_EDGE_CAST_MAP;
        }
        if (GeneralizedCoBuchiAcceptance.class.equals(clazz)) {
            return GENERALIZED_CO_BUCHI_EDGE_CAST_MAP;
        }
        return Map.of();
    }

    private static boolean detectAllAcceptance(BooleanExpression<AtomAcceptance> expression) {
        return expression.isTRUE();
    }

    private static boolean detectBuechi(BooleanExpression<AtomAcceptance> expression) {
        if (!expression.isAtom()) {
            return false;
        }
        AtomAcceptance atom = (AtomAcceptance)expression.getAtom();
        return !atom.isNegated() && atom.getType() == AtomAcceptance.Type.TEMPORAL_INF;
    }

    private static OptionalInt detectGeneralizedBuechi(BooleanExpression<AtomAcceptance> expression) {
        BitSet usedSets = new BitSet();
        List<BooleanExpression<AtomAcceptance>> conjuncts = BooleanExpressions.getConjuncts(expression);
        for (BooleanExpression<AtomAcceptance> conjunct : conjuncts) {
            if (!OmegaAcceptanceCast.detectBuechi(conjunct)) {
                return OptionalInt.empty();
            }
            int set = ((AtomAcceptance)conjunct.getAtom()).getAcceptanceSet();
            if (usedSets.get(set)) {
                return OptionalInt.empty();
            }
            usedSets.set(set);
        }
        if (usedSets.cardinality() == usedSets.length()) {
            return OptionalInt.of(usedSets.length());
        }
        return OptionalInt.empty();
    }

    private static boolean detectCoBuechi(BooleanExpression<AtomAcceptance> expression) {
        if (!expression.isAtom()) {
            return false;
        }
        AtomAcceptance atom = (AtomAcceptance)expression.getAtom();
        return !atom.isNegated() && atom.getType() == AtomAcceptance.Type.TEMPORAL_FIN;
    }

    private static OptionalInt detectGeneralizedCoBuechi(BooleanExpression<AtomAcceptance> expression) {
        BitSet usedSets = new BitSet();
        List<BooleanExpression<AtomAcceptance>> disjuncts = BooleanExpressions.getDisjuncts(expression);
        for (BooleanExpression<AtomAcceptance> disjunct : disjuncts) {
            if (!OmegaAcceptanceCast.detectCoBuechi(disjunct)) {
                return OptionalInt.empty();
            }
            int set = ((AtomAcceptance)disjunct.getAtom()).getAcceptanceSet();
            if (usedSets.get(set)) {
                return OptionalInt.empty();
            }
            usedSets.set(set);
        }
        if (usedSets.cardinality() == usedSets.length()) {
            return OptionalInt.of(usedSets.length());
        }
        return OptionalInt.empty();
    }

    private static OptionalInt detectRabinPair(BooleanExpression<AtomAcceptance> expression, int[] mapping, int base) {
        List<BooleanExpression<AtomAcceptance>> conjuncts = BooleanExpressions.getConjuncts(expression);
        int infIndex = -1;
        int finIndex = -1;
        for (BooleanExpression<AtomAcceptance> conjunct : conjuncts) {
            AtomAcceptance atom = (AtomAcceptance)conjunct.getAtom();
            if (atom == null || atom.isNegated()) {
                return OptionalInt.empty();
            }
            if (atom.getType() == AtomAcceptance.Type.TEMPORAL_FIN) {
                if (finIndex >= 0) {
                    return OptionalInt.empty();
                }
                finIndex = atom.getAcceptanceSet();
                continue;
            }
            assert (atom.getType() == AtomAcceptance.Type.TEMPORAL_INF);
            if (infIndex >= 0) {
                return OptionalInt.empty();
            }
            infIndex = atom.getAcceptanceSet();
        }
        if (finIndex >= 0 && infIndex >= 0) {
            if (mapping[finIndex] >= 0) {
                return OptionalInt.empty();
            }
            mapping[finIndex] = base;
            if (mapping[infIndex] >= 0) {
                return OptionalInt.empty();
            }
            mapping[infIndex] = base + 1;
            return OptionalInt.of(2);
        }
        return OptionalInt.empty();
    }

    private static OptionalInt detectRabin(BooleanExpression<AtomAcceptance> expression, int[] mapping) {
        Arrays.fill(mapping, -1);
        int base = 0;
        List<BooleanExpression<AtomAcceptance>> disjuncts = BooleanExpressions.getDisjuncts(expression);
        for (BooleanExpression<AtomAcceptance> disjunct : disjuncts) {
            OptionalInt offset = OmegaAcceptanceCast.detectRabinPair(disjunct, mapping, base);
            if (offset.isPresent()) {
                base += offset.getAsInt();
                continue;
            }
            return OptionalInt.empty();
        }
        return OptionalInt.of(disjuncts.size());
    }

    private static class CastedAutomaton<S, A extends OmegaAcceptance, B extends OmegaAcceptance>
    implements Automaton<S, A> {
        private final A acceptance;
        private final Automaton<S, B> backingAutomaton;
        @Nullable
        private final Function<Edge<S>, Edge<S>> edgeCast;

        private CastedAutomaton(Automaton<S, B> backingAutomaton, A acceptance, @Nullable Function<Edge<S>, Edge<S>> edgeCast) {
            this.acceptance = acceptance;
            this.backingAutomaton = backingAutomaton;
            this.edgeCast = edgeCast;
        }

        @Override
        public A acceptance() {
            return this.acceptance;
        }

        @Override
        public ValuationSetFactory factory() {
            return this.backingAutomaton.factory();
        }

        @Override
        public Set<S> initialStates() {
            return this.backingAutomaton.initialStates();
        }

        @Override
        public Set<S> states() {
            return this.backingAutomaton.states();
        }

        @Override
        public Set<Edge<S>> edges(S state, BitSet valuation) {
            Set<Edge<S>> edges = this.backingAutomaton.edges(state, valuation);
            return this.edgeCast == null ? edges : Collections3.transformSet(edges, this.edgeCast);
        }

        @Override
        public Set<Edge<S>> edges(S state) {
            Set<Edge<S>> edges = this.backingAutomaton.edges(state);
            return this.edgeCast == null ? edges : Collections3.transformSet(edges, this.edgeCast);
        }

        @Override
        public Map<Edge<S>, ValuationSet> edgeMap(S state) {
            Map<Edge<S>, ValuationSet> edgeMap = this.backingAutomaton.edgeMap(state);
            return this.edgeCast == null ? edgeMap : Collections3.transformMap(edgeMap, this.edgeCast);
        }

        @Override
        public ValuationTree<Edge<S>> edgeTree(S state) {
            ValuationTree<Edge<S>> edgeTree = this.backingAutomaton.edgeTree(state);
            return this.edgeCast == null ? edgeTree : edgeTree.map(x -> Collections3.transformSet(x, this.edgeCast));
        }

        @Override
        public List<Automaton.PreferredEdgeAccess> preferredEdgeAccess() {
            return this.backingAutomaton.preferredEdgeAccess();
        }
    }
}

