/*
 * Decompiled with CFR 0.152.
 */
package owl.automaton.algorithm;

import com.google.common.base.Preconditions;
import owl.automaton.Automaton;
import owl.automaton.BooleanOperations;
import owl.automaton.acceptance.AllAcceptance;
import owl.automaton.acceptance.CoBuchiAcceptance;
import owl.automaton.acceptance.EmersonLeiAcceptance;
import owl.automaton.algorithm.LanguageEmptiness;
import owl.automaton.determinization.Determinization;
import owl.collections.Pair;

public final class LanguageContainment {
    private LanguageContainment() {
    }

    public static boolean contains(Automaton<?, ?> automaton1, Automaton<?, ?> automaton2) {
        Preconditions.checkArgument((boolean)automaton2.is(Automaton.Property.DETERMINISTIC), (Object)"Second argument needs to be deterministic.");
        Automaton<Object, EmersonLeiAcceptance> automaton2Complement = BooleanOperations.deterministicComplement(automaton2, new Object(), EmersonLeiAcceptance.class);
        Automaton<Pair<?, Object>, EmersonLeiAcceptance> intersection = BooleanOperations.intersection(automaton1, automaton2Complement, true);
        return LanguageEmptiness.isEmpty(intersection);
    }

    public static boolean containsCoBuchi(Automaton<?, CoBuchiAcceptance> automaton1, Automaton<?, CoBuchiAcceptance> automaton2) {
        if (automaton2.is(Automaton.Property.DETERMINISTIC)) {
            return LanguageContainment.contains(automaton1, automaton2);
        }
        return LanguageContainment.contains(automaton1, Determinization.determinizeCoBuchiAcceptance(automaton2));
    }

    public static boolean equalsCoBuchi(Automaton<?, CoBuchiAcceptance> automaton1, Automaton<?, CoBuchiAcceptance> automaton2) {
        return LanguageContainment.containsCoBuchi(automaton1, automaton2) && LanguageContainment.containsCoBuchi(automaton2, automaton1);
    }

    public static boolean containsAll(Automaton<?, AllAcceptance> automaton1, Automaton<?, AllAcceptance> automaton2) {
        if (automaton2.is(Automaton.Property.DETERMINISTIC)) {
            return LanguageContainment.contains(automaton1, automaton2);
        }
        return LanguageContainment.contains(automaton1, Determinization.determinizeAllAcceptance(automaton2));
    }

    public static boolean equalsAll(Automaton<?, AllAcceptance> automaton1, Automaton<?, AllAcceptance> automaton2) {
        return LanguageContainment.containsAll(automaton1, automaton2) && LanguageContainment.containsAll(automaton2, automaton1);
    }
}

