/*
 * Decompiled with CFR 0.152.
 */
package owl.automaton.algorithm.simulations;

import com.google.auto.value.AutoValue;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import owl.automaton.algorithm.simulations.AutoValue_BuchiSimulationArguments;

@AutoValue
public abstract class BuchiSimulationArguments {
    private static final Option optDirect = Option.builder((String)"di").longOpt("direct").desc("Compute direct simulation relation").build();
    private static final Option optDirectRefinement = Option.builder((String)"diref").longOpt("direct-refinement").desc("Compute direct simulation relation using color refinement (fast)").build();
    private static final Option optDelayed = Option.builder((String)"de").longOpt("delayed").desc("Compute delayed simulation relation").build();
    private static final Option optFair = Option.builder((String)"f").longOpt("fair").desc("Compute fair simulation relation").build();
    private static final Option optBackward = Option.builder((String)"bw").longOpt("backward").desc("Compute backwards simulation relation").build();
    private static final Option optLookaheadDirect = Option.builder((String)"diL").longOpt("lookahead-direct").desc("Compute direct simulation with lookahead").build();
    private static final Option optMaxLookahead = Option.builder((String)"l").longOpt("lookahead").desc("Make this many moves of Spoiler available to Duplicator").hasArg().argName("lookahead").type(Integer.class).build();
    private static final Option optSanity = Option.builder((String)"S").longOpt("sanity").desc("Sanity check different relation inclusions for input automaton.").build();
    private static final Option optPebbleCount = Option.builder((String)"c").longOpt("pebbles").desc("Allow duplicator to have the set amount of pebbles").hasArg().argName("pebbles").type(Integer.class).build();
    private static final Option optVerboseFine = Option.builder((String)"V").longOpt("verbose").desc("Use logging level FINE for more output").build();
    public static final Options options = new Options().addOption(optDirect).addOption(optVerboseFine).addOption(optDelayed).addOption(optBackward).addOption(optDirectRefinement).addOption(optMaxLookahead).addOption(optLookaheadDirect).addOption(optSanity).addOption(optFair).addOption(optPebbleCount);

    public static Builder builder() {
        return new AutoValue_BuchiSimulationArguments.Builder().setPebbleCount(1).setVerboseFine(false).setComputeFair(false).setComputeLookaheadDirect(false).setMaxLookahead(1).setSanity(false).setComputeBackward(false).setComputeDelayed(false).setComputeDirect(true).setComputeDirectRefinement(false);
    }

    public static BuchiSimulationArguments getFromCli(CommandLine cmdLine) {
        Builder builder = BuchiSimulationArguments.builder();
        builder.setComputeDirect(cmdLine.hasOption(optDirect.getOpt()));
        if (cmdLine.hasOption(optDelayed.getOpt())) {
            builder.setComputeDelayed(true);
            builder.setComputeDirect(false);
        }
        if (cmdLine.hasOption(optFair.getOpt())) {
            builder.setComputeFair(true);
            builder.setComputeDelayed(false);
            builder.setComputeDirect(false);
        }
        if (cmdLine.hasOption(optBackward.getOpt())) {
            builder.setComputeBackward(true);
            builder.setComputeDirect(false);
            builder.setComputeDelayed(false);
            builder.setComputeFair(false);
        }
        if (cmdLine.hasOption(optLookaheadDirect.getOpt())) {
            builder.setComputeBackward(false);
            builder.setComputeDirect(false);
            builder.setComputeDelayed(false);
            builder.setComputeFair(false);
            builder.setComputeLookaheadDirect(true);
        }
        if (cmdLine.hasOption(optDirectRefinement.getOpt())) {
            builder.setComputeBackward(false);
            builder.setComputeDirect(false);
            builder.setComputeDelayed(false);
            builder.setComputeFair(false);
            builder.setComputeLookaheadDirect(false);
            builder.setComputeDirectRefinement(true);
        }
        builder.setSanity(cmdLine.hasOption(optSanity.getOpt()));
        builder.setVerboseFine(cmdLine.hasOption(optVerboseFine.getOpt()));
        if (cmdLine.hasOption(optPebbleCount.getOpt())) {
            builder.setPebbleCount(Integer.parseInt(cmdLine.getOptionValue(optPebbleCount.getOpt())));
        }
        if (cmdLine.hasOption(optMaxLookahead.getOpt())) {
            builder.setMaxLookahead(Integer.parseInt(cmdLine.getOptionValue(optMaxLookahead.getOpt())));
        }
        return builder.build();
    }

    public abstract boolean computeDirect();

    public abstract boolean computeDelayed();

    public abstract boolean computeFair();

    public abstract boolean computeBackward();

    public abstract boolean computeLookaheadDirect();

    public abstract boolean computeDirectRefinement();

    public abstract boolean sanity();

    public abstract int pebbleCount();

    public abstract int maxLookahead();

    public abstract boolean verboseFine();

    @AutoValue.Builder
    static abstract class Builder {
        Builder() {
        }

        abstract Builder setComputeDirect(boolean var1);

        abstract Builder setComputeDelayed(boolean var1);

        abstract Builder setComputeFair(boolean var1);

        abstract Builder setComputeBackward(boolean var1);

        abstract Builder setComputeLookaheadDirect(boolean var1);

        abstract Builder setComputeDirectRefinement(boolean var1);

        abstract Builder setSanity(boolean var1);

        abstract Builder setPebbleCount(int var1);

        abstract Builder setMaxLookahead(int var1);

        abstract Builder setVerboseFine(boolean var1);

        abstract BuchiSimulationArguments build();
    }
}

