/*
 * Decompiled with CFR 0.152.
 */
package owl.automaton.algorithm.simulations;

import com.google.auto.value.AutoValue;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import owl.automaton.Automaton;
import owl.automaton.acceptance.BuchiAcceptance;
import owl.automaton.algorithm.simulations.AutoValue_ColorRefinement_NeighborType;
import owl.automaton.algorithm.simulations.AutoValue_ColorRefinement_Neighborhood;
import owl.automaton.edge.Edge;
import owl.collections.Pair;
import owl.collections.ValuationSet;
import owl.factories.ValuationSetFactory;
import owl.util.BitSetUtil;

public class ColorRefinement<S> {
    final Automaton<S, BuchiAcceptance> aut;
    final ValuationSetFactory factory;
    final Ordering po;
    Ordering oldPo;
    final Coloring<S> col;
    Coloring<S> oldCol;
    final Map<S, Pair<Integer, Neighborhood>> intermediate;

    private ColorRefinement(Automaton<S, BuchiAcceptance> automaton) {
        this.aut = automaton;
        this.factory = this.aut.factory();
        this.intermediate = new HashMap<S, Pair<Integer, Neighborhood>>();
        this.oldPo = new Ordering();
        this.oldCol = new Coloring();
        this.col = new Coloring();
        this.po = new Ordering();
        this.initialize();
    }

    private Set<Pair<S, S>> refine() {
        int iterations = 0;
        while (!this.po.equals(this.oldPo) || !this.col.equals(this.oldCol)) {
            if (iterations > 100000) {
                throw new AssertionError((Object)"refinement should terminate eventually");
            }
            ++iterations;
            this.oldCol = Coloring.copyOf(this.col);
            this.oldPo = Ordering.copyOf(this.po);
            for (S state : this.aut.states()) {
                this.intermediate.put(state, Pair.of(this.oldCol.get(state), Neighborhood.maximal(this.aut, state, this.oldPo, this.oldCol)));
            }
            ArrayList tmp = this.intermediate.values().stream().distinct().sorted((p1, p2) -> {
                if (!((Integer)p1.fst()).equals(p2.fst())) {
                    return ((Integer)p1.fst()).compareTo((Integer)p2.fst());
                }
                return ((Neighborhood)p1.snd()).compareTo((Neighborhood)p2.snd());
            }).collect(Collectors.toCollection(ArrayList::new));
            HashMap<Pair, Integer> norm = new HashMap<Pair, Integer>();
            int i = 0;
            for (Pair e : tmp) {
                norm.put(e, i++);
            }
            this.col.clear();
            for (Object state : this.aut.states()) {
                this.col.set(state, (Integer)norm.get(this.intermediate.get(state)));
            }
            this.po.clear();
            for (Object state1 : this.aut.states()) {
                Pair<Integer, Neighborhood> cc1 = this.intermediate.get(state1);
                for (S state2 : this.aut.states()) {
                    Pair<Integer, Neighborhood> cc2 = this.intermediate.get(state2);
                    if (!this.oldPo.leq(cc2.fst(), cc1.fst()) || !cc1.snd().dominates(this.oldPo, cc2.snd())) continue;
                    this.po.set(this.col.get(state2), this.col.get(state1));
                }
            }
        }
        HashSet<Pair<S, S>> out = new HashSet<Pair<S, S>>();
        for (S state1 : this.aut.states()) {
            for (S state2 : this.aut.states()) {
                if (!this.po.leq(this.col.get(state1), this.col.get(state2))) continue;
                out.add(Pair.of(state1, state2));
            }
        }
        return out;
    }

    private void initialize() {
        HashMap maxAcceptingVal = new HashMap();
        HashMap availableVal = new HashMap();
        HashMap<Object, Pair> interm = new HashMap<Object, Pair>();
        HashMap<Pair, Integer> intermC = new HashMap<Pair, Integer>();
        HashMap<ValuationSet, Integer> setColouring = new HashMap<ValuationSet, Integer>();
        HashMap<Integer, Pair> rIntermC = new HashMap<Integer, Pair>();
        this.aut.states().forEach(state -> {
            maxAcceptingVal.put(state, this.aut.factory().empty());
            this.aut.factory().universe().forEach(valuation -> {
                boolean hasAcceptingEdge = this.aut.edges(state, (BitSet)valuation).stream().anyMatch(edge -> this.aut.acceptance().isAcceptingEdge((Edge<?>)edge));
                if (hasAcceptingEdge) {
                    maxAcceptingVal.put(state, ((ValuationSet)maxAcceptingVal.get(state)).union(this.aut.factory().of((BitSet)valuation)));
                }
            });
        });
        this.aut.states().forEach(state -> {
            availableVal.put(state, this.aut.factory().empty());
            this.aut.edgeMap(state).forEach((edge, vSet) -> availableVal.put(state, ((ValuationSet)availableVal.get(state)).union((ValuationSet)vSet)));
        });
        this.aut.states().forEach(state -> interm.put(state, Pair.of((ValuationSet)availableVal.get(state), (ValuationSet)maxAcceptingVal.get(state))));
        int i = 0;
        for (ValuationSet set : maxAcceptingVal.values()) {
            if (setColouring.containsKey(set)) continue;
            setColouring.put(set, i++);
        }
        int j = 0;
        for (Pair p : interm.values()) {
            if (intermC.containsKey(p)) continue;
            intermC.put(p, j);
            rIntermC.put(j++, p);
        }
        interm.forEach((key, value) -> this.col.set(key, (Integer)intermC.get(value)));
        Iterator<Object> iterator = this.col.values().iterator();
        while (iterator.hasNext()) {
            int c = (Integer)iterator.next();
            for (Map.Entry entry : rIntermC.entrySet()) {
                Pair p1 = (Pair)rIntermC.get(c);
                Pair p2 = (Pair)entry.getValue();
                AtomicBoolean contained = new AtomicBoolean(true);
                ((ValuationSet)p1.fst()).forEach(val -> {
                    if (!((ValuationSet)p2.fst()).contains((BitSet)val)) {
                        contained.set(false);
                    }
                });
                if (!contained.get() || !this.aut.factory().implies((ValuationSet)p1.snd(), (ValuationSet)p2.snd())) continue;
                this.po.set(c, (Integer)entry.getKey());
            }
        }
    }

    public static <S> Set<Pair<S, S>> of(Automaton<S, BuchiAcceptance> automaton) {
        return new ColorRefinement<S>(automaton).refine();
    }

    private static class Ordering {
        private final Map<Integer, Set<Integer>> ord = new HashMap<Integer, Set<Integer>>();

        public int hashCode() {
            return this.ord.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof Ordering) {
                Ordering other = (Ordering)obj;
                return other.ord.equals(this.ord);
            }
            return false;
        }

        public int size() {
            return this.ord.entrySet().size();
        }

        public void clear() {
            this.ord.clear();
        }

        public static Ordering copyOf(Ordering other) {
            Ordering out = new Ordering();
            out.ord.putAll(other.ord);
            return out;
        }

        public void set(Integer a, Integer b) {
            Set curr = this.ord.getOrDefault(a, new HashSet());
            curr.add(b);
            this.ord.put(a, curr);
        }

        public boolean leq(Integer a, Integer b) {
            if (a.equals(b)) {
                return true;
            }
            return this.ord.getOrDefault(a, Set.of()).contains(b);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("ordering size: ").append(this.size()).append('\n');
            for (Map.Entry<Integer, Set<Integer>> entry : this.ord.entrySet()) {
                sb.append(entry.getKey()).append(" <= ").append(entry.getValue()).append('\n');
            }
            return sb.toString();
        }
    }

    private static class Coloring<S> {
        private final Map<S, Integer> col = new HashMap<S, Integer>();

        public Collection<Integer> values() {
            return this.col.values();
        }

        public int hashCode() {
            return this.col.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof Coloring) {
                Coloring other = (Coloring)obj;
                return this.col.equals(other.col);
            }
            return false;
        }

        public int size() {
            return this.col.entrySet().size();
        }

        public void clear() {
            this.col.clear();
        }

        public static <S> Coloring<S> copyOf(Coloring<S> other) {
            Coloring<S> out = new Coloring<S>();
            out.col.putAll(other.col);
            return out;
        }

        public void set(S state, Integer color) {
            this.col.put(state, color);
        }

        public Integer get(S state) {
            assert (this.col.containsKey(state));
            return this.col.get(state);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            for (Map.Entry<S, Integer> entry : this.col.entrySet()) {
                sb.append(entry.getKey()).append(" -> ").append(entry.getValue()).append('\n');
            }
            return sb.toString();
        }
    }

    @AutoValue
    public static abstract class Neighborhood {
        public abstract Set<NeighborType> types();

        public abstract ValuationSet available();

        public static Neighborhood of(Set<NeighborType> nts, ValuationSet available) {
            return new AutoValue_ColorRefinement_Neighborhood(nts, available);
        }

        public int compareTo(Neighborhood other) {
            if (this.equals(other)) {
                return 0;
            }
            if (this.types().size() < other.types().size()) {
                return -1;
            }
            if (this.types().size() > other.types().size()) {
                return 1;
            }
            ArrayList allOcc = this.types().stream().map(NeighborType::colour).collect(Collectors.toCollection(ArrayList::new));
            ArrayList allOtherOcc = other.types().stream().map(NeighborType::colour).collect(Collectors.toCollection(ArrayList::new));
            allOcc.sort(Integer::compareTo);
            allOtherOcc.sort(Integer::compareTo);
            for (int i = 0; i < Math.min(allOcc.size(), allOtherOcc.size()); ++i) {
                if (((Integer)allOcc.get(i)).equals(allOtherOcc.get(i))) continue;
                return ((Integer)allOcc.get(i)).compareTo((Integer)allOtherOcc.get(i));
            }
            return 0;
        }

        public static <S> Neighborhood maximal(Automaton<S, BuchiAcceptance> aut, S state, Ordering ord, Coloring<S> col) {
            HashSet nts = new HashSet();
            ValuationSet avail = aut.factory().empty();
            for (Map.Entry<Edge<S>, ValuationSet> e : aut.edgeMap(state).entrySet()) {
                avail = avail.union(e.getValue());
            }
            aut.edgeMap(state).forEach((edge, valSet) -> valSet.forEach(val -> nts.add(NeighborType.of(col.get(edge.successor()), val, aut.factory(), ((BuchiAcceptance)aut.acceptance()).isAcceptingEdge((Edge<?>)edge)))));
            Set<NeighborType> maximal = nts.stream().filter(nt -> nts.stream().filter(ntt -> !nt.equals(ntt)).noneMatch(ntt -> ntt.dominates((NeighborType)nt, ord))).collect(Collectors.toSet());
            return Neighborhood.of(maximal, avail);
        }

        public boolean dominates(Ordering ord, Neighborhood other) {
            if (this.equals(other)) {
                return true;
            }
            for (NeighborType nt : other.types()) {
                boolean isDom = this.types().stream().anyMatch(t -> t.dominates(nt, ord));
                if (isDom) continue;
                return false;
            }
            return other.available().factory().implies(other.available(), this.available());
        }
    }

    @AutoValue
    public static abstract class NeighborType {
        public abstract int colour();

        public abstract int valuation();

        public abstract boolean accepting();

        public abstract ValuationSetFactory factory();

        public static NeighborType of(int colour, BitSet set, ValuationSetFactory factory, boolean a) {
            return new AutoValue_ColorRefinement_NeighborType(colour, BitSetUtil.toInt(set), a, factory);
        }

        public boolean dominates(NeighborType other, Ordering ord) {
            return ord.leq(other.colour(), this.colour()) && other.valuation() == this.valuation() && (!other.accepting() || this.accepting());
        }

        public String toString() {
            return "(" + this.colour() + ", \"" + this.factory().toExpression(this.factory().of(BitSetUtil.fromInt(this.valuation()))) + "\") ";
        }
    }
}

