/*
 * Decompiled with CFR 0.152.
 */
package owl.cinterface;

import java.util.Arrays;
import java.util.Objects;
import org.graalvm.nativeimage.ImageInfo;
import org.graalvm.nativeimage.UnmanagedMemory;
import org.graalvm.nativeimage.c.type.CIntPointer;
import org.graalvm.word.PointerBase;
import org.graalvm.word.UnsignedWord;
import org.graalvm.word.WordFactory;
import owl.cinterface.CIntArray;
import owl.cinterface.emulation.EmulatedCIntPointer;
import owl.util.ArraysSupport;

public final class CIntArrayList {
    private CIntPointer elements;
    private int capacity;
    private int size;

    public CIntArrayList() {
        if (ImageInfo.inImageCode()) {
            this.elements = (CIntPointer)UnmanagedMemory.malloc((UnsignedWord)CIntArrayList.toBytesLength(64L));
            this.capacity = 64;
        } else {
            this.elements = new EmulatedCIntPointer(1);
            this.capacity = 1;
        }
        this.size = 0;
    }

    public void add(int value) {
        this.grow(this.size + 1);
        this.elements.write(this.size, value);
        ++this.size;
    }

    public void add(int value1, int value2) {
        this.grow(this.size + 2);
        this.elements.write(this.size, value1);
        this.elements.write(this.size + 1, value2);
        this.size += 2;
    }

    public void add(int value1, int value2, int value3) {
        this.grow(this.size + 3);
        this.elements.write(this.size, value1);
        this.elements.write(this.size + 1, value2);
        this.elements.write(this.size + 2, value3);
        this.size += 3;
    }

    public int get(int index) {
        Objects.checkIndex(index, this.size);
        return this.elements.read(index);
    }

    public void set(int index, int value) {
        Objects.checkIndex(index, this.size);
        this.elements.write(index, value);
    }

    public int size() {
        return this.size;
    }

    public void moveToArray(CIntArray cIntArray) {
        if (this.size == Integer.MIN_VALUE) {
            throw new IllegalStateException("already moved");
        }
        cIntArray.elements((CIntPointer)UnmanagedMemory.realloc((PointerBase)this.elements, (UnsignedWord)CIntArrayList.toBytesLength(this.size)));
        cIntArray.length(this.size);
        this.elements = (CIntPointer)WordFactory.nullPointer();
        this.size = Integer.MIN_VALUE;
    }

    public int[] toArray() {
        int length = this.size;
        int[] array = new int[length];
        for (int i = 0; i < length; ++i) {
            array[i] = this.get(i);
        }
        return array;
    }

    public String toString() {
        return Arrays.toString(this.toArray());
    }

    private void grow(int minCapacity) {
        if (this.capacity >= minCapacity) {
            return;
        }
        int newCapacity = ArraysSupport.newLength(this.capacity, minCapacity - this.capacity, this.capacity >> 1);
        this.elements = ImageInfo.inImageCode() ? (CIntPointer)UnmanagedMemory.realloc((PointerBase)this.elements, (UnsignedWord)CIntArrayList.toBytesLength(newCapacity)) : new EmulatedCIntPointer((EmulatedCIntPointer)this.elements, newCapacity);
        this.capacity = newCapacity;
    }

    private static UnsignedWord toBytesLength(long length) {
        return WordFactory.unsigned((long)(4L * length));
    }
}

