/*
 * Decompiled with CFR 0.152.
 */
package owl.cinterface;

import java.util.List;
import org.graalvm.nativeimage.IsolateThread;
import org.graalvm.nativeimage.ObjectHandle;
import org.graalvm.nativeimage.ObjectHandles;
import org.graalvm.nativeimage.UnmanagedMemory;
import org.graalvm.nativeimage.c.CContext;
import org.graalvm.nativeimage.c.function.CEntryPoint;
import org.graalvm.nativeimage.c.type.CCharPointer;
import org.graalvm.nativeimage.c.type.CTypeConversion;
import org.graalvm.word.PointerBase;
import org.graalvm.word.UnsignedWord;
import org.graalvm.word.WordFactory;
import owl.cinterface.CAutomaton;
import owl.cinterface.CDecomposedDPA;
import owl.run.Environment;
import owl.util.OwlVersion;

@CContext(value=CDirectives.class)
public final class CInterface {
    public static final String CALL_DESTROY = "This function returns a void pointer to an opaque Java object handle. The object is not collected by the garbage collected unless 'destroy_object_handle' is called on the pointer.";
    public static final String CHAR_TO_STRING = "Decodes a 0 terminated C char* to a Java string using the platform's default charset.";
    public static final Environment ENVIRONMENT = Environment.standard();

    private CInterface() {
    }

    @CEntryPoint(name="destroy_object_handle", exceptionHandler=PrintStackTraceAndExit.ReturnVoid.class)
    public static void destroyObjectHandle(IsolateThread thread, ObjectHandle handle) {
        ObjectHandles.getGlobal().destroy(handle);
    }

    @CEntryPoint(name="free_unmanaged_memory", exceptionHandler=PrintStackTraceAndExit.ReturnVoid.class)
    public static void freeUnmanagedMemory(IsolateThread thread, PointerBase ptr) {
        UnmanagedMemory.free((PointerBase)ptr);
    }

    @CEntryPoint(name="print_object_handle", exceptionHandler=PrintStackTraceAndExit.ReturnUnsignedWord.class)
    public static UnsignedWord printObjectHandle(IsolateThread thread, ObjectHandle handle, CCharPointer buffer, UnsignedWord bufferSize) {
        return CTypeConversion.toCString((CharSequence)ObjectHandles.getGlobal().get(handle).toString(), (CCharPointer)buffer, (UnsignedWord)bufferSize);
    }

    @CEntryPoint(name="owl_version", exceptionHandler=PrintStackTraceAndExit.ReturnUnsignedWord.class)
    public static UnsignedWord owlVersion(IsolateThread thread, CCharPointer buffer, UnsignedWord bufferSize) {
        return CTypeConversion.toCString((CharSequence)OwlVersion.getNameAndVersion().version(), (CCharPointer)buffer, (UnsignedWord)bufferSize);
    }

    public static void main(String ... args) {
    }

    static final class PrintStackTraceAndExit {
        private PrintStackTraceAndExit() {
        }

        static void handleException(Throwable throwable) {
            throwable.printStackTrace(System.err);
            System.err.flush();
            System.exit(-1);
        }

        static final class ReturnVoid {
            private ReturnVoid() {
            }

            static void handleException(Throwable throwable) {
                PrintStackTraceAndExit.handleException(throwable);
            }
        }

        static final class ReturnNodeType {
            private ReturnNodeType() {
            }

            static CDecomposedDPA.Structure.NodeType handleException(Throwable throwable) {
                PrintStackTraceAndExit.handleException(throwable);
                return CDecomposedDPA.Structure.NodeType.AUTOMATON;
            }
        }

        static final class ReturnRealizabilityStatus {
            private ReturnRealizabilityStatus() {
            }

            static CDecomposedDPA.RealizabilityStatus handleException(Throwable throwable) {
                PrintStackTraceAndExit.handleException(throwable);
                return CDecomposedDPA.RealizabilityStatus.UNKNOWN;
            }
        }

        static final class ReturnAcceptance {
            private ReturnAcceptance() {
            }

            static CAutomaton.Acceptance handleException(Throwable throwable) {
                PrintStackTraceAndExit.handleException(throwable);
                return CAutomaton.Acceptance.BOTTOM;
            }
        }

        static final class ReturnInt {
            private ReturnInt() {
            }

            static int handleException(Throwable throwable) {
                PrintStackTraceAndExit.handleException(throwable);
                return Integer.MIN_VALUE;
            }
        }

        static final class ReturnBoolean {
            private ReturnBoolean() {
            }

            static boolean handleException(Throwable throwable) {
                PrintStackTraceAndExit.handleException(throwable);
                return false;
            }
        }

        static final class ReturnUnsignedWord {
            private ReturnUnsignedWord() {
            }

            static UnsignedWord handleException(Throwable throwable) {
                PrintStackTraceAndExit.handleException(throwable);
                return WordFactory.unsigned((long)Long.MIN_VALUE);
            }
        }

        static final class ReturnObjectHandle {
            private ReturnObjectHandle() {
            }

            static ObjectHandle handleException(Throwable throwable) {
                PrintStackTraceAndExit.handleException(throwable);
                return ObjectHandles.getGlobal().create(null);
            }
        }
    }

    static class CDirectives
    implements CContext.Directives {
        CDirectives() {
        }

        public List<String> getHeaderFiles() {
            String headerLocation = System.getProperty("owlHeader");
            if (headerLocation == null) {
                throw new IllegalArgumentException("Location of header file is missing.Use -DowlHeader=/foo/bar/ to define location.");
            }
            return List.of(String.format("\"%s/owltypes.h\"", headerLocation));
        }
    }
}

