/*
 * Decompiled with CFR 0.152.
 */
package owl.cinterface.emulation;

import java.util.Arrays;
import org.graalvm.nativeimage.c.type.CIntPointer;
import org.graalvm.word.SignedWord;
import owl.cinterface.emulation.EmulatedPointerBase;

public class EmulatedCIntPointer
extends EmulatedPointerBase
implements CIntPointer {
    private final int[] backingArray;
    private final int offset;

    public EmulatedCIntPointer(int length) {
        this.backingArray = new int[length];
        this.offset = 0;
    }

    public EmulatedCIntPointer(int[] backingArray) {
        this.backingArray = Arrays.copyOf(backingArray, backingArray.length);
        this.offset = 0;
    }

    public EmulatedCIntPointer(EmulatedCIntPointer oldPointer, int newLength) {
        this.backingArray = Arrays.copyOf(oldPointer.backingArray, newLength);
        this.offset = 0;
    }

    public EmulatedCIntPointer(int length, int defaultValue) {
        this.backingArray = new int[length];
        this.offset = 0;
        Arrays.fill(this.backingArray, defaultValue);
    }

    private EmulatedCIntPointer(int[] backingArray, int offset) {
        this.backingArray = backingArray;
        this.offset = offset;
    }

    public int read() {
        return this.backingArray[this.offset];
    }

    public int read(int index) {
        return this.backingArray[this.offset + index];
    }

    public int read(SignedWord index) {
        throw EmulatedCIntPointer.uoe();
    }

    public void write(int value) {
        this.backingArray[this.offset] = value;
    }

    public void write(int index, int value) {
        this.backingArray[index + this.offset] = value;
    }

    public void write(SignedWord index, int value) {
        throw EmulatedCIntPointer.uoe();
    }

    public CIntPointer addressOf(int index) {
        return new EmulatedCIntPointer(this.backingArray, this.offset + index);
    }

    public CIntPointer addressOf(SignedWord index) {
        throw EmulatedCIntPointer.uoe();
    }
}

