/*
 * Decompiled with CFR 0.152.
 */
package owl.factories.jbdd;

import de.tum.in.jbdd.Bdd;
import de.tum.in.jbdd.BddConfiguration;
import de.tum.in.jbdd.BddFactory;
import de.tum.in.jbdd.ImmutableBddConfiguration;
import java.util.List;
import owl.factories.EquivalenceClassFactory;
import owl.factories.FactorySupplier;
import owl.factories.ValuationSetFactory;
import owl.factories.jbdd.EquivalenceFactory;
import owl.factories.jbdd.ValuationFactory;

public final class JBddSupplier
implements FactorySupplier {
    private static final JBddSupplier INSTANCE = new JBddSupplier();

    private JBddSupplier() {
    }

    public static FactorySupplier async() {
        return INSTANCE;
    }

    private static Bdd create(int size) {
        ImmutableBddConfiguration configuration = ImmutableBddConfiguration.builder().logStatisticsOnShutdown(false).useGlobalComposeCache(false).integrityDuplicatesMaximalSize(50).cacheBinaryDivider(4).cacheTernaryDivider(4).growthFactor(2.0).build();
        return BddFactory.buildBddRecursive((int)size, (BddConfiguration)configuration);
    }

    @Override
    public EquivalenceClassFactory getEquivalenceClassFactory(List<String> atomicPropositions) {
        Bdd eqFactoryBdd = JBddSupplier.create(1024 * (atomicPropositions.size() + 1));
        return new EquivalenceFactory(eqFactoryBdd, atomicPropositions);
    }

    @Override
    public ValuationSetFactory getValuationSetFactory(List<String> atomicPropositions) {
        int alphabetSize = atomicPropositions.size();
        Bdd vsFactoryBdd = JBddSupplier.create(1024 * alphabetSize * alphabetSize + 256);
        return new ValuationFactory(vsFactoryBdd, atomicPropositions);
    }
}

