/*
 * Decompiled with CFR 0.152.
 */
package owl.ltl.rewriter;

import java.util.HashSet;
import owl.ltl.Conjunction;
import owl.ltl.Formula;
import owl.ltl.SyntacticFragment;
import owl.ltl.UOperator;
import owl.ltl.visitors.Converter;

public class CombineUntilVisitor
extends Converter {
    protected CombineUntilVisitor() {
        super(SyntacticFragment.ALL);
    }

    @Override
    public Formula visit(Conjunction conjunction) {
        HashSet<UOperator> candidates = new HashSet<UOperator>();
        HashSet<Formula> combinable = new HashSet<Formula>();
        HashSet<Formula> newCon = new HashSet<Formula>();
        for (Formula formula : conjunction.operands) {
            if (formula instanceof UOperator) {
                candidates.add((UOperator)formula);
                continue;
            }
            newCon.add(formula.accept(this));
        }
        for (UOperator uOperator : candidates) {
            Formula common = uOperator.rightOperand();
            for (UOperator u : candidates) {
                if (!u.rightOperand().equals(common)) continue;
                combinable.add(u.leftOperand().accept(this));
            }
            newCon.add(UOperator.of(Conjunction.of(combinable), common.accept(this)));
            combinable.clear();
        }
        return Conjunction.of(newCon);
    }
}

