/*
 * Decompiled with CFR 0.152.
 */
package owl.translations.canonical;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.BitSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import owl.automaton.Automaton;
import owl.automaton.acceptance.OmegaAcceptance;
import owl.automaton.edge.Edge;
import owl.collections.Collections3;
import owl.collections.Either;
import owl.collections.ValuationSet;
import owl.collections.ValuationTree;
import owl.factories.ValuationSetFactory;

public final class GenericConstructions {
    private GenericConstructions() {
    }

    public static <S, A extends OmegaAcceptance> Automaton<Either<Integer, S>, A> delay(final Automaton<S, A> automaton, final int steps) {
        Preconditions.checkArgument((steps > 0 ? 1 : 0) != 0, (Object)"steps needs to be positive.");
        final List delayingStates = IntStream.range(0, steps).mapToObj(Either::left).collect(Collectors.toUnmodifiableList());
        final Set<Edge> initialStateEdges = Set.copyOf(Collections3.transformSet(automaton.initialStates(), x -> Edge.of(Either.right(x))));
        return new Automaton<Either<Integer, S>, A>(){

            @Override
            public A acceptance() {
                return automaton.acceptance();
            }

            @Override
            public ValuationSetFactory factory() {
                return automaton.factory();
            }

            @Override
            public Set<Either<Integer, S>> initialStates() {
                return Set.of((Either)delayingStates.get(steps - 1));
            }

            @Override
            public Set<Either<Integer, S>> states() {
                return Sets.union(Set.copyOf(delayingStates), Collections3.transformSet(automaton.states(), Either::right));
            }

            @Override
            public Set<Edge<Either<Integer, S>>> edges(Either<Integer, S> state, BitSet valuation) {
                return state.map(this::next, s -> this.lift(automaton.edges(s, valuation)));
            }

            @Override
            public Map<Edge<Either<Integer, S>>, ValuationSet> edgeMap(Either<Integer, S> state) {
                return state.map(this::nextMap, y -> this.lift(automaton.edgeMap(y)));
            }

            @Override
            public ValuationTree<Edge<Either<Integer, S>>> edgeTree(Either<Integer, S> state) {
                return state.map(this::nextTree, s -> this.lift(automaton.edgeTree(s)));
            }

            private Set<Edge<Either<Integer, S>>> next(int index) {
                if (index > 0) {
                    return Set.of(Edge.of((Either)delayingStates.get(index - 1)));
                }
                return initialStateEdges;
            }

            private Map<Edge<Either<Integer, S>>, ValuationSet> nextMap(int index) {
                return Maps.toMap(this.next(index), z -> this.factory().universe());
            }

            private ValuationTree<Edge<Either<Integer, S>>> nextTree(int index) {
                return ValuationTree.of(this.next(index));
            }

            private Set<Edge<Either<Integer, S>>> lift(Set<Edge<S>> edges) {
                return Collections3.transformSet(edges, edge -> edge.withSuccessor(Either.right(edge.successor())));
            }

            private Map<Edge<Either<Integer, S>>, ValuationSet> lift(Map<Edge<S>, ValuationSet> edgeMap) {
                return Collections3.transformMap(edgeMap, edge -> edge.withSuccessor(Either.right(edge.successor())));
            }

            private ValuationTree<Edge<Either<Integer, S>>> lift(ValuationTree<Edge<S>> edgeTree) {
                return edgeTree.map(this::lift);
            }

            @Override
            public List<Automaton.PreferredEdgeAccess> preferredEdgeAccess() {
                return automaton.preferredEdgeAccess();
            }
        };
    }
}

