/*
 * Decompiled with CFR 0.152.
 */
package owl.translations.modules;

import javax.annotation.Nullable;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionGroup;
import org.apache.commons.cli.Options;
import owl.translations.modules.AbstractLTL2PortfolioModule;
import owl.translations.rabinizer.RabinizerConfiguration;

final class AbstractLTL2DRAModule {
    private AbstractLTL2DRAModule() {
    }

    private static Option asymmetric() {
        return new Option("a", "asymmetric", false, "Guess only greatest fixed-points (G,R,W) that are almost always true. This corresponds to the construction described in [EKS: FMSD'16].");
    }

    private static Option symmetric() {
        return new Option("s", "symmetric", false, "Guess greatest (G,R,W) and least (F,M,U) fixed-points that are almost always respectively infinitely often true. This corresponds to the construction described in [EKS: LICS'18]. This is the default selection.");
    }

    private static OptionGroup getOptionGroup() {
        OptionGroup group = new OptionGroup();
        group.addOption(AbstractLTL2DRAModule.asymmetric());
        group.addOption(AbstractLTL2DRAModule.symmetric());
        return group;
    }

    private static Options getAsymmetricOptions() {
        return new Options().addOption("ne", "noeager", false, "Disable eager construction. Only affects asymmetric construction.").addOption("np", "nosuspend", false, "Disable suspension detection. Only affects asymmetric construction.").addOption("ns", "nosupport", false, "Disable support based relevant formula analysis. Only affects asymmetric construction.");
    }

    static Options options() {
        return AbstractLTL2DRAModule.getAsymmetricOptions().addOptionGroup(AbstractLTL2DRAModule.getOptionGroup()).addOption(AbstractLTL2PortfolioModule.disablePortfolio());
    }

    @Nullable
    static RabinizerConfiguration parseAsymmetric(CommandLine commandLine) {
        if (commandLine.hasOption(AbstractLTL2DRAModule.symmetric().getOpt()) || !commandLine.hasOption(AbstractLTL2DRAModule.asymmetric().getOpt())) {
            return null;
        }
        boolean eager = !commandLine.hasOption("noeager");
        boolean support = !commandLine.hasOption("nosupport");
        boolean suspend = !commandLine.hasOption("nosuspend");
        return RabinizerConfiguration.of(eager, support, suspend);
    }
}

