/*
 * Decompiled with CFR 0.152.
 */
package owl.translations.nbadet;

import com.google.auto.value.AutoValue;
import com.google.common.collect.BiMap;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import owl.translations.nbadet.AutoValue_NbaDetConfSets;
import owl.translations.nbadet.NbaDetArgs;
import owl.translations.nbadet.NbaSccInfo;
import owl.util.BitSetUtil;

@AutoValue
public abstract class NbaDetConfSets {
    public abstract BitSet rsccStates();

    public abstract BitSet asccStates();

    public abstract ArrayList<BitSet> asccsStates();

    public abstract ArrayList<BitSet> dsccsStates();

    public abstract ArrayList<BitSet> msccsStates();

    public static <S> NbaDetConfSets of(NbaDetArgs args, NbaSccInfo<S> scci, BiMap<S, Integer> stateMap) {
        BitSet merged;
        HashSet<Integer> handled = new HashSet<Integer>();
        BitSet rejStatesBS = new BitSet();
        if (args.sepRej()) {
            Set rejStates = scci.rejSccs().stream().flatMap(i -> scci.sccDecomposition().sccs().get((int)i).stream()).collect(Collectors.toUnmodifiableSet());
            rejStatesBS = BitSetUtil.fromSet(rejStates, stateMap);
            handled.addAll(scci.rejSccs());
        }
        BitSet accStatesBS = new BitSet();
        ArrayList<BitSet> asccs = new ArrayList<BitSet>();
        if (args.sepAcc()) {
            List<Set> accSccs = scci.accSccs().stream().map(i -> scci.sccDecomposition().sccs().get((int)i)).collect(Collectors.toUnmodifiableList());
            Set accStates = accSccs.stream().flatMap(Collection::stream).collect(Collectors.toUnmodifiableSet());
            accStatesBS = BitSetUtil.fromSet(accStates, stateMap);
            accSccs.forEach(s -> asccs.add(BitSetUtil.fromSet(s, stateMap)));
            if (!args.sepAccCyc()) {
                merged = asccs.stream().reduce(BitSetUtil::union).orElse(new BitSet());
                asccs.clear();
                asccs.add(merged);
            }
            handled.addAll(scci.accSccs());
        }
        ArrayList<BitSet> dsccs = new ArrayList<BitSet>();
        if (args.sepDet()) {
            List unhDetSccs = scci.detSccs().stream().filter(i -> !handled.contains(i)).collect(Collectors.toUnmodifiableList());
            List<Set> expDetSccs = unhDetSccs.stream().map(i -> scci.sccDecomposition().sccs().get((int)i)).collect(Collectors.toUnmodifiableList());
            expDetSccs.forEach(s -> dsccs.add(BitSetUtil.fromSet(s, stateMap)));
            handled.addAll(unhDetSccs);
        }
        ArrayList<BitSet> msccs = new ArrayList<BitSet>();
        scci.ids().filter(i -> !handled.contains(i)).forEach(i -> msccs.add(BitSetUtil.fromSet(scci.sccDecomposition().sccs().get(i), stateMap)));
        if (!args.sepMix()) {
            merged = msccs.stream().reduce(BitSetUtil::union).orElse(new BitSet());
            msccs.clear();
            if (!merged.isEmpty()) {
                msccs.add(merged);
            }
        }
        return new AutoValue_NbaDetConfSets(rejStatesBS, accStatesBS, asccs, dsccs, msccs);
    }
}

