/*
 * Copyright (C) 2016 - 2020  (See AUTHORS)
 *
 * This file is part of Owl.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package owl.translations.nba2dpa;

import com.google.auto.value.AutoValue;
import com.google.auto.value.extension.memoized.Memoized;
import java.util.List;
import java.util.Set;
import owl.collections.Collections3;

@AutoValue
public abstract class RankingState<S> {

  public abstract Set<S> initialComponentStates();

  public abstract List<S> acceptingComponentStates();

  static <S> RankingState<S> of(Set<S> initialComponentStates, List<S> acceptingComponentStates) {
    var initialComponentStatesCopy = Set.copyOf(initialComponentStates);
    var acceptingComponentStatesCopy = List.copyOf(acceptingComponentStates);
    assert Collections3.isDistinct(acceptingComponentStatesCopy)
      : "The ranking is not distinct: " + acceptingComponentStatesCopy;
    return new AutoValue_RankingState<>(initialComponentStatesCopy, acceptingComponentStatesCopy);
  }

  @Override
  public abstract boolean equals(Object object);

  @Memoized
  @Override
  public abstract int hashCode();

  @Override
  public String toString() {
    return String.format("|%s :: %s|", initialComponentStates(), acceptingComponentStates());
  }
}
