/*
 * Decompiled with CFR 0.152.
 */
package owl.automaton.acceptance;

import java.util.BitSet;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import owl.automaton.acceptance.AllAcceptance;
import owl.automaton.acceptance.BuchiAcceptance;
import owl.automaton.acceptance.EmersonLeiAcceptance;
import owl.collections.ImmutableBitSet;
import owl.logic.propositional.PropositionalFormula;

public class GeneralizedBuchiAcceptance
extends EmersonLeiAcceptance {
    GeneralizedBuchiAcceptance(int size) {
        super(size);
    }

    public static GeneralizedBuchiAcceptance of(int size) {
        switch (size) {
            case 0: {
                return AllAcceptance.INSTANCE;
            }
            case 1: {
                return BuchiAcceptance.INSTANCE;
            }
        }
        return new GeneralizedBuchiAcceptance(size);
    }

    public static Optional<? extends GeneralizedBuchiAcceptance> ofPartial(PropositionalFormula<Integer> formula) {
        BitSet usedSets = new BitSet();
        for (PropositionalFormula<Integer> conjunct : PropositionalFormula.conjuncts(formula)) {
            if (!(conjunct instanceof PropositionalFormula.Variable)) {
                return Optional.empty();
            }
            usedSets.set((Integer)((PropositionalFormula.Variable)conjunct).variable);
        }
        if (usedSets.cardinality() == usedSets.length()) {
            return Optional.of(GeneralizedBuchiAcceptance.of(usedSets.length()));
        }
        return Optional.empty();
    }

    @Override
    protected final PropositionalFormula<Integer> lazyBooleanExpression() {
        return PropositionalFormula.Conjunction.of(IntStream.range(0, this.acceptanceSets()).mapToObj(PropositionalFormula.Variable::of).collect(Collectors.toList()));
    }

    @Override
    public String name() {
        return "generalized-Buchi";
    }

    @Override
    public List<Object> nameExtra() {
        return List.of(Integer.valueOf(this.acceptanceSets()));
    }

    @Override
    public final Optional<ImmutableBitSet> acceptingSet() {
        BitSet set = new BitSet();
        set.set(0, this.acceptanceSets());
        return Optional.of(ImmutableBitSet.copyOf(set));
    }

    @Override
    public final Optional<ImmutableBitSet> rejectingSet() {
        return this.acceptanceSets() == 0 ? Optional.empty() : Optional.of(ImmutableBitSet.of());
    }
}

