/*
 * Decompiled with CFR 0.152.
 */
package owl.automaton.acceptance;

import java.util.BitSet;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import owl.automaton.acceptance.CoBuchiAcceptance;
import owl.automaton.acceptance.EmersonLeiAcceptance;
import owl.collections.ImmutableBitSet;
import owl.logic.propositional.PropositionalFormula;

public class GeneralizedCoBuchiAcceptance
extends EmersonLeiAcceptance {
    GeneralizedCoBuchiAcceptance(int size) {
        super(size);
    }

    public static GeneralizedCoBuchiAcceptance of(int size) {
        return size == 1 ? CoBuchiAcceptance.INSTANCE : new GeneralizedCoBuchiAcceptance(size);
    }

    public static Optional<? extends GeneralizedCoBuchiAcceptance> ofPartial(PropositionalFormula<Integer> formula) {
        BitSet usedSets = new BitSet();
        for (PropositionalFormula<Integer> disjunct : PropositionalFormula.disjuncts(formula)) {
            if (!(disjunct instanceof PropositionalFormula.Negation) || !(((PropositionalFormula.Negation)disjunct).operand instanceof PropositionalFormula.Variable)) {
                return Optional.empty();
            }
            usedSets.set((Integer)((PropositionalFormula.Variable)((PropositionalFormula.Negation)disjunct).operand).variable);
        }
        if (usedSets.cardinality() == usedSets.length()) {
            return Optional.of(GeneralizedCoBuchiAcceptance.of(usedSets.length()));
        }
        return Optional.empty();
    }

    @Override
    protected final PropositionalFormula<Integer> lazyBooleanExpression() {
        return PropositionalFormula.Disjunction.of(IntStream.range(0, this.acceptanceSets()).mapToObj(x -> PropositionalFormula.Negation.of(PropositionalFormula.Variable.of(x))).collect(Collectors.toList()));
    }

    @Override
    public String name() {
        return "generalized-co-Buchi";
    }

    @Override
    public List<Object> nameExtra() {
        return List.of(Integer.valueOf(this.acceptanceSets()));
    }

    @Override
    public Optional<ImmutableBitSet> acceptingSet() {
        return this.acceptanceSets() == 0 ? Optional.empty() : Optional.of(ImmutableBitSet.of());
    }

    @Override
    public Optional<ImmutableBitSet> rejectingSet() {
        BitSet set = new BitSet();
        set.set(0, this.acceptanceSets());
        return Optional.of(ImmutableBitSet.copyOf(set));
    }
}

