/*
 * Decompiled with CFR 0.152.
 */
package owl.automaton.acceptance;

import java.util.BitSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import owl.automaton.Automaton;
import owl.automaton.acceptance.AllAcceptance;
import owl.automaton.acceptance.BuchiAcceptance;
import owl.automaton.acceptance.CoBuchiAcceptance;
import owl.automaton.acceptance.EmersonLeiAcceptance;
import owl.automaton.acceptance.GeneralizedBuchiAcceptance;
import owl.automaton.acceptance.GeneralizedCoBuchiAcceptance;
import owl.automaton.acceptance.GeneralizedRabinAcceptance;
import owl.automaton.acceptance.ParityAcceptance;
import owl.automaton.acceptance.RabinAcceptance;
import owl.automaton.edge.Edge;
import owl.bdd.BddSet;
import owl.bdd.BddSetFactory;
import owl.bdd.MtBdd;
import owl.collections.Collections3;

public final class OmegaAcceptanceCast {
    private static final Map<Class<? extends EmersonLeiAcceptance>, Function<AllAcceptance, EmersonLeiAcceptance>> ALL_CAST_MAP = Map.of(BuchiAcceptance.class, x -> BuchiAcceptance.INSTANCE, CoBuchiAcceptance.class, x -> CoBuchiAcceptance.INSTANCE, GeneralizedRabinAcceptance.class, x -> GeneralizedRabinAcceptance.of(GeneralizedRabinAcceptance.RabinPair.ofGeneralized(0, 0)), ParityAcceptance.class, x -> new ParityAcceptance(2, ParityAcceptance.Parity.MIN_EVEN), RabinAcceptance.class, x -> RabinAcceptance.of(1));
    private static final Map<Class<? extends EmersonLeiAcceptance>, BiConsumer<AllAcceptance, BitSet>> ALL_EDGE_CAST_MAP = Map.of(BuchiAcceptance.class, (x, y) -> y.set(0), ParityAcceptance.class, (x, y) -> y.set(0), RabinAcceptance.class, (x, y) -> y.set(1));
    private static final Map<Class<? extends EmersonLeiAcceptance>, Function<BuchiAcceptance, EmersonLeiAcceptance>> BUCHI_CAST_MAP = Map.of(GeneralizedRabinAcceptance.class, x -> RabinAcceptance.of(1), ParityAcceptance.class, x -> new ParityAcceptance(2, ParityAcceptance.Parity.MIN_EVEN), RabinAcceptance.class, x -> RabinAcceptance.of(1));
    private static final Map<Class<? extends EmersonLeiAcceptance>, BiConsumer<BuchiAcceptance, BitSet>> BUCHI_EDGE_CAST_MAP = Map.of(GeneralizedRabinAcceptance.class, (x, y) -> OmegaAcceptanceCast.bitSetShift(y), ParityAcceptance.class, (x, bitSet) -> {
        if (!bitSet.get(0)) {
            bitSet.set(1);
        }
    }, RabinAcceptance.class, (x, y) -> OmegaAcceptanceCast.bitSetShift(y));
    private static final Map<Class<? extends EmersonLeiAcceptance>, Function<CoBuchiAcceptance, EmersonLeiAcceptance>> CO_BUCHI_CAST_MAP = Map.of(GeneralizedRabinAcceptance.class, x -> GeneralizedRabinAcceptance.ofPartial(x.booleanExpression()).orElseThrow(), ParityAcceptance.class, x -> new ParityAcceptance(2, ParityAcceptance.Parity.MIN_ODD), RabinAcceptance.class, x -> RabinAcceptance.of(1));
    private static final Map<Class<? extends EmersonLeiAcceptance>, BiConsumer<CoBuchiAcceptance, BitSet>> CO_BUCHI_EDGE_CAST_MAP = Map.of(ParityAcceptance.class, (x, bitSet) -> {
        if (!bitSet.get(0)) {
            bitSet.set(1);
        }
    }, RabinAcceptance.class, (x, bitSet) -> {
        if (!bitSet.get(0)) {
            bitSet.set(1);
        }
    });
    private static final Map<Class<? extends EmersonLeiAcceptance>, Function<GeneralizedBuchiAcceptance, EmersonLeiAcceptance>> GENERALIZED_BUCHI_CAST_MAP = Map.of(GeneralizedRabinAcceptance.class, x -> GeneralizedRabinAcceptance.of(GeneralizedRabinAcceptance.RabinPair.ofGeneralized(0, x.acceptanceSets())));
    private static final Map<Class<? extends EmersonLeiAcceptance>, BiConsumer<GeneralizedBuchiAcceptance, BitSet>> GENERALIZED_BUCHI_EDGE_CAST_MAP = Map.of(GeneralizedRabinAcceptance.class, (x, y) -> OmegaAcceptanceCast.bitSetShift(y));
    private static final Map<Class<? extends EmersonLeiAcceptance>, Function<GeneralizedCoBuchiAcceptance, EmersonLeiAcceptance>> GENERALIZED_CO_BUCHI_CAST_MAP = Map.of(RabinAcceptance.class, x -> RabinAcceptance.of(x.acceptanceSets()), GeneralizedRabinAcceptance.class, x -> GeneralizedRabinAcceptance.of(IntStream.range(0, x.acceptanceSets()).mapToObj(i -> GeneralizedRabinAcceptance.RabinPair.ofGeneralized(i, 0)).collect(Collectors.toList())));
    private static final Map<Class<? extends EmersonLeiAcceptance>, BiConsumer<GeneralizedCoBuchiAcceptance, BitSet>> GENERALIZED_CO_BUCHI_EDGE_CAST_MAP = Map.of(RabinAcceptance.class, (x, y) -> OmegaAcceptanceCast.bitSetSpread(x.acceptanceSets(), y));

    private OmegaAcceptanceCast() {
    }

    public static <S, A extends EmersonLeiAcceptance, B extends EmersonLeiAcceptance> Automaton<S, ? extends B> cast(Automaton<S, A> automaton, Class<? extends B> acceptanceClass) {
        Object oldAcceptance = automaton.acceptance();
        if (acceptanceClass.isAssignableFrom(oldAcceptance.getClass())) {
            Automaton<S, A> castedAutomaton = automaton;
            return castedAutomaton;
        }
        assert (!acceptanceClass.equals(EmersonLeiAcceptance.class));
        Class<?> oldAcceptanceClass = oldAcceptance.getClass();
        BiConsumer<?, BitSet> edgeCast = OmegaAcceptanceCast.edgeCastMap(oldAcceptanceClass).get(acceptanceClass);
        return new CastedAutomaton<S, B>(automaton, OmegaAcceptanceCast.cast(oldAcceptance, oldAcceptanceClass, acceptanceClass), edgeCast == null ? null : edge -> {
            BitSet set = edge.colours().copyInto(new BitSet());
            edgeCast.accept(oldAcceptance, set);
            return edge.withAcceptance(set);
        });
    }

    public static boolean isInstanceOf(Class<? extends EmersonLeiAcceptance> clazz1, Class<? extends EmersonLeiAcceptance> clazz2) {
        return clazz2.isAssignableFrom(clazz1) || clazz2.equals(EmersonLeiAcceptance.class) || OmegaAcceptanceCast.castMap(clazz1).containsKey(clazz2);
    }

    private static void bitSetShift(BitSet bitSet) {
        for (int i = bitSet.length(); i > 0; --i) {
            bitSet.set(i, bitSet.get(i - 1));
        }
        bitSet.clear(0);
    }

    private static void bitSetSpread(int size, BitSet bitSet) {
        for (int i = size - 1; i >= 0; --i) {
            boolean fin = bitSet.get(i);
            bitSet.set(2 * i, fin);
            bitSet.set(2 * i + 1, !fin);
        }
    }

    private static <A extends EmersonLeiAcceptance, B extends EmersonLeiAcceptance> B cast(A acceptance, Class<A> oldClass, Class<B> newClass) {
        Function<A, EmersonLeiAcceptance> cast = OmegaAcceptanceCast.castMap(oldClass).get(newClass);
        if (cast == null) {
            throw new ClassCastException(String.format("Cannot cast %s (%s) to %s.", oldClass.getSimpleName(), acceptance.booleanExpression(), newClass.getSimpleName()));
        }
        return (B)((EmersonLeiAcceptance)newClass.cast(cast.apply(acceptance)));
    }

    private static <A extends EmersonLeiAcceptance> Map<Class<? extends EmersonLeiAcceptance>, Function<A, EmersonLeiAcceptance>> castMap(Class<A> clazz) {
        if (AllAcceptance.class.equals(clazz)) {
            return ALL_CAST_MAP;
        }
        if (BuchiAcceptance.class.equals(clazz)) {
            return BUCHI_CAST_MAP;
        }
        if (CoBuchiAcceptance.class.equals(clazz)) {
            return CO_BUCHI_CAST_MAP;
        }
        if (GeneralizedBuchiAcceptance.class.equals(clazz)) {
            return GENERALIZED_BUCHI_CAST_MAP;
        }
        if (GeneralizedCoBuchiAcceptance.class.equals(clazz)) {
            return GENERALIZED_CO_BUCHI_CAST_MAP;
        }
        return Map.of();
    }

    private static <A extends EmersonLeiAcceptance> Map<Class<? extends EmersonLeiAcceptance>, BiConsumer<A, BitSet>> edgeCastMap(Class<A> clazz) {
        if (AllAcceptance.class.equals(clazz)) {
            return ALL_EDGE_CAST_MAP;
        }
        if (BuchiAcceptance.class.equals(clazz)) {
            return BUCHI_EDGE_CAST_MAP;
        }
        if (CoBuchiAcceptance.class.equals(clazz)) {
            return CO_BUCHI_EDGE_CAST_MAP;
        }
        if (GeneralizedBuchiAcceptance.class.equals(clazz)) {
            return GENERALIZED_BUCHI_EDGE_CAST_MAP;
        }
        if (GeneralizedCoBuchiAcceptance.class.equals(clazz)) {
            return GENERALIZED_CO_BUCHI_EDGE_CAST_MAP;
        }
        return Map.of();
    }

    private static class CastedAutomaton<S, A extends EmersonLeiAcceptance>
    implements Automaton<S, A> {
        private final A acceptance;
        private final Automaton<S, ?> backingAutomaton;
        @Nullable
        private final Function<Edge<S>, Edge<S>> edgeCast;

        private CastedAutomaton(Automaton<S, ?> backingAutomaton, A acceptance, @Nullable Function<Edge<S>, Edge<S>> edgeCast) {
            this.acceptance = acceptance;
            this.backingAutomaton = backingAutomaton;
            this.edgeCast = edgeCast;
        }

        @Override
        public A acceptance() {
            return this.acceptance;
        }

        @Override
        public List<String> atomicPropositions() {
            return this.backingAutomaton.atomicPropositions();
        }

        @Override
        public BddSetFactory factory() {
            return this.backingAutomaton.factory();
        }

        @Override
        public Set<S> initialStates() {
            return this.backingAutomaton.initialStates();
        }

        @Override
        public Set<S> states() {
            return this.backingAutomaton.states();
        }

        @Override
        public Set<Edge<S>> edges(S state) {
            Set<Edge<S>> edges = this.backingAutomaton.edges(state);
            return this.edgeCast == null ? edges : Collections3.transformSet(edges, this.edgeCast);
        }

        @Override
        public Set<Edge<S>> edges(S state, BitSet valuation) {
            Set<Edge<S>> edges = this.backingAutomaton.edges(state, valuation);
            return this.edgeCast == null ? edges : Collections3.transformSet(edges, this.edgeCast);
        }

        @Override
        public Map<Edge<S>, BddSet> edgeMap(S state) {
            Map<Edge<S>, BddSet> edgeMap = this.backingAutomaton.edgeMap(state);
            return this.edgeCast == null ? edgeMap : Collections3.transformMap(edgeMap, this.edgeCast);
        }

        @Override
        public MtBdd<Edge<S>> edgeTree(S state) {
            MtBdd<Edge<S>> edgeTree = this.backingAutomaton.edgeTree(state);
            return this.edgeCast == null ? edgeTree : edgeTree.map(x -> Collections3.transformSet(x, this.edgeCast));
        }
    }
}

