/*
 * Decompiled with CFR 0.152.
 */
package owl.automaton.acceptance.degeneralization;

import com.google.auto.value.AutoValue;
import com.google.auto.value.extension.memoized.Memoized;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import com.google.common.collect.Table;
import com.google.common.primitives.ImmutableIntArray;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import owl.automaton.AbstractMemoizingAutomaton;
import owl.automaton.AnnotatedState;
import owl.automaton.Automaton;
import owl.automaton.AutomatonUtil;
import owl.automaton.HashMapAutomaton;
import owl.automaton.MutableAutomatonUtil;
import owl.automaton.SuccessorFunction;
import owl.automaton.acceptance.GeneralizedRabinAcceptance;
import owl.automaton.acceptance.OmegaAcceptanceCast;
import owl.automaton.acceptance.RabinAcceptance;
import owl.automaton.acceptance.degeneralization.AutoValue_RabinDegeneralization_DegeneralizedRabinState;
import owl.automaton.algorithm.SccDecomposition;
import owl.automaton.edge.Edge;
import owl.bdd.BddSet;
import owl.collections.ImmutableBitSet;

public final class RabinDegeneralization {
    private RabinDegeneralization() {
    }

    public static <S> Automaton<?, ? extends RabinAcceptance> degeneralize(Automaton<S, ? extends GeneralizedRabinAcceptance> automaton) {
        if (automaton.acceptance() instanceof RabinAcceptance) {
            return OmegaAcceptanceCast.cast(automaton, RabinAcceptance.class);
        }
        ArrayList trackedPairs = new ArrayList();
        ArrayList noInfPairs = new ArrayList();
        automaton.acceptance().pairs().forEach(pair -> {
            if (pair.hasInfSet()) {
                trackedPairs.add(pair);
            } else {
                noInfPairs.add(pair);
            }
        });
        int trackedPairsCount = trackedPairs.size();
        int rabinCount = trackedPairsCount + noInfPairs.size();
        RabinAcceptance rabinAcceptance = RabinAcceptance.of(rabinCount);
        HashMap<Object, DegeneralizedRabinState<Object>> stateMap = new HashMap<Object, DegeneralizedRabinState<Object>>();
        HashBasedTable transientEdgesTable = HashBasedTable.create();
        HashMapAutomaton<DegeneralizedRabinState, RabinAcceptance> resultAutomaton = HashMapAutomaton.create(automaton.atomicPropositions(), automaton.factory(), rabinAcceptance);
        SccDecomposition<S> sccDecomposition = SccDecomposition.of(automaton);
        for (Set<S> scc : sccDecomposition.sccs()) {
            if (sccDecomposition.isTransientScc(scc)) {
                Object state2 = Iterables.getOnlyElement(scc);
                assert (!stateMap.containsKey(state2));
                DegeneralizedRabinState<Object> degeneralizedState = DegeneralizedRabinState.of(state2);
                resultAutomaton.addInitialState(degeneralizedState);
                stateMap.put(state2, degeneralizedState);
                Map successors2 = transientEdgesTable.row(degeneralizedState);
                automaton.edgeMap(state2).forEach((edge, valuations) -> successors2.merge(edge.successor(), valuations, BddSet::union));
                continue;
            }
            ImmutableBitSet indices = AutomatonUtil.getAcceptanceSets(automaton, scc);
            ArrayList<Integer> sccTrackedPairs = new ArrayList<Integer>(trackedPairsCount);
            int s = trackedPairs.size();
            for (int i = 0; i < s; ++i) {
                assert (((GeneralizedRabinAcceptance.RabinPair)trackedPairs.get(i)).hasInfSet());
                if (!((GeneralizedRabinAcceptance.RabinPair)trackedPairs.get(i)).infSetStream().allMatch(indices::contains)) continue;
                sccTrackedPairs.add(i);
            }
            assert (sccTrackedPairs.size() <= trackedPairsCount);
            DegeneralizedRabinState<S> initialSccState = DegeneralizedRabinState.of(scc.iterator().next(), new int[sccTrackedPairs.size()]);
            AbstractMemoizingAutomaton.EdgeMapImplementation sourceAutomaton = new AbstractMemoizingAutomaton.EdgeMapImplementation<DegeneralizedRabinState<S>, RabinAcceptance>(resultAutomaton.atomicPropositions(), resultAutomaton.factory(), Set.of(initialSccState), (RabinAcceptance)resultAutomaton.acceptance(), (Table)transientEdgesTable, automaton, scc, sccTrackedPairs, rabinCount, trackedPairs, rabinAcceptance, noInfPairs, trackedPairsCount){
                final /* synthetic */ Table val$transientEdgesTable;
                final /* synthetic */ Automaton val$automaton;
                final /* synthetic */ Set val$scc;
                final /* synthetic */ List val$sccTrackedPairs;
                final /* synthetic */ int val$rabinCount;
                final /* synthetic */ List val$trackedPairs;
                final /* synthetic */ RabinAcceptance val$rabinAcceptance;
                final /* synthetic */ List val$noInfPairs;
                final /* synthetic */ int val$trackedPairsCount;
                {
                    this.val$transientEdgesTable = table;
                    this.val$automaton = automaton;
                    this.val$scc = set;
                    this.val$sccTrackedPairs = list;
                    this.val$rabinCount = n;
                    this.val$trackedPairs = list2;
                    this.val$rabinAcceptance = rabinAcceptance;
                    this.val$noInfPairs = list3;
                    this.val$trackedPairsCount = n2;
                    super(atomicPropositions, factory, initialStates, acceptance);
                }

                @Override
                public Map<Edge<DegeneralizedRabinState<S>>, BddSet> edgeMapImpl(DegeneralizedRabinState<S> state) {
                    Object generalizedState = state.state();
                    Map transientSuccessors = this.val$transientEdgesTable.row(state);
                    HashMap successors = new HashMap();
                    this.val$automaton.edgeMap(generalizedState).forEach((edge, valuation) -> {
                        Object generalizedSuccessor = edge.successor();
                        if (!this.val$scc.contains(generalizedSuccessor)) {
                            transientSuccessors.merge(generalizedSuccessor, valuation, BddSet::union);
                            return;
                        }
                        int[] successorAwaitedIndices = new int[this.val$sccTrackedPairs.size()];
                        BitSet edgeAcceptance = new BitSet(this.val$rabinCount);
                        for (int sccPairIndex = 0; sccPairIndex < this.val$sccTrackedPairs.size(); ++sccPairIndex) {
                            int currentPairIndex = (Integer)this.val$sccTrackedPairs.get(sccPairIndex);
                            GeneralizedRabinAcceptance.RabinPair currentPair = (GeneralizedRabinAcceptance.RabinPair)this.val$trackedPairs.get(currentPairIndex);
                            int awaitedInfSet = state.awaitedInfSet(sccPairIndex);
                            if (edge.colours().contains(currentPair.finSet())) {
                                awaitedInfSet = 0;
                                edgeAcceptance.set(this.val$rabinAcceptance.pairs().get(currentPairIndex).finSet());
                            } else {
                                int infiniteIndexCount = currentPair.infSetCount();
                                int currentInfNumber = awaitedInfSet;
                                for (int i = 0; i < infiniteIndexCount; ++i) {
                                    currentInfNumber = (awaitedInfSet + i) % infiniteIndexCount;
                                    int currentInfIndex = currentPair.infSet(currentInfNumber);
                                    if (!edge.colours().contains(currentInfIndex)) break;
                                    if (currentInfNumber != infiniteIndexCount - 1) continue;
                                    edgeAcceptance.set(this.val$rabinAcceptance.pairs().get(currentPairIndex).infSet());
                                }
                                awaitedInfSet = currentInfNumber;
                            }
                            successorAwaitedIndices[sccPairIndex] = awaitedInfSet;
                        }
                        int s = this.val$noInfPairs.size();
                        for (int i = 0; i < s; ++i) {
                            int currentPairIndex = this.val$trackedPairsCount + i;
                            GeneralizedRabinAcceptance.RabinPair currentPair = this.val$rabinAcceptance.pairs().get(currentPairIndex);
                            edgeAcceptance.set(edge.colours().contains(((GeneralizedRabinAcceptance.RabinPair)this.val$noInfPairs.get(i)).finSet()) ? currentPair.finSet() : currentPair.infSet());
                        }
                        DegeneralizedRabinState successor = DegeneralizedRabinState.of(generalizedSuccessor, successorAwaitedIndices);
                        successors.merge(Edge.of(successor, edgeAcceptance), (BddSet)valuation, BddSet::union);
                    });
                    return successors;
                }
            };
            resultAutomaton.addInitialState(initialSccState);
            MutableAutomatonUtil.copyInto(sourceAutomaton, resultAutomaton);
            resultAutomaton.trim();
            SccDecomposition sccDecomposition2 = SccDecomposition.of(sourceAutomaton.states(), SuccessorFunction.filter(resultAutomaton, sourceAutomaton.states()));
            List sccs = sccDecomposition2.sccs();
            Set resultBscc = sccs.stream().filter(sccDecomposition2::isBottomScc).findFirst().orElseThrow();
            if (!resultBscc.isEmpty()) {
                resultAutomaton.addInitialState((DegeneralizedRabinState)resultBscc.iterator().next());
            }
            Sets.SetView transientStates = Sets.difference(sourceAutomaton.states(), (Set)resultBscc);
            resultAutomaton.removeStateIf(arg_0 -> transientStates.contains(arg_0));
            resultAutomaton.trim();
            resultBscc.forEach(state -> stateMap.putIfAbsent(state.state(), (DegeneralizedRabinState<Object>)state));
        }
        assert (stateMap.keySet().equals(automaton.states()));
        transientEdgesTable.rowMap().forEach((state, successors) -> successors.forEach((generalizedSuccessor, valuations) -> {
            DegeneralizedRabinState successor = (DegeneralizedRabinState)stateMap.get(generalizedSuccessor);
            resultAutomaton.addState((DegeneralizedRabinState)state);
            resultAutomaton.addEdge((DegeneralizedRabinState)state, (BddSet)valuations, Edge.of(successor));
        }));
        resultAutomaton.initialStates(automaton.initialStates().stream().map(stateMap::get).collect(Collectors.toList()));
        resultAutomaton.trim();
        return resultAutomaton;
    }

    @AutoValue
    public static abstract class DegeneralizedRabinState<S>
    implements AnnotatedState<S> {
        @Override
        public abstract S state();

        abstract ImmutableIntArray awaitedSets();

        static <S> DegeneralizedRabinState<S> of(S state) {
            return new AutoValue_RabinDegeneralization_DegeneralizedRabinState<S>(state, ImmutableIntArray.of());
        }

        static <S> DegeneralizedRabinState<S> of(S state, int[] awaitedSets) {
            return new AutoValue_RabinDegeneralization_DegeneralizedRabinState<S>(state, ImmutableIntArray.copyOf((int[])awaitedSets));
        }

        int awaitedInfSet(int generalizedPairIndex) {
            return this.awaitedSets().get(generalizedPairIndex);
        }

        public abstract boolean equals(Object var1);

        @Memoized
        public abstract int hashCode();

        public String toString() {
            return this.awaitedSets().isEmpty() ? String.format("{%s}", this.state()) : String.format("{%s|%s}", this.state(), this.awaitedSets());
        }
    }
}

