/*
 * Decompiled with CFR 0.152.
 */
package owl.automaton.acceptance.transformer;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import owl.collections.ImmutableBitSet;
import owl.logic.propositional.PropositionalFormula;
import owl.logic.propositional.sat.Solver;

public final class ZielonkaDag {
    private final PropositionalFormula<Integer> alpha;
    private final Map<ImmutableBitSet, List<ImmutableBitSet>> dag;

    public ZielonkaDag(PropositionalFormula<Integer> alpha) {
        this.alpha = alpha;
        this.dag = new HashMap<ImmutableBitSet, List<ImmutableBitSet>>();
        this.dag.put(ImmutableBitSet.of(), List.of());
    }

    public PropositionalFormula<Integer> alpha() {
        return this.alpha;
    }

    public List<ImmutableBitSet> children(ImmutableBitSet node) {
        List<ImmutableBitSet> children = this.dag.get(node);
        if (children != null) {
            return children;
        }
        List<Set<Integer>> maximalModels = Solver.maximalModels(this.alpha.evaluate(node) ? PropositionalFormula.Negation.of(this.alpha) : this.alpha, node);
        Object[] maximalModelsAsImmutableBitSets = new ImmutableBitSet[maximalModels.size()];
        int s = maximalModels.size();
        for (int i = 0; i < s; ++i) {
            maximalModelsAsImmutableBitSets[i] = ImmutableBitSet.copyOf((Collection<Integer>)maximalModels.get(i));
        }
        assert (Stream.of(maximalModelsAsImmutableBitSets).allMatch(successor -> this.alpha.evaluate(node) != this.alpha.evaluate((Set<Integer>)successor)));
        Arrays.sort(maximalModelsAsImmutableBitSets);
        List<Object> successors = List.of(maximalModelsAsImmutableBitSets);
        this.dag.put(node, successors);
        return successors;
    }
}

