/*
 * Decompiled with CFR 0.152.
 */
package owl.automaton.algorithm;

import com.google.auto.value.AutoValue;
import java.util.BitSet;
import java.util.Set;
import java.util.stream.Collectors;
import owl.automaton.AbstractMemoizingAutomaton;
import owl.automaton.AnnotatedState;
import owl.automaton.Automaton;
import owl.automaton.UltimatelyPeriodicWord;
import owl.automaton.acceptance.EmersonLeiAcceptance;
import owl.automaton.algorithm.AutoValue_LanguageMembership_IndexedState;
import owl.automaton.algorithm.LanguageEmptiness;
import owl.automaton.edge.Edge;
import owl.collections.ImmutableBitSet;

public final class LanguageMembership {
    private LanguageMembership() {
    }

    public static <S, A extends EmersonLeiAcceptance> boolean contains(Automaton<S, A> automaton, UltimatelyPeriodicWord word) {
        return !LanguageEmptiness.isEmpty(new IndexedAutomaton<S, A>(automaton, word));
    }

    private static final class IndexedAutomaton<S, A extends EmersonLeiAcceptance>
    extends AbstractMemoizingAutomaton.EdgesImplementation<IndexedState<S>, A> {
        private final Automaton<S, A> automaton;
        private final UltimatelyPeriodicWord word;

        private IndexedAutomaton(Automaton<S, A> automaton, UltimatelyPeriodicWord word) {
            super(automaton.atomicPropositions(), automaton.factory(), automaton.initialStates().stream().map(x -> IndexedState.of(-word.prefix.size(), x)).collect(Collectors.toUnmodifiableSet()), automaton.acceptance());
            this.automaton = automaton;
            this.word = word;
        }

        @Override
        protected Set<Edge<IndexedState<S>>> edgesImpl(IndexedState<S> state, BitSet valuation) {
            ImmutableBitSet allowedValuation = state.index() < 0 ? this.word.prefix.get(-state.index() - 1) : this.word.period.get(state.index());
            if (!allowedValuation.equals(ImmutableBitSet.copyOf(valuation))) {
                return Set.of();
            }
            Set<Edge<S>> edges = this.automaton.edges(state.state(), valuation);
            int nextIndex = state.index() + 1 >= this.word.period.size() ? (state.index() + 1) % this.word.period.size() : state.index() + 1;
            return edges.stream().map(x -> x.mapSuccessor(y -> IndexedState.of(nextIndex, y))).collect(Collectors.toUnmodifiableSet());
        }
    }

    @AutoValue
    static abstract class IndexedState<S>
    implements AnnotatedState<S> {
        IndexedState() {
        }

        public abstract int index();

        @Override
        public abstract S state();

        static <S> IndexedState<S> of(int index, S state) {
            return new AutoValue_LanguageMembership_IndexedState<S>(index, state);
        }
    }
}

